/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities.status;

import java.io.File;
import org.fcrepo.common.Constants;
import org.fcrepo.server.utilities.status.ServerState;
import org.fcrepo.server.utilities.status.ServerStatusFile;
import org.fcrepo.server.utilities.status.ServerStatusMessage;

public class ServerStatusTool {
    public static final int DEFAULT_STARTING_TIMEOUT = 45;
    public static final int DEFAULT_STARTUP_TIMEOUT = 120;
    public static final int DEFAULT_STOPPING_TIMEOUT = 45;
    public static final int DEFAULT_SHUTDOWN_TIMEOUT = 600;
    private final ServerStatusFile _statusFile;

    public ServerStatusTool(File serverHome) throws Exception {
        this._statusFile = new ServerStatusFile(serverHome);
    }

    public void init() throws Exception {
        ServerStatusMessage[] messages;
        ServerStatusMessage lastMessage;
        if (this._statusFile.exists() && (lastMessage = (messages = this.getAllMessages())[messages.length - 1]).getState() == ServerState.STARTED) {
            throw new Exception("The server is already running or was shut down unexpectedly.\nIf the server has shut down unexpectedly, you must manually delete\nthe following file: " + this._statusFile.getPath() + "\n" + "then try again.");
        }
        this._statusFile.clear();
        this._statusFile.append(ServerState.NOT_STARTING, "Waiting for startup to begin");
    }

    public void watchStartup(int startingTimeout, int startupTimeout) throws Exception {
        long startTime = System.currentTimeMillis();
        ServerStatusMessage[] messages = this.getAllMessages();
        ServerStatusMessage lastMessage = messages[messages.length - 1];
        boolean starting = false;
        boolean started = false;
        while (!started) {
            this.showStartup(messages);
            for (ServerStatusMessage element : messages) {
                ServerState state = element.getState();
                if (state == ServerState.STARTING) {
                    starting = true;
                    continue;
                }
                if (state == ServerState.STARTED) {
                    started = true;
                    continue;
                }
                if (state != ServerState.STARTUP_FAILED) continue;
                throw new Exception("Fedora startup failed (see above)");
            }
            if (started) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Throwable th) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            if (!starting && (now - startTime) / 1000L > (long)startingTimeout) {
                throw new Exception("Server startup did not begin within " + startingTimeout + " seconds");
            }
            if ((now - startTime) / 1000L > (long)startupTimeout) {
                throw new Exception("Server startup did not complete within " + startupTimeout + " seconds");
            }
            messages = this._statusFile.getMessages(lastMessage);
            if (messages.length <= 0) continue;
            lastMessage = messages[messages.length - 1];
        }
    }

    private void showStartup(ServerStatusMessage[] messages) {
        for (ServerStatusMessage element : messages) {
            ServerState state = element.getState();
            if (state == ServerState.STOPPING || state == ServerState.STOPPED) continue;
            String detail = element.getDetail();
            System.out.print(ServerStatusMessage.dateToString(element.getDate()) + " - ");
            if (state == ServerState.NOT_STARTING || state == ServerState.STARTING) {
                if (detail != null) {
                    System.out.println(detail);
                    continue;
                }
                System.out.println(element.getState().getName());
                continue;
            }
            System.out.println(element.getState().getName());
            if (detail == null) continue;
            System.out.println(detail);
        }
    }

    public void watchShutdown(int stoppingTimeout, int shutdownTimeout) throws Exception {
        if (!this._statusFile.exists()) {
            this._statusFile.append(ServerState.STOPPING, "WARNING: Server status file did not exist; re-created");
        }
        long startTime = System.currentTimeMillis();
        ServerStatusMessage[] messages = this.getAllMessages();
        ServerStatusMessage lastMessage = messages[messages.length - 1];
        boolean stopping = false;
        boolean stopped = false;
        while (!stopped) {
            this.showShutdown(messages);
            for (ServerStatusMessage element : messages) {
                ServerState state = element.getState();
                if (state == ServerState.STOPPING) {
                    stopping = true;
                    continue;
                }
                if (state == ServerState.STOPPED) {
                    stopped = true;
                    continue;
                }
                if (state != ServerState.STOPPED_WITH_ERR) continue;
                throw new Exception("Fedora shutdown finished with error (see above)");
            }
            if (stopped) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Throwable th) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            if (!stopping && (now - startTime) / 1000L > (long)stoppingTimeout) {
                throw new Exception("Server shutdown did not begin within " + stoppingTimeout + " seconds");
            }
            if ((now - startTime) / 1000L > (long)shutdownTimeout) {
                throw new Exception("Server shutdown did not complete within " + shutdownTimeout + " seconds");
            }
            messages = this._statusFile.getMessages(lastMessage);
            if (messages.length <= 0) continue;
            lastMessage = messages[messages.length - 1];
        }
    }

    private void showShutdown(ServerStatusMessage[] messages) {
        for (ServerStatusMessage element : messages) {
            ServerState state = element.getState();
            if (state != ServerState.STOPPING && state != ServerState.STOPPED && state != ServerState.STOPPED_WITH_ERR) continue;
            String detail = element.getDetail();
            System.out.print(ServerStatusMessage.dateToString(element.getDate()) + " - ");
            if (state == ServerState.STOPPING) {
                if (detail != null) {
                    System.out.println(detail);
                    continue;
                }
                System.out.println(element.getState().getName());
                continue;
            }
            System.out.println(element.getState().getName());
            if (state != ServerState.STOPPED_WITH_ERR || detail == null) continue;
            System.out.println(detail);
        }
    }

    public void showStatus() throws Exception {
        ServerStatusMessage message;
        if (this._statusFile.exists()) {
            ServerStatusMessage[] messages = this.getAllMessages();
            message = messages[messages.length - 1];
        } else {
            message = ServerStatusMessage.NEW_SERVER_MESSAGE;
        }
        System.out.println(message.toString());
    }

    private ServerStatusMessage[] getAllMessages() throws Exception {
        ServerState firstState;
        ServerStatusMessage[] messages = this._statusFile.getMessages(null);
        if (messages.length == 0) {
            System.out.println("WARNING: Server status file is empty; re-creating");
            this.init();
            messages = this._statusFile.getMessages(null);
        }
        if ((firstState = messages[0].getState()) != ServerState.NOT_STARTING) {
            System.out.println("WARNING: Server status file is missing one or more messages");
        }
        return messages;
    }

    private static void showUsage(String err) {
        if (err != null) {
            System.out.println("ERROR: " + err);
        }
        System.out.println("Usage: ServerStatusTool init");
        System.out.println("   Or: ServerStatusTool show-status");
        System.out.println("   Or: ServerStatusTool watch-startup [starting-timeout] [startup-timeout]");
        System.out.println("   Or: ServerStatusTool watch-shutdown [stopping-timeout] [shutdown-timeout]");
    }

    private static int getInt(String s) throws Exception {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new Exception("Not an integer: " + s);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            ServerStatusTool.showUsage(null);
            System.exit(1);
        } else {
            String cmd = args[0];
            if (cmd.equals("init") || cmd.equals("watch-startup") || cmd.equals("watch-shutdown") || cmd.equals("show-status")) {
                try {
                    String fedoraHome = Constants.FEDORA_HOME;
                    if (fedoraHome == null) {
                        throw new Exception("FEDORA_HOME is undefined");
                    }
                    File serverHome = new File(new File(fedoraHome), "server");
                    ServerStatusTool tool = new ServerStatusTool(serverHome);
                    if (cmd.equals("init")) {
                        tool.init();
                    } else if (cmd.equals("watch-startup")) {
                        int startingTimeout = 45;
                        int startupTimeout = 120;
                        if (args.length > 1) {
                            startingTimeout = ServerStatusTool.getInt(args[1]);
                            if (args.length > 2) {
                                startupTimeout = ServerStatusTool.getInt(args[2]);
                            }
                        }
                        tool.watchStartup(startingTimeout, startupTimeout);
                    } else if (cmd.equals("watch-shutdown")) {
                        int stoppingTimeout = 45;
                        int shutdownTimeout = 600;
                        if (args.length > 1) {
                            stoppingTimeout = ServerStatusTool.getInt(args[1]);
                            if (args.length > 2) {
                                shutdownTimeout = ServerStatusTool.getInt(args[2]);
                            }
                        }
                        tool.watchShutdown(stoppingTimeout, shutdownTimeout);
                    } else {
                        tool.showStatus();
                    }
                    System.exit(0);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null || !e.getClass().getName().equals("java.lang.Exception")) {
                        System.out.println("ERROR: " + e.getClass().getName());
                        e.printStackTrace();
                    } else {
                        System.out.println("ERROR: " + msg);
                    }
                    System.exit(1);
                }
            } else {
                ServerStatusTool.showUsage("Bad argument: " + cmd);
                System.exit(1);
            }
        }
    }
}

