/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.validation.DOValidator;
import org.fcrepo.server.validation.DOValidatorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOValidatorModule
extends Module
implements DOValidator {
    private static final Logger logger = LoggerFactory.getLogger(DOValidatorModule.class);
    private DOValidatorImpl dov = null;

    public DOValidatorModule(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException, ServerException {
        super(moduleParameters, server, role);
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        try {
            HashMap<String, String> xmlSchemaMap = new HashMap<String, String>();
            HashMap<String, String> ruleSchemaMap = new HashMap<String, String>();
            String tempDir = null;
            String schematronPreprocessorPath = null;
            Iterator<String> nameIter = this.parameterNames();
            while (nameIter.hasNext()) {
                String paramName = nameIter.next();
                if (paramName.startsWith("xsd_")) {
                    String xmlSchemaName = paramName.substring(4);
                    try {
                        String xmlSchemaPath = new File(this.getServer().getHomeDir(), this.getParameter(paramName)).getPath();
                        xmlSchemaMap.put(xmlSchemaName, xmlSchemaPath);
                        logger.debug("Initialized XML Schema location: " + xmlSchemaPath);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = "Problem configuring XML Schema for format=" + xmlSchemaName;
                        logger.error(msg, (Throwable)e);
                        throw new ModuleInitializationException(msg + ": " + e.getClass().getName() + ": " + e.getMessage(), this.getRole());
                    }
                }
                if (paramName.startsWith("rules_")) {
                    String ruleSchemaName = paramName.substring(6);
                    try {
                        String ruleSchemaPath = new File(this.getServer().getHomeDir(), this.getParameter(paramName)).getPath();
                        ruleSchemaMap.put(ruleSchemaName, ruleSchemaPath);
                        logger.debug("Initialized Schematron schema location: " + ruleSchemaPath);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = "Problem configuring Schematron Schema for format=" + ruleSchemaName;
                        logger.error(msg, (Throwable)e);
                        throw new ModuleInitializationException(msg + ": " + e.getClass().getName() + ": " + e.getMessage(), this.getRole());
                    }
                }
                if (paramName.equals("tempDir")) {
                    tempDir = new File(this.getServer().getHomeDir(), this.getParameter(paramName)).getPath();
                    logger.debug("tempDir set to: " + tempDir);
                    continue;
                }
                if (!paramName.equals("schtron_preprocessor")) continue;
                schematronPreprocessorPath = new File(this.getServer().getHomeDir(), this.getParameter(paramName)).getPath();
                logger.debug("Initialized Schematron preprocessor location: " + schematronPreprocessorPath);
            }
            this.dov = new DOValidatorImpl(tempDir, xmlSchemaMap, schematronPreprocessorPath, ruleSchemaMap);
        }
        catch (Exception e) {
            throw new ModuleInitializationException(e.getMessage(), "org.fcrepo.server.validation.DOValidatorModule");
        }
    }

    @Override
    public void validate(InputStream objectAsStream, String format, int validationType, String phase) throws ServerException {
        this.dov.validate(objectAsStream, format, validationType, phase);
    }

    @Override
    public void validate(File objectAsFile, String format, int validationType, String phase) throws ServerException {
        this.dov.validate(objectAsFile, format, validationType, phase);
    }
}

