/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOValidatorXMLErrorHandler
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DOValidatorXMLErrorHandler.class);

    @Override
    public void warning(SAXParseException e) throws SAXException {
        logger.warn("SAX WARNING (publicId=" + e.getPublicId() + ")", (Throwable)e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        logger.error("SAX ERROR (publicId=" + e.getPublicId() + ")", (Throwable)e);
        throw new SAXException(this.formatParseExceptionMsg(e));
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        logger.error("SAX FATAL ERROR (publicId=" + e.getPublicId() + ")", (Throwable)e);
        throw new SAXException(this.formatParseExceptionMsg(e));
    }

    private String formatParseExceptionMsg(SAXParseException spe) {
        String systemId = spe.getSystemId();
        if (systemId == null) {
            systemId = "null";
        }
        String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
        return info;
    }
}

