/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation.ecm;

import java.util.ArrayList;
import java.util.List;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.validation.ecm.Errors;
import org.fcrepo.server.validation.ecm.jaxb.DsTypeModel;
import org.fcrepo.server.validation.ecm.jaxb.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormValidator {
    private static final Logger logger = LoggerFactory.getLogger(FormValidator.class);

    void checkFormAndMime(DsTypeModel typeModel, Datastream objectDatastream, Validation validation, DOReader contentmodelReader) throws ServerException {
        List<Form> forms = typeModel.getForm();
        boolean valid = false;
        if (forms.size() == 0) {
            valid = true;
        }
        for (Form form : forms) {
            boolean uriMatch = true;
            if (form.getFORMATURI() != null && !form.getFORMATURI().equals(objectDatastream.DSFormatURI)) {
                uriMatch = false;
            }
            if (!uriMatch) continue;
            boolean mimeMatch = true;
            if (form.getMIME() != null && !form.getMIME().equals(objectDatastream.DSMIME)) {
                mimeMatch = false;
            }
            if (!mimeMatch || !uriMatch) continue;
            valid = true;
            break;
        }
        if (!valid) {
            String dsid = objectDatastream.DatastreamID;
            List<String> problems = validation.getDatastreamProblems().get(dsid);
            if (problems == null) {
                problems = new ArrayList<String>();
                validation.getDatastreamProblems().put(dsid, problems);
            }
            String contentmodel = contentmodelReader.GetObjectPID();
            problems.add(Errors.invalidFormatURIorMimeType(dsid, contentmodel));
            validation.setValid(false);
        }
    }
}

