/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.soapclient;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MethodParameterResolverServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static String SERVLET_PATH = null;
    private static final String soapClientPropertiesFile = "WEB-INF/soapclient.properties";

    public void init() throws ServletException {
        try {
            System.out.println("Realpath Properties File: " + this.getServletContext().getRealPath(soapClientPropertiesFile));
            FileInputStream fis = new FileInputStream(this.getServletContext().getRealPath(soapClientPropertiesFile));
            Properties p = new Properties();
            p.load(fis);
            SERVLET_PATH = p.getProperty("soapClientServletPath");
            System.out.println("soapClientServletPath: " + SERVLET_PATH);
        }
        catch (Throwable th) {
            String message = "[FedoraSOAPServlet] An error has occurred. The error was a \"" + th.getClass().getName() + "\"  . The " + "Reason: \"" + th.getMessage() + "\"  .";
            throw new ServletException(message);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String PID2 = null;
        String sDefPID = null;
        String methodName = null;
        String versDateTime = null;
        StringBuffer methodParms = new StringBuffer();
        Hashtable<String, String> h_methodParms = new Hashtable<String, String>();
        response.setContentType(HTML_CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        Enumeration parms = request.getParameterNames();
        while (parms.hasMoreElements()) {
            String name = new String((String)parms.nextElement());
            String value = new String(request.getParameter(name));
            if (name.equals("PID")) {
                PID2 = URLDecoder.decode(request.getParameter(name), "UTF-8");
                continue;
            }
            if (name.equals("sDefPID")) {
                sDefPID = URLDecoder.decode(request.getParameter(name), "UTF-8");
                continue;
            }
            if (name.equals("methodName")) {
                methodName = URLDecoder.decode(request.getParameter(name), "UTF-8");
                continue;
            }
            if (name.equals("asOfDateTime")) {
                versDateTime = request.getParameter(name);
                continue;
            }
            if (name.equals("Submit")) continue;
            h_methodParms.put(URLDecoder.decode(name, "UTF-8"), URLDecoder.decode(request.getParameter(name), "UTF-8"));
        }
        if (PID2 == null || PID2.equalsIgnoreCase("") || sDefPID == null || sDefPID.equalsIgnoreCase("") || methodName == null || methodName.equalsIgnoreCase("")) {
            String message = "[MethodParameterResolverServlet] Insufficient information to construct dissemination request. Parameters received from web form were: PID: " + PID2 + " -- sDefPID: " + sDefPID + " -- methodName: " + methodName + " -- methodParms: " + methodParms.toString() + "\".  ";
            System.out.println(message);
            response.setStatus(500);
            response.sendError(500, message);
        } else {
            StringBuffer redirectURL = new StringBuffer();
            redirectURL.append(SERVLET_PATH + "?action_=GetDissemination&" + "PID_=" + PID2 + "&" + "sDefPID_=" + sDefPID + "&" + "methodName_=" + methodName);
            int i = 0;
            Enumeration e = h_methodParms.keys();
            while (e.hasMoreElements()) {
                String name = URLEncoder.encode((String)e.nextElement(), "UTF-8");
                String value = URLEncoder.encode((String)h_methodParms.get(name), "UTF-8");
                if (++i == h_methodParms.size()) {
                    methodParms.append(name + "=" + value);
                    continue;
                }
                methodParms.append(name + "=" + value + "&");
            }
            if (h_methodParms.size() > 0) {
                if (versDateTime == null || versDateTime.equalsIgnoreCase("")) {
                    redirectURL.append("&" + methodParms.toString());
                } else {
                    redirectURL.append("&asOfDateTime_=" + versDateTime + "&" + methodParms.toString());
                }
            } else if (versDateTime != null && !versDateTime.equalsIgnoreCase("")) {
                redirectURL.append("&asOfDateTime_=" + versDateTime);
            }
            response.sendRedirect(redirectURL.toString());
        }
    }

    public void destroy() {
    }
}

