/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.mock.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;

public class MockPreparedStatement
implements PreparedStatement {
    private final String sql;
    private final Object[] parameters;
    private boolean closed;
    private boolean executed;

    public MockPreparedStatement(String sql) {
        this.sql = sql;
        int howManyParameters = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if ('?' != sql.charAt(i)) continue;
            ++howManyParameters;
        }
        this.parameters = new Object[howManyParameters];
    }

    public void reset() {
        Arrays.fill(this.parameters, null);
        this.closed = false;
        this.executed = false;
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getParameters() {
        return (Object[])this.parameters.clone();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Attempt to operate on closed statement.");
        }
    }

    private void checkExecuted() {
        if (this.executed) {
            throw new IllegalStateException("Attempt to operate on a statement that has already been executed.");
        }
    }

    private int convertIndex(int index) throws SQLException {
        if (index < 1 || index > this.parameters.length) {
            throw new SQLException("Index out of range: value is " + index + ", must be between 1 and " + this.parameters.length);
        }
        return index - 1;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        this.checkExecuted();
        this.executed = true;
        return 0;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.checkExecuted();
        this.parameters[this.convertIndex((int)parameterIndex)] = x;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.checkExecuted();
        this.parameters[this.convertIndex((int)parameterIndex)] = x;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.addBatch not implemented");
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.clearParameters not implemented");
    }

    @Override
    public boolean execute() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.execute not implemented");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.executeQuery not implemented");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getMetaData not implemented");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getParameterMetaData not implemented");
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setArray not implemented");
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setAsciiStream not implemented");
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setBigDecimal not implemented");
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setBinaryStream not implemented");
    }

    @Override
    public void setBlob(int arg0, Blob arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setBlob not implemented");
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setBoolean not implemented");
    }

    @Override
    public void setByte(int arg0, byte arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setByte not implemented");
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setBytes not implemented");
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setCharacterStream not implemented");
    }

    @Override
    public void setClob(int arg0, Clob arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setClob not implemented");
    }

    @Override
    public void setDate(int arg0, Date arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setDate not implemented");
    }

    @Override
    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setDate not implemented");
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setDouble not implemented");
    }

    @Override
    public void setFloat(int arg0, float arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setFloat not implemented");
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setInt not implemented");
    }

    @Override
    public void setNull(int arg0, int arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setNull not implemented");
    }

    @Override
    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setNull not implemented");
    }

    @Override
    public void setObject(int arg0, Object arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setObject not implemented");
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setObject not implemented");
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setObject not implemented");
    }

    @Override
    public void setRef(int arg0, Ref arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setRef not implemented");
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setShort not implemented");
    }

    @Override
    public void setTime(int arg0, Time arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setTime not implemented");
    }

    @Override
    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setTime not implemented");
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setTimestamp not implemented");
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setTimestamp not implemented");
    }

    @Override
    public void setURL(int arg0, URL arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setURL not implemented");
    }

    @Override
    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setUnicodeStream not implemented");
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.addBatch not implemented");
    }

    @Override
    public void cancel() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.cancel not implemented");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.clearBatch not implemented");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.clearWarnings not implemented");
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.execute not implemented");
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.execute not implemented");
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.execute not implemented");
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.execute not implemented");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.executeBatch not implemented");
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.executeQuery not implemented");
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.executeUpdate not implemented");
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.executeUpdate not implemented");
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.executeUpdate not implemented");
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.executeUpdate not implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getConnection not implemented");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getFetchDirection not implemented");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getFetchSize not implemented");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getGeneratedKeys not implemented");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getMaxFieldSize not implemented");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getMaxRows not implemented");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getMoreResults not implemented");
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getMoreResults not implemented");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getQueryTimeout not implemented");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getResultSet not implemented");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getResultSetConcurrency not implemented");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getResultSetHoldability not implemented");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getResultSetType not implemented");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getUpdateCount not implemented");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new RuntimeException("MockPreparedStatement.getWarnings not implemented");
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setCursorName not implemented");
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setEscapeProcessing not implemented");
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setFetchDirection not implemented");
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setFetchSize not implemented");
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setMaxFieldSize not implemented");
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setMaxRows not implemented");
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        throw new RuntimeException("MockPreparedStatement.setQueryTimeout not implemented");
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void closeOnCompletion() {
        throw new UnsupportedOperationException("Java 1.7 JDBC methods are not supported");
    }

    @Override
    public boolean isCloseOnCompletion() {
        throw new UnsupportedOperationException("Java 1.7 JDBC methods are not supported");
    }
}

