/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.helpers;

import java.util.HashMap;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.helpers.ParameterHelper;
import org.junit.Assert;
import org.junit.Before;

public class TestParameterHelper
implements JournalConstants {
    private static final String PARAMETER_NAME = "name";
    private Map<String, String> parameters;

    public static Test suite() {
        return new JUnit4TestAdapter(TestParameterHelper.class);
    }

    @Before
    public void setUp() {
        this.parameters = new HashMap<String, String>();
    }

    @org.junit.Test
    public void testGetOptionalBooleanParameter_NullParameters() throws JournalException {
        try {
            ParameterHelper.getOptionalBooleanParameter(null, (String)PARAMETER_NAME, (boolean)false);
            Assert.fail((String)"Expected a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testGetOptionalBooleanParameter_NullParameterName() throws JournalException {
        try {
            ParameterHelper.getOptionalBooleanParameter(this.parameters, null, (boolean)false);
            Assert.fail((String)"Expected a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testGetOptionalBooleanParameter_ValueTrue() throws JournalException {
        this.parameters.put(PARAMETER_NAME, "true");
        boolean result = ParameterHelper.getOptionalBooleanParameter(this.parameters, (String)PARAMETER_NAME, (boolean)false);
        Assert.assertEquals((Object)true, (Object)result);
    }

    @org.junit.Test
    public void testGetOptionalBooleanParameter_ValueFalse() throws JournalException {
        this.parameters.put(PARAMETER_NAME, "false");
        boolean result = ParameterHelper.getOptionalBooleanParameter(this.parameters, (String)PARAMETER_NAME, (boolean)true);
        Assert.assertEquals((Object)false, (Object)result);
    }

    @org.junit.Test
    public void testGetOptionalBooleanParameter_NoValue() throws JournalException {
        boolean result1 = ParameterHelper.getOptionalBooleanParameter(this.parameters, (String)PARAMETER_NAME, (boolean)true);
        Assert.assertEquals((Object)true, (Object)result1);
        boolean result2 = ParameterHelper.getOptionalBooleanParameter(this.parameters, (String)PARAMETER_NAME, (boolean)false);
        Assert.assertEquals((Object)false, (Object)result2);
    }

    @org.junit.Test
    public void testGetOptionalBooleanParameter_InvalidValue() {
        this.parameters.put(PARAMETER_NAME, "BOGUS");
        try {
            ParameterHelper.getOptionalBooleanParameter(this.parameters, (String)PARAMETER_NAME, (boolean)false);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testGetOptionalStringParameter_Value() {
        this.parameters.put("fred", "theValue");
        String result = ParameterHelper.getOptionalStringParameter(this.parameters, (String)"fred", (String)"WhoCares?");
        Assert.assertEquals((Object)"theValue", (Object)result);
    }

    @org.junit.Test
    public void testGetOptionalStringParameter_Default() {
        String result = ParameterHelper.getOptionalStringParameter(this.parameters, (String)"fred", (String)"WhoCares?");
        Assert.assertEquals((Object)"WhoCares?", (Object)result);
    }

    @org.junit.Test
    public void testParseParametersForFilenamePrefix_Value() {
        this.parameters.put("journalFilenamePrefix", "somePrefix");
        String result = ParameterHelper.parseParametersForFilenamePrefix(this.parameters);
        Assert.assertEquals((Object)"somePrefix", (Object)result);
    }

    @org.junit.Test
    public void testParseParametersForFilenamePrefix_Default() {
        String result = ParameterHelper.parseParametersForFilenamePrefix(this.parameters);
        Assert.assertEquals((Object)"fedoraJournal", (Object)result);
    }

    @org.junit.Test
    public void testParseParametersForSizeLimit_Default() throws JournalException {
        long actual = ParameterHelper.parseParametersForSizeLimit(this.parameters);
        this.parameters.put("journalFileSizeLimit", "5M");
        long expected = ParameterHelper.parseParametersForSizeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForSizeLimit_NoSuffix() throws JournalException {
        long expected = 4196L;
        this.parameters.put("journalFileSizeLimit", "4196");
        long actual = ParameterHelper.parseParametersForSizeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForSizeLimit_K() throws JournalException {
        long expected = 172032L;
        this.parameters.put("journalFileSizeLimit", "168K");
        long actual = ParameterHelper.parseParametersForSizeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForSizeLimit_M() throws JournalException {
        long expected = 0x500000L;
        this.parameters.put("journalFileSizeLimit", "5M");
        long actual = ParameterHelper.parseParametersForSizeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForSizeLimit_G() throws JournalException {
        long expected = 1072668082176L;
        this.parameters.put("journalFileSizeLimit", "999G");
        long actual = ParameterHelper.parseParametersForSizeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForSizeLimit_InvalidSuffix() {
        this.parameters.put("journalFileSizeLimit", "5X");
        try {
            ParameterHelper.parseParametersForSizeLimit(this.parameters);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testParseParametersForAgeLimit_Default() throws JournalException {
        long actual = ParameterHelper.parseParametersForAgeLimit(this.parameters);
        this.parameters.put("journalFileAgeLimit", "1D");
        long expected = ParameterHelper.parseParametersForAgeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForAgeLimit_NoSuffix() throws JournalException {
        long expected = 4196000L;
        this.parameters.put("journalFileAgeLimit", "4196");
        long actual = ParameterHelper.parseParametersForAgeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForAgeLimit_M() throws JournalException {
        long expected = 10080000L;
        this.parameters.put("journalFileAgeLimit", "168M");
        long actual = ParameterHelper.parseParametersForAgeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForAgeLimit_H() throws JournalException {
        long expected = 18000000L;
        this.parameters.put("journalFileAgeLimit", "5H");
        long actual = ParameterHelper.parseParametersForAgeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForAgeLimit_D() throws JournalException {
        long expected = 86313600000L;
        this.parameters.put("journalFileAgeLimit", "999D");
        long actual = ParameterHelper.parseParametersForAgeLimit(this.parameters);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @org.junit.Test
    public void testParseParametersForAgeLimit_InvalidSuffix() {
        this.parameters.put("journalFileAgeLimit", "5X");
        try {
            ParameterHelper.parseParametersForAgeLimit(this.parameters);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }
}

