/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.MockServerForJournalTesting;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.CreatorJournalEntry;
import org.fcrepo.server.journal.entry.JournalEntry;
import org.fcrepo.server.journal.readerwriter.multicast.JournalEntrySizeEstimator;
import org.fcrepo.server.journal.readerwriter.multicast.MockMulticastJournalWriter;
import org.fcrepo.server.journal.readerwriter.multicast.MulticastJournalWriter;
import org.fcrepo.server.journal.readerwriter.multicast.SampleJournalEntries;
import org.fcrepo.server.management.MockManagementDelegate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJournalEntrySizeEstimator {
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final String role = "dummyRole";
    private final ServerInterface server = new MockServerForJournalTesting(new MockManagementDelegate(), "repositoryHash");
    private List<CreatorJournalEntry> journalEntries;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestJournalEntrySizeEstimator.class);
    }

    @Before
    public void createListOfJournalEntries() throws JournalException {
        this.journalEntries = new ArrayList<CreatorJournalEntry>(SampleJournalEntries.ALL_ENTRIES);
    }

    @Test
    public void testSizeEstimation() throws JournalException, XMLStreamException, FactoryConfigurationError {
        MockMulticastJournalWriter mjw = new MockMulticastJournalWriter(this.parameters, "dummyRole", this.server);
        mjw.setCheckParametersForValidity(false);
        JournalEntrySizeEstimator estimator = new JournalEntrySizeEstimator((MulticastJournalWriter)mjw);
        for (CreatorJournalEntry journalEntry : this.journalEntries) {
            StringWriter stringWriter = new StringWriter();
            IndentingXMLEventWriter xmlEventWriter = new IndentingXMLEventWriter(XMLOutputFactory.newInstance().createXMLEventWriter(stringWriter));
            mjw.writeJournalEntry(journalEntry, (XMLEventWriter)xmlEventWriter);
            long estimatedSize = estimator.estimateSize((JournalEntry)journalEntry);
            this.assertSizesAreReallyClose(stringWriter.getBuffer().length(), estimatedSize);
        }
    }

    private void assertSizesAreReallyClose(int actualSize, long estimatedSize) {
        long difference = Math.abs((long)actualSize - estimatedSize);
        if ((double)(difference / (long)actualSize) > 0.001) {
            Assert.fail((String)("sizes aren't even close: actual=" + actualSize + ", estimated=" + estimatedSize));
        }
    }
}

