/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.util.HashMap;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalWriter;
import org.fcrepo.server.journal.MockServerForJournalTesting;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.readerwriter.multicast.MockTransport;
import org.fcrepo.server.journal.readerwriter.multicast.MulticastJournalWriter;
import org.fcrepo.server.journal.readerwriter.multicast.Transport;
import org.fcrepo.server.management.MockManagementDelegate;
import org.junit.Assert;
import org.junit.Before;

public class TestMulticastJournalWriterInitializations {
    private static final String TEST_CLASS_NAME = "org.fcrepo.server.journal.readerwriter.multicast.MulticastJournalWriter";
    private static final String DUMMY_ROLE = "dummyRole";
    private ServerInterface server;
    private Map<String, String> parameters;

    public static Test suite() {
        return new JUnit4TestAdapter(TestMulticastJournalWriterInitializations.class);
    }

    @Before
    public void initializeMockServer() {
        this.server = new MockServerForJournalTesting(new MockManagementDelegate(), "myHashValue");
    }

    @Before
    public void initializeBasicParameters() {
        this.parameters = new HashMap<String, String>();
        this.parameters.put("journalWriterClassname", TEST_CLASS_NAME);
    }

    @org.junit.Test
    public void testInvalidTransportParameter() {
        this.parameters.put("transport.noperiodseparator", "junkValue");
        try {
            JournalWriter.getInstance(this.parameters, (String)DUMMY_ROLE, (ServerInterface)this.server);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testNoTransports() {
        try {
            JournalWriter.getInstance(this.parameters, (String)DUMMY_ROLE, (ServerInterface)this.server);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testMissingClassnameOnTransport() {
        this.addTransportParameter("one", "crucial", "false");
        this.addTransportParameter("two", "classname", "classTwo");
        this.addTransportParameter("one", "crucial", "true");
        try {
            JournalWriter.getInstance(this.parameters, (String)DUMMY_ROLE, (ServerInterface)this.server);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testMissingCrucialOnTransport() {
        this.addTransportParameter("one", "classname", "classOne");
        this.addTransportParameter("two", "classname", "classTwo");
        this.addTransportParameter("two", "crucial", "false");
        try {
            JournalWriter.getInstance(this.parameters, (String)DUMMY_ROLE, (ServerInterface)this.server);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testNoCrucialTransport() {
        this.addTransportParameter("one", "classname", "classOne");
        this.addTransportParameter("one", "crucial", "false");
        this.addTransportParameter("two", "classname", "classTwo");
        this.addTransportParameter("two", "crucial", "false");
        try {
            JournalWriter.getInstance(this.parameters, (String)DUMMY_ROLE, (ServerInterface)this.server);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testBadTransportClassname() {
        this.addTransportParameter("one", "classname", "classOne");
        this.addTransportParameter("one", "crucial", "true");
        try {
            JournalWriter.getInstance(this.parameters, (String)DUMMY_ROLE, (ServerInterface)this.server);
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testSuccessfulCreation() throws JournalException {
        Map<String, String> transportOneParameters = this.buildTransportParameters(new String[][]{{"classname", MockTransport.class.getName()}, {"crucial", "false"}});
        Map<String, String> transportTwoParameters = this.buildTransportParameters(new String[][]{{"classname", MockTransport.class.getName()}, {"crucial", "true"}});
        this.addTransportParameters("one", transportOneParameters);
        this.addTransportParameters("two", transportTwoParameters);
        JournalWriter writer = JournalWriter.getInstance(this.parameters, (String)DUMMY_ROLE, (ServerInterface)this.server);
        Assert.assertSame((String)"JournalWriter is the wrong class", MulticastJournalWriter.class, writer.getClass());
        MulticastJournalWriter mjw = (MulticastJournalWriter)writer;
        Map transports = mjw.getTransports();
        Assert.assertEquals((String)"should be two transports", (long)2L, (long)transports.size());
        Assert.assertEquals((String)"transport one class", MockTransport.class, ((Transport)transports.get("one")).getClass());
        Assert.assertEquals((String)"transport one crucial flag", (Object)false, (Object)((Transport)transports.get("one")).isCrucial());
        Assert.assertEquals((String)"transport one parameters", transportOneParameters, (Object)((Transport)transports.get("one")).getParameters());
        Assert.assertEquals((String)"transport two class", MockTransport.class, ((Transport)transports.get("two")).getClass());
        Assert.assertEquals((String)"transport two crucial flag", (Object)true, (Object)((Transport)transports.get("two")).isCrucial());
        Assert.assertEquals((String)"transport two parameters", transportTwoParameters, (Object)((Transport)transports.get("two")).getParameters());
    }

    private Map<String, String> buildTransportParameters(String[][] rawData) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String[] pair : rawData) {
            parameters.put(pair[0], pair[1]);
        }
        return parameters;
    }

    private void addTransportParameters(String transportName, Map<String, String> parameters) {
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.addTransportParameter(transportName, entry.getKey(), entry.getValue());
        }
    }

    private void addTransportParameter(String transportName, String transportParameterKey, String value) {
        this.parameters.put("transport." + transportName + "." + transportParameterKey, value);
    }
}

