/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast.rmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.MockServerForJournalTesting;
import org.fcrepo.server.journal.readerwriter.multicast.MockMulticastJournalWriter;
import org.fcrepo.server.journal.readerwriter.multicast.TransportParent;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.MockRmiJournalReceiver;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverInterface;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiTransport;
import org.fcrepo.server.management.MockManagementDelegate;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestRmiTransport {
    private Process rmiRegistryProcess;
    private StringWriter rmiRegistryProcessOutput;
    private static final boolean CRUCIAL = true;
    private Map<String, String> parameters;
    private MockMulticastJournalWriter parent;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestRmiTransport.class);
    }

    @Before
    public void initalizeBasicParameters() throws UnknownHostException {
        this.parameters = new HashMap<String, String>();
        this.parameters.put("hostName", InetAddress.getLocalHost().getHostName());
        this.parameters.put("service", "RmiJournalReceiver");
    }

    @Before
    public void initializeTransportParent() throws JournalException {
        MockServerForJournalTesting server = new MockServerForJournalTesting(new MockManagementDelegate(), "myHashValue");
        this.parent = new MockMulticastJournalWriter(new HashMap<String, String>(), null, server);
    }

    @After
    public void stopRmiRegistry() throws InterruptedException {
        if (this.rmiRegistryProcess != null) {
            this.rmiRegistryProcess.destroy();
            this.rmiRegistryProcess.waitFor();
            this.rmiRegistryProcess = null;
            Thread.sleep(3000L);
        }
    }

    @Test(expected=JournalException.class)
    public void testNoHostParameter() throws JournalException {
        this.parameters.remove("hostName");
        new RmiTransport(this.parameters, true, (TransportParent)this.parent);
    }

    @Test(expected=JournalException.class)
    public void testInvalidHostParameter() throws JournalException {
        this.parameters.put("hostName", "BogusHost");
        new RmiTransport(this.parameters, true, (TransportParent)this.parent);
    }

    @Test(expected=JournalException.class)
    public void testInvalidPortParameter() throws JournalException {
        this.parameters.put("port", "BogusPort");
        new RmiTransport(this.parameters, true, (TransportParent)this.parent);
    }

    @Test(expected=JournalException.class)
    public void testNoServiceNameParameter() throws JournalException {
        this.parameters.remove("service");
        new RmiTransport(this.parameters, true, (TransportParent)this.parent);
    }

    @Test(expected=JournalException.class)
    public void testNoRegistry() throws JournalException {
        new RmiTransport(this.parameters, true, (TransportParent)this.parent);
    }

    @Test
    public void testOpenCloseSequenceCalls() throws JournalException, RemoteException {
        MockRmiJournalReceiver receiver = new MockRmiJournalReceiver();
        RmiTransport transport = new RmiTransport(this.parameters, true, (TransportParent)this.parent, (RmiJournalReceiverInterface)receiver);
        transport.openFile("someHash", "aFileName", new Date());
        Assert.assertEquals((int)1, (int)receiver.howManyCallsToOpenFile());
        transport.closeFile();
        Assert.assertEquals((int)1, (int)receiver.howManyCallsToClosefile());
    }

    @Ignore
    @Test(expected=JournalException.class)
    public void testNoSuchService() throws JournalException, IOException {
        this.startMockRmiJournalReceiver();
        this.parameters.put("service", "BogusService");
        new RmiTransport(this.parameters, true, (TransportParent)this.parent);
    }

    @Ignore
    @Test
    public void testSuccessfulConnection() throws JournalException, IOException {
        this.startMockRmiJournalReceiver();
        new RmiTransport(this.parameters, true, (TransportParent)this.parent);
    }

    @Ignore
    @Test
    public void testOpenCloseShutdownSequence() throws JournalException, IOException {
        this.startMockRmiJournalReceiver();
        RmiTransport transport = new RmiTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("someHash", "aFileName", new Date());
        this.assertCorrectNumberOfCalls(1, 0, 0);
        transport.closeFile();
        this.assertCorrectNumberOfCalls(1, 1, 1);
        transport.shutdown();
        this.assertCorrectNumberOfCalls(1, 1, 1);
    }

    @Ignore
    @Test
    public void testWritesWithSmallBuffer() throws JournalException, IOException, XMLStreamException {
        this.startMockRmiJournalReceiver();
        this.parameters.put("bufferSize", "100");
        RmiTransport transport = new RmiTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("someHash", "aFileName", new Date());
        this.assertCorrectNumberOfCalls(1, 1, 0);
        XMLEventFactory factory = XMLEventFactory.newInstance();
        QName name1 = new QName("junkyElement1");
        QName name2 = new QName("junkyElement12");
        transport.getWriter().add(factory.createStartElement(name1, null, null));
        transport.getWriter().add(factory.createEndElement(name1, null));
        this.assertCorrectNumberOfCalls(1, 1, 0);
        transport.getWriter().add(factory.createStartElement(name2, null, null));
        transport.getWriter().add(factory.createEndElement(name2, null));
        transport.closeFile();
        this.assertCorrectNumberOfCalls(1, 3, 1);
        transport.shutdown();
        this.assertCorrectNumberOfCalls(1, 3, 1);
    }

    @Ignore
    @Test(expected=JournalException.class)
    public void testReceiverThrowsException() throws IOException, JournalException {
        this.startMockRmiJournalReceiver(true);
        RmiTransport transport = new RmiTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("someHash", "aFileName", new Date());
        Assert.fail((String)"Expected an exception.");
    }

    private void startMockRmiJournalReceiver() throws IOException {
        this.startMockRmiJournalReceiver(false);
    }

    private void startMockRmiJournalReceiver(boolean throwException) throws IOException {
        String exceptionOption = throwException ? "throwException" : "dontThrow";
        ProcessBuilder pb = new ProcessBuilder("java", MockRmiJournalReceiver.class.getName(), exceptionOption);
        pb.environment().put("CLASSPATH", System.getProperty("java.class.path"));
        pb.redirectErrorStream(true);
        this.rmiRegistryProcess = pb.start();
        StreamEater outputEater = new StreamEater(this.rmiRegistryProcess.getInputStream());
        this.rmiRegistryProcessOutput = outputEater.getOutput();
    }

    private void assertCorrectNumberOfCalls(int i, int j, int k) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String outputString = this.rmiRegistryProcessOutput.toString();
        String[] split1 = outputString.split("openFile\\(");
        Assert.assertEquals((String)"wrong number of openFile() calls", (int)i, (int)(split1.length - 1));
        String[] split2 = outputString.split("writeText\\(");
        Assert.assertEquals((String)"wrong number of writeText() calls", (int)j, (int)(split2.length - 1));
        String[] split3 = outputString.split("closeFile\\(");
        Assert.assertEquals((String)"wrong number of closeFile() calls", (int)k, (int)(split3.length - 1));
    }

    private static class StreamEater
    extends Thread {
        private final InputStream stream;
        private final StringWriter output = new StringWriter();
        private final byte[] buffer = new byte[4096];

        public StreamEater(InputStream stream) {
            this.stream = stream;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int howMany = 0;
                while (true) {
                    if ((howMany = this.stream.read(this.buffer)) > 0) {
                        this.output.write(new String(this.buffer, 0, howMany));
                        continue;
                    }
                    if (howMany == 0) {
                        Thread.yield();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public StringWriter getOutput() {
            return this.output;
        }
    }
}

