/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.File;
import java.util.HashMap;
import org.fcrepo.server.BasicServer;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.management.ManagementModule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class ManagementModuleTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testInitModuleFailsWithoutUploadDirectory() throws Exception {
        this.thrown.expect(ModuleInitializationException.class);
        this.thrown.expectMessage(JUnitMatchers.containsString((String)"Failed to create temp dir at"));
        File badUploadDir = this.folder.newFile("fileNotDirectory");
        Server mockedServer = (Server)Mockito.mock(BasicServer.class);
        Mockito.when((Object)mockedServer.getUploadDir()).thenReturn((Object)badUploadDir);
        HashMap params = new HashMap();
        ManagementModule mm = new ManagementModule(params, null, null);
        ManagementModule spy = (ManagementModule)Mockito.spy((Object)mm);
        Mockito.when((Object)spy.getServer()).thenReturn((Object)mockedServer);
        spy.initModule();
    }
}

