/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.fcrepo.common.PID;
import org.fcrepo.server.management.PIDGenerator;

public abstract class TestPIDGenerator
extends TestCase {
    private PIDGenerator testPIDGenerator;
    private Set namespaces;

    protected abstract PIDGenerator getTestPIDGenerator();

    protected abstract Set getNamespaces();

    protected void setUp() {
        this.testPIDGenerator = this.getTestPIDGenerator();
        if (this.testPIDGenerator == null) {
            TestPIDGenerator.fail((String)"getTestPIDGenerator() returned null");
        }
        this.namespaces = this.getNamespaces();
        if (this.namespaces.size() == 0) {
            TestPIDGenerator.fail((String)"must provide at least one namespace");
        }
    }

    public void testGeneratePID() {
        Iterator it = this.namespaces.iterator();
        try {
            while (it.hasNext()) {
                this.testPIDGenerator.generatePID((String)it.next());
            }
        }
        catch (IOException e) {
            TestPIDGenerator.fail((String)e.getMessage());
        }
    }

    public void testgetLastPID() {
        try {
            PID pid = this.testPIDGenerator.getLastPID();
        }
        catch (UnsupportedOperationException e) {
        }
        catch (IOException e) {
            TestPIDGenerator.fail((String)e.getMessage());
        }
    }

    public void testNeverGeneratePID() {
    }
}

