/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.fcrepo.server.errors.MessagingException;
import org.fcrepo.server.messaging.JMSManager;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class JMSManagerTest
extends TestCase
implements MessageListener {
    private Properties properties;
    private final String messageText = "Message Text";
    private Message currentMessage = null;
    private int messageCount = 0;
    private final int timeout = 5000;

    @Before
    public void setUp() throws Exception {
        this.properties = new Properties();
        this.properties.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        this.properties.setProperty("java.naming.provider.url", "vm://localhost");
        this.properties.setProperty("connection.factory.name", "ConnectionFactory");
        this.messageCount = 0;
        this.currentMessage = null;
    }

    @Test
    public void testVMMessage() throws Exception {
        String topic = "jmsmanager.test";
        this.properties.setProperty("topic." + topic, topic);
        JMSManager jmsMgr = new JMSManager(this.properties);
        jmsMgr.listen(topic, (MessageListener)this);
        jmsMgr.send(topic, "Message Text");
        this.checkMessage(topic, JMSManager.DestinationType.Topic, "Message Text");
        jmsMgr.close();
    }

    @Ignore(value="Broker thread in test occationally fails to start")
    @Test
    public void testTCPMessage() throws Exception {
    }

    @Test
    public void testCreateTopic() throws Exception {
        String topic = "jmsmanager.test";
        JMSManager jmsMgr = new JMSManager(this.properties);
        jmsMgr.createDestination(topic, JMSManager.DestinationType.Topic);
        jmsMgr.listen(topic, (MessageListener)this);
        jmsMgr.send(topic, "Message Text");
        this.checkMessage(topic, JMSManager.DestinationType.Topic, "Message Text");
        jmsMgr.close();
    }

    @Test
    public void testCreateQueue() throws Exception {
        String queue = "jmsmanager";
        JMSManager jmsMgr = new JMSManager(this.properties);
        jmsMgr.createDestination(queue, JMSManager.DestinationType.Queue);
        jmsMgr.listen(queue, (MessageListener)this);
        jmsMgr.send(queue, "Message Text");
        this.checkMessage(queue, JMSManager.DestinationType.Queue, "Message Text");
        jmsMgr.close();
    }

    @Test
    public void testSendToDestination() throws Exception {
        String topic = "jmsmanager.test";
        JMSManager jmsMgr = new JMSManager(this.properties);
        Destination destination = jmsMgr.createDestination(topic, JMSManager.DestinationType.Topic);
        TextMessage textMessage = jmsMgr.createTextMessage(topic, "Message Text");
        jmsMgr.listen(destination, (MessageListener)this);
        jmsMgr.send(destination, (Message)textMessage);
        this.checkMessage(topic, JMSManager.DestinationType.Topic, "Message Text");
        jmsMgr.close();
    }

    @Test
    public void testMessageSelectors() throws Exception {
        String topic = "jmsmanager.test";
        JMSManager jmsMgr = new JMSManager(this.properties);
        jmsMgr.createDestination(topic, JMSManager.DestinationType.Topic);
        String messageSelector = "jmsProperty IN ('selectMe')";
        jmsMgr.listen(topic, messageSelector, (MessageListener)this);
        TextMessage textMessage = jmsMgr.createTextMessage(topic, "Message Text");
        textMessage.setStringProperty("jmsProperty", "selectMe");
        jmsMgr.send(topic, (Message)textMessage);
        this.checkMessage(topic, JMSManager.DestinationType.Topic, "Message Text");
        textMessage = jmsMgr.createTextMessage(topic, "Message Text");
        textMessage.setStringProperty("jmsProperty", "doNotSelectMe");
        jmsMgr.send(topic, (Message)textMessage);
        this.checkNoMessage();
        jmsMgr.close();
    }

    @Test
    public void testDurableSubscription() throws Exception {
        String topic = "jmsmanager.test.durable";
        JMSManager jmsMgr = new JMSManager(this.properties, "clientId1");
        jmsMgr.listenDurable(topic, (MessageListener)this);
        jmsMgr.send(topic, "Message Text");
        this.checkMessage(topic, JMSManager.DestinationType.Topic, "Message Text");
        String message2 = "Message Number 2";
        jmsMgr.stopDurable(topic);
        jmsMgr.send(topic, message2);
        this.checkNoMessage();
        jmsMgr.listenDurable(topic, (MessageListener)this);
        this.checkMessage(topic, JMSManager.DestinationType.Topic, message2);
        String message3 = "Message Number 3";
        jmsMgr.unsubscribeDurable(topic);
        jmsMgr.send(topic, message3);
        this.checkNoMessage();
        jmsMgr.close();
    }

    @Test
    public void testSendMessages() throws Exception {
        String topic = "jmsmanager.test";
        JMSManager jmsMgr = new JMSManager(this.properties);
        jmsMgr.createDestination(topic, JMSManager.DestinationType.Topic);
        jmsMgr.listen(topic, (MessageListener)this);
        TextMessage textMessage = jmsMgr.createTextMessage(topic, "Message Text");
        jmsMgr.send(topic, (Message)textMessage);
        this.checkMessage(topic, JMSManager.DestinationType.Topic, "Message Text");
        BytesMessage bytesMessage = jmsMgr.createBytesMessage(topic);
        bytesMessage.writeBytes("Message Text".getBytes());
        jmsMgr.send(topic, (Message)bytesMessage);
        this.checkMessage(topic, JMSManager.DestinationType.Topic, null);
        ObjectMessage objectMessage = jmsMgr.createObjectMessage(topic, (Serializable)((Object)"Message Text"));
        jmsMgr.send(topic, (Message)objectMessage);
        this.checkMessage(topic, JMSManager.DestinationType.Topic, null);
        MapMessage mapMessage = jmsMgr.createMapMessage(topic);
        mapMessage.setString("key", "Message Text");
        jmsMgr.send(topic, (Message)mapMessage);
        this.checkMessage(topic, JMSManager.DestinationType.Topic, null);
        StringBuffer serializableObj = new StringBuffer("Message Text");
        jmsMgr.send(topic, (Serializable)serializableObj);
        this.checkMessage(topic, JMSManager.DestinationType.Topic, null);
        jmsMgr.close();
    }

    @Test
    public void testMessageVolume() throws Exception {
        String topic = "jmsmanager.test";
        JMSManager jmsMgr = new JMSManager(this.properties);
        jmsMgr.createDestination(topic, JMSManager.DestinationType.Topic);
        jmsMgr.listen(topic, (MessageListener)this);
        int sentMessages = 0;
        for (int i = 0; i < 5000; ++i) {
            jmsMgr.send(topic, "Message Text");
            ++sentMessages;
        }
        long startTime = System.currentTimeMillis();
        boolean timeExpired = false;
        while (this.messageCount < sentMessages) {
            if (timeExpired) {
                JMSManagerTest.fail((String)("Sent " + sentMessages + " messages but only received " + this.messageCount + " messages"));
            }
            if (System.currentTimeMillis() <= startTime + 5000L) continue;
            timeExpired = true;
        }
        jmsMgr.close();
    }

    @Test
    public void testInvalidProperties() throws Exception {
        try {
            new JMSManager(null);
            JMSManagerTest.fail((String)"Creating a JMSManager with null properties should throw an exception");
        }
        catch (MessagingException expected) {
            JMSManagerTest.assertTrue((boolean)expected.getMessage().contains("properties"));
        }
        this.properties = new Properties();
        try {
            new JMSManager(this.properties);
            JMSManagerTest.fail((String)"Creating a JMSManager with no properties should throw an exception");
        }
        catch (MessagingException expected) {
            JMSManagerTest.assertTrue((boolean)expected.getMessage().contains("java.naming.factory.initial"));
        }
        this.properties = new Properties();
        this.properties.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        this.properties.setProperty("connection.factory.name", "ConnectionFactory");
        try {
            new JMSManager(this.properties);
            JMSManagerTest.fail((String)"Creating a JMSManager with no provider url property should throw an exception");
        }
        catch (MessagingException expected) {
            JMSManagerTest.assertTrue((boolean)expected.getMessage().contains("java.naming.provider.url"));
        }
        this.properties = new Properties();
        this.properties.setProperty("java.naming.provider.url", "vm://localhost");
        this.properties.setProperty("connection.factory.name", "ConnectionFactory");
        try {
            new JMSManager(this.properties);
            JMSManagerTest.fail((String)"Creating a JMSManager with no initial context factory property should throw an exception");
        }
        catch (MessagingException expected) {
            JMSManagerTest.assertTrue((boolean)expected.getMessage().contains("java.naming.factory.initial"));
        }
        this.properties = new Properties();
        this.properties.setProperty("java.naming.factory.initial", "test.InvalidInitialContextFactory");
        this.properties.setProperty("java.naming.provider.url", "vm://localhost");
        this.properties.setProperty("connection.factory.name", "ConnectionFactory");
        try {
            new JMSManager(this.properties);
            JMSManagerTest.fail((String)"Starting a JMSManager with an invalid initial context factory should throw an exception");
        }
        catch (MessagingException expected) {
            // empty catch block
        }
        this.properties = new Properties();
        this.properties.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        this.properties.setProperty("java.naming.provider.url", "tcp://localhost:00000");
        this.properties.setProperty("connection.factory.name", "ConnectionFactory");
        try {
            new JMSManager(this.properties);
            JMSManagerTest.fail((String)"Starting a JMSManager with an invalid provider url should throw an exception");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private void checkMessage(String destination, JMSManager.DestinationType type, String messageText) throws Exception {
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.messageCount > 0) {
                JMSManagerTest.assertNotNull((Object)this.currentMessage);
                if (this.currentMessage instanceof TextMessage) {
                    JMSManagerTest.assertEquals((String)messageText, (String)((TextMessage)this.currentMessage).getText());
                }
                Destination messageDestination = this.currentMessage.getJMSDestination();
                if (type.equals((Object)JMSManager.DestinationType.Topic)) {
                    if (messageDestination instanceof Topic) {
                        String topic = ((Topic)messageDestination).getTopicName();
                        JMSManagerTest.assertEquals((String)topic, (String)destination);
                        break;
                    }
                    JMSManagerTest.fail((String)"Destination type for message should have been Topic");
                    break;
                }
                if (messageDestination instanceof Queue) {
                    String queue = ((Queue)messageDestination).getQueueName();
                    JMSManagerTest.assertEquals((String)queue, (String)destination);
                    break;
                }
                JMSManagerTest.fail((String)"Destination type for message should have been Queue");
                break;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime > startTime + 5000L) {
                JMSManagerTest.fail((String)"Timeout reached waiting for message.");
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.messageCount = 0;
        this.currentMessage = null;
    }

    private void checkNoMessage() {
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.messageCount > 0) {
                JMSManagerTest.fail((String)"No messages should be received during this test.");
                break;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime > startTime + 5000L) break;
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.messageCount = 0;
        this.currentMessage = null;
    }

    public void onMessage(Message message) {
        this.currentMessage = message;
        ++this.messageCount;
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(JMSManagerTest.class);
    }

    public class JmsBroker
    extends Thread {
        private final String connectorUrl;
        private boolean stop = false;

        public JmsBroker(String connectorUrl) {
            this.connectorUrl = connectorUrl;
        }

        @Override
        public void run() {
            BrokerService broker = new BrokerService();
            try {
                broker.addConnector(this.connectorUrl);
                broker.start();
            }
            catch (Exception e) {
                System.err.println("Exception encountered starting broker with connectorUrl: " + this.connectorUrl + ". Exception message: " + e.getMessage());
            }
            while (!this.stop) {
            }
            try {
                broker.stop();
            }
            catch (Exception e) {
                System.err.println("Exception encountered stopping broker with connectorUrl: " + this.connectorUrl + ". Exception message: " + e.getMessage());
            }
        }

        public void exit() {
            this.stop = true;
        }
    }
}

