/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.resourceIndex.ResourceIndexIntegrationTest;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.ObjectBuilder;

public class ResourceIndexModDSIntegrationTest
extends ResourceIndexIntegrationTest {
    @org.junit.Test
    public void testModObjOnceAddDS() throws Exception {
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addEDatastream(modified, "DS1");
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceDelDS() throws Exception {
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addEDatastream(original, "DS1");
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        for (Datastream d : modified.datastreams("DS1")) {
            modified.removeDatastreamVersion(d);
        }
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceAddOneDSDelAnother() throws Exception {
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addEDatastream(original, "DS1");
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addEDatastream(modified, "DS2");
        for (Datastream d : modified.datastreams("DS1")) {
            modified.removeDatastreamVersion(d);
        }
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceAddOneDCField() throws Exception {
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "DC", this.getDC("<dc:title>test</dc:title>"));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "DC", this.getDC("<dc:title>test</dc:title>\n<dc:identifier>id</dc:identifier>"));
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceDelOneDCField() throws Exception {
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "DC", this.getDC("<dc:title>test</dc:title>\n<dc:identifier>id</dc:identifier>"));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "DC", this.getDC("<dc:title>test</dc:title>"));
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceAddOneDCFieldDelAnother() throws Exception {
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "DC", this.getDC("<dc:title>test</dc:title>"));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "DC", this.getDC("<dc:identifier>id</dc:identifier>"));
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceAddOneRELSEXTField() throws Exception {
        String rel1 = "<foo:bar rdf:resource=\"http://example.org/baz\"/>";
        String rel2 = "<foo:bar rdf:resource=\"http://example.org/quux\"/>";
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "RELS-EXT", ObjectBuilder.getRELSEXT("test:1", rel1));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "RELS-EXT", ObjectBuilder.getRELSEXT("test:1", rel1 + "\n" + rel2));
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceDelOneRELSEXTField() throws Exception {
        String rel1 = "<foo:bar rdf:resource=\"http://example.org/baz\"/>";
        String rel2 = "<foo:bar rdf:resource=\"http://example.org/quux\"/>";
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "RELS-EXT", ObjectBuilder.getRELSEXT("test:1", rel1 + "\n" + rel2));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "RELS-EXT", ObjectBuilder.getRELSEXT("test:1", rel1));
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceAddOneRELSEXTFieldDelAnother() throws Exception {
        String rel1 = "<foo:bar rdf:resource=\"http://example.org/baz\"/>";
        String rel2 = "<foo:bar rdf:resource=\"http://example.org/quux\"/>";
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "RELS-EXT", ObjectBuilder.getRELSEXT("test:1", rel1));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "RELS-EXT", ObjectBuilder.getRELSEXT("test:1", rel2));
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceAddOneRELSINTField() throws Exception {
        String rel1 = "<foo:bar rdf:resource=\"http://example.org/baz\"/>";
        String rel2 = "<foo:qux>quux</foo:qux>";
        String rel3 = "<foo:corge rdf:resource=\"http://example.org/grault\"/>";
        String rel4 = "<foo:garply rdf:resource=\"http://example.org/waldo\"/>";
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "RELS-INT", ObjectBuilder.getRELSINT("test:1", rel1, rel2));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "RELS-INT", ObjectBuilder.getRELSINT("test:1", rel1 + "\n" + rel3, rel2 + "\n" + rel4));
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceDelOneRELSINTField() throws Exception {
        String rel1 = "<foo:bar rdf:resource=\"http://example.org/baz\"/>";
        String rel2 = "<foo:qux>quux</foo:qux>";
        String rel3 = "<foo:corge rdf:resource=\"http://example.org/grault\"/>";
        String rel4 = "<foo:garply rdf:resource=\"http://example.org/waldo\"/>";
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "RELS-INT", ObjectBuilder.getRELSINT("test:1", rel1 + "\n" + rel3, rel2 + "\n" + rel4));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "RELS-INT", ObjectBuilder.getRELSINT("test:1", rel1, rel2));
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjOnceAddOneRELSINTFieldDelAnother() throws Exception {
        String rel1 = "<foo:bar rdf:resource=\"http://example.org/baz\"/>";
        String rel2 = "<foo:qux>quux</foo:qux>";
        String rel3 = "<foo:corge rdf:resource=\"http://example.org/grault\"/>";
        String rel4 = "<foo:garply rdf:resource=\"http://example.org/waldo\"/>";
        DigitalObject original = ResourceIndexModDSIntegrationTest.getTestObject("test:1", "test1");
        ResourceIndexModDSIntegrationTest.addXDatastream(original, "RELS-INT", ObjectBuilder.getRELSINT("test:1", rel1, rel2));
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        ResourceIndexModDSIntegrationTest.addXDatastream(modified, "RELS-INT", ObjectBuilder.getRELSINT("test:1", rel3, rel4));
        this.doModifyTest(1, original, modified);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ResourceIndexModDSIntegrationTest.class);
    }
}

