/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.common.Models;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.ServiceDefinitionReader;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.SimpleDOReader;
import org.fcrepo.server.storage.SimpleServiceDefinitionReader;
import org.fcrepo.server.storage.SimpleServiceDeploymentReader;
import org.fcrepo.server.storage.types.DigitalObject;
import org.jrdf.graph.ObjectNode;

public class MockRepositoryReader
implements RepositoryReader {
    private final Map<String, DigitalObject> _objects = new HashMap<String, DigitalObject>();

    public synchronized void putObject(DigitalObject obj) {
        this._objects.put(obj.getPid(), obj);
    }

    public synchronized DigitalObject deleteObject(String pid) {
        return this._objects.remove(pid);
    }

    public synchronized DigitalObject getObject(String pid) throws ObjectNotFoundException {
        DigitalObject obj = this._objects.get(pid);
        if (obj == null) {
            throw new ObjectNotFoundException("No such object: " + pid);
        }
        return obj;
    }

    public synchronized DOReader getReader(boolean cachedObjectRequired, Context context, String pid) throws ServerException {
        DigitalObject obj = this.getObject(pid);
        return new SimpleDOReader(null, (RepositoryReader)this, null, null, null, obj);
    }

    public synchronized ServiceDeploymentReader getServiceDeploymentReader(boolean cachedObjectRequired, Context context, String pid) throws ServerException {
        DigitalObject obj = this.getObject(pid);
        if (!obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) {
            throw new GeneralException("Not a service deployment: " + pid);
        }
        return new SimpleServiceDeploymentReader(null, (RepositoryReader)this, null, null, null, obj);
    }

    public synchronized ServiceDefinitionReader getServiceDefinitionReader(boolean cachedObjectRequired, Context context, String pid) throws ServerException {
        DigitalObject obj = this.getObject(pid);
        if (!obj.hasContentModel((ObjectNode)Models.SERVICE_DEFINITION_3_0)) {
            throw new GeneralException("Not a service definition object: " + pid);
        }
        return new SimpleServiceDefinitionReader(null, (RepositoryReader)this, null, null, null, obj);
    }

    public synchronized String[] listObjectPIDs(Context context) throws ServerException {
        String[] pids = new String[this._objects.keySet().size()];
        Iterator<String> iter = this._objects.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            pids[i++] = iter.next();
        }
        return pids;
    }
}

