/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel.akubra;

import java.net.URI;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.akubraproject.map.IdMapper;
import org.fcrepo.server.storage.lowlevel.akubra.HashPathIdMapper;
import org.junit.Assert;

public class HashPathIdMapperTest {
    private static final URI URI1 = URI.create("urn:example1");
    private static final URI URI1_ENCODED = URI.create("file:08/86/ca/urn%3Aexample1");
    private static final URI URI2 = URI.create("http://tinyurl.com/cxzzf");
    private static final URI URI2_ENCODED = URI.create("file:62/ca/d6/http%3A%2F%2Ftinyurl.com%2Fcxzzf");
    private static final URI URI3 = URI.create("info:foo/bar.baz.");
    private static final URI URI3_ENCODED = URI.create("file:13/a7/21/info%3Afoo%2Fbar.baz%2E");

    @org.junit.Test
    public void testGoodPatterns() throws Exception {
        HashPathIdMapperTest.runGenericTests(null);
        HashPathIdMapperTest.runGenericTests("");
        HashPathIdMapperTest.runGenericTests("#");
        HashPathIdMapperTest.runGenericTests("#/#");
        HashPathIdMapperTest.runGenericTests("##");
        HashPathIdMapperTest.runGenericTests("##/##");
        HashPathIdMapperTest.runGenericTests("##/##/##");
        HashPathIdMapperTest.runGenericTests("################################");
    }

    @org.junit.Test
    public void testBadPatterns() throws Exception {
        HashPathIdMapperTest.assertBadPattern("a");
        HashPathIdMapperTest.assertBadPattern("a#");
        HashPathIdMapperTest.assertBadPattern("#a");
        HashPathIdMapperTest.assertBadPattern("/#");
        HashPathIdMapperTest.assertBadPattern("#/");
        HashPathIdMapperTest.assertBadPattern("/#/");
        HashPathIdMapperTest.assertBadPattern("/#/");
        HashPathIdMapperTest.assertBadPattern("#################################");
    }

    @org.junit.Test
    public void testGetExternalId() {
        HashPathIdMapper mapper = new HashPathIdMapper("##/##/##");
        Assert.assertEquals((Object)URI1, (Object)mapper.getExternalId(URI1_ENCODED));
        Assert.assertEquals((Object)URI2, (Object)mapper.getExternalId(URI2_ENCODED));
        Assert.assertEquals((Object)URI3, (Object)mapper.getExternalId(URI3_ENCODED));
    }

    @org.junit.Test
    public void testGetInternalId() {
        HashPathIdMapper mapper = new HashPathIdMapper("##/##/##");
        Assert.assertEquals((Object)URI1_ENCODED, (Object)mapper.getInternalId(URI1));
        Assert.assertEquals((Object)URI2_ENCODED, (Object)mapper.getInternalId(URI2));
        Assert.assertEquals((Object)URI3_ENCODED, (Object)mapper.getInternalId(URI3));
    }

    @org.junit.Test(expected=NullPointerException.class)
    public void testGetInternalPrefixNull() {
        new HashPathIdMapper("").getInternalPrefix(null);
    }

    @org.junit.Test
    public void testGetInternalPrefixNoPattern() {
        Assert.assertEquals((Object)"file:urn%3Atest", (Object)new HashPathIdMapper("").getInternalPrefix("urn:test"));
    }

    @org.junit.Test
    public void testGetInternalPrefixWithPattern() {
        Assert.assertNull((Object)new HashPathIdMapper("#").getInternalPrefix("urn:test"));
    }

    private static void runGenericTests(String pattern) throws Exception {
        HashPathIdMapper mapper = new HashPathIdMapper(pattern);
        HashPathIdMapperTest.checkRoundtrip((IdMapper)mapper, URI1);
        HashPathIdMapperTest.checkRoundtrip((IdMapper)mapper, URI2);
        HashPathIdMapperTest.checkRoundtrip((IdMapper)mapper, URI3);
    }

    private static void checkRoundtrip(IdMapper mapper, URI orig) {
        URI internal = mapper.getInternalId(orig);
        URI external = mapper.getExternalId(internal);
        Assert.assertEquals((Object)orig, (Object)external);
    }

    private static void assertBadPattern(String pattern) {
        block2: {
            try {
                new HashPathIdMapper(pattern);
            }
            catch (Throwable th) {
                if (th instanceof IllegalArgumentException) break block2;
                Assert.fail((String)("Bad pattern '" + pattern + "' should have thrown " + "IllegalArgumentException, but threw " + th.getClass().getName()));
            }
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HashPathIdMapperTest.class);
    }
}

