/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.types.DigitalObject;

public class MockDOSerializer
implements DOSerializer {
    private final String m_format;

    public MockDOSerializer() {
        this.m_format = new String();
    }

    public MockDOSerializer(String format) {
        this.m_format = format;
    }

    public DOSerializer getInstance() {
        return new MockDOSerializer(this.m_format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(DigitalObject obj, OutputStream out, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedEncodingException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, encoding));
        try {
            writer.println(this.m_format);
            writer.print(obj.getPid());
        }
        finally {
            writer.close();
        }
    }
}

