/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.errors.UnsupportedTranslationException;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.translation.DOTranslatorImpl;
import org.fcrepo.server.storage.translation.MockDODeserializer;
import org.fcrepo.server.storage.translation.MockDOSerializer;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.DigitalObject;
import org.junit.Assert;
import org.junit.Before;

public class TestDOTranslatorImpl {
    private static final String TEST_PID = "test:pid";
    private static final String FORMAT_1 = "format1";
    private static final String FORMAT_2 = "format2";
    private static final String FORMAT_UNKNOWN = "formatUnknown";
    private DOTranslator m_trans;

    @Before
    public void setUp() {
        HashMap<String, MockDOSerializer> serializers = new HashMap<String, MockDOSerializer>();
        serializers.put(FORMAT_1, new MockDOSerializer(FORMAT_1));
        serializers.put(FORMAT_2, new MockDOSerializer(FORMAT_2));
        HashMap<String, MockDODeserializer> deserializers = new HashMap<String, MockDODeserializer>();
        deserializers.put(FORMAT_1, new MockDODeserializer(FORMAT_1));
        deserializers.put(FORMAT_2, new MockDODeserializer(FORMAT_2));
        this.m_trans = new DOTranslatorImpl(serializers, deserializers);
    }

    @org.junit.Test
    public void testDeserializeKnownFormats() {
        DigitalObject obj1 = null;
        DigitalObject obj2 = null;
        try {
            obj1 = this.doDeserialize(FORMAT_1);
            obj2 = this.doDeserialize(FORMAT_2);
        }
        catch (UnsupportedTranslationException e) {
            Assert.fail((String)"Deserialization should have succeeded, but threw UnsupportedTranslationException");
        }
        Assert.assertEquals((Object)TEST_PID, (Object)obj1.getPid());
        Assert.assertEquals((Object)FORMAT_1, (Object)obj1.getLabel());
        Assert.assertEquals((Object)TEST_PID, (Object)obj2.getPid());
        Assert.assertEquals((Object)FORMAT_2, (Object)obj2.getLabel());
    }

    @org.junit.Test
    public void testDeserializeUnknownFormat() {
        DigitalObject obj = null;
        try {
            obj = this.doDeserialize(FORMAT_UNKNOWN);
            Assert.fail((String)"Deserialization should have failed with UnsupportedTranslationException");
        }
        catch (UnsupportedTranslationException unsupportedTranslationException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testSerializeKnownFormats() {
        try {
            String[] lines1 = this.doSerialize(FORMAT_1);
            String[] lines2 = this.doSerialize(FORMAT_2);
            Assert.assertEquals((long)2L, (long)lines1.length);
            Assert.assertEquals((Object)FORMAT_1, (Object)lines1[0]);
            Assert.assertEquals((Object)TEST_PID, (Object)lines1[1]);
            Assert.assertEquals((long)2L, (long)lines2.length);
            Assert.assertEquals((Object)FORMAT_2, (Object)lines2[0]);
            Assert.assertEquals((Object)TEST_PID, (Object)lines2[1]);
        }
        catch (UnsupportedTranslationException e) {
            Assert.fail((String)"Serialization should have succeeded, but threw UnsupportedTranslationException");
        }
    }

    @org.junit.Test
    public void testSerializeUnknownFormat() {
        try {
            this.doSerialize(FORMAT_UNKNOWN);
            Assert.fail((String)"Serialization should have failed with UnsupportedTranslationException");
        }
        catch (UnsupportedTranslationException unsupportedTranslationException) {
            // empty catch block
        }
    }

    private DigitalObject doDeserialize(String format) throws UnsupportedTranslationException {
        BasicDigitalObject obj = new BasicDigitalObject();
        try {
            InputStream in = TestDOTranslatorImpl.getInputStream(format + "\n" + TEST_PID + "\n");
            this.m_trans.deserialize(in, (DigitalObject)obj, format, "UTF-8", 0);
            return obj;
        }
        catch (UnsupportedTranslationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Test failure: " + e.getClass().getName());
        }
    }

    private String[] doSerialize(String format) throws UnsupportedTranslationException {
        BasicDigitalObject obj = new BasicDigitalObject();
        obj.setPid(TEST_PID);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.m_trans.serialize((DigitalObject)obj, (OutputStream)out, format, "UTF-8", 0);
            String[] lines = new String(out.toByteArray(), "UTF-8").split("\n");
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = lines[i].replaceAll("\r", "");
            }
            return lines;
        }
        catch (UnsupportedTranslationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Test failure: " + e.getClass().getName());
        }
    }

    private static InputStream getInputStream(String value) {
        try {
            return new ByteArrayInputStream(value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new Error(wontHappen);
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestDOTranslatorImpl.class);
    }
}

