/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.fcrepo.common.Constants;
import org.fcrepo.server.storage.translation.DOTranslatorImpl;
import org.fcrepo.server.storage.translation.METSFedoraExt1_1DODeserializer;
import org.fcrepo.server.storage.translation.METSFedoraExt1_1DOSerializer;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.validation.DOValidatorImpl;

public class METSInOutTest
implements Constants {
    public static void main(String[] args) {
        FileInputStream in = null;
        System.setProperty("fedoraServerHost", "localhost");
        System.setProperty("fedoraServerPort", "80");
        try {
            if (args.length < 1) {
                throw new IOException("At least one parameter needed.");
            }
            in = new FileInputStream(new File(args[0]));
        }
        catch (IOException ioe) {
            System.out.println("Error: " + ioe.getMessage());
            System.out.println("Give the path to an existing METS file, and optionally, the level of validation to perform on the re-serialized version.");
            System.exit(0);
        }
        try {
            METSFedoraExt1_1DODeserializer deser = new METSFedoraExt1_1DODeserializer();
            METSFedoraExt1_1DOSerializer ser = new METSFedoraExt1_1DOSerializer();
            HashMap<String, METSFedoraExt1_1DODeserializer> desers = new HashMap<String, METSFedoraExt1_1DODeserializer>();
            HashMap<String, METSFedoraExt1_1DOSerializer> sers = new HashMap<String, METSFedoraExt1_1DOSerializer>();
            desers.put(METSInOutTest.METS_EXT1_1.uri, deser);
            sers.put(METSInOutTest.METS_EXT1_1.uri, ser);
            DOTranslatorImpl trans = new DOTranslatorImpl(sers, desers);
            BasicDigitalObject obj = new BasicDigitalObject();
            System.out.println("Deserializing...");
            trans.deserialize((InputStream)in, (DigitalObject)obj, METSInOutTest.METS_EXT1_1.uri, "UTF-8", 0);
            System.out.println("Done.");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.out.println("Re-serializing for STORAGE...");
            trans.serialize((DigitalObject)obj, (OutputStream)out, METSInOutTest.METS_EXT1_1.uri, "UTF-8", 3);
            System.out.println("Done.");
            if (args.length > 1) {
                ByteArrayInputStream newIn = new ByteArrayInputStream(out.toByteArray());
                HashMap<String, String> xmlSchemaMap = new HashMap<String, String>();
                xmlSchemaMap.put(METSInOutTest.METS_EXT1_1.uri, "dist/server/xsd/mets-fedora-ext1-1.xsd");
                HashMap<String, String> ruleSchemaMap = new HashMap<String, String>();
                ruleSchemaMap.put(METSInOutTest.METS_EXT1_1.uri, "dist/server/schematron/metsExtRules1-0.xml");
                DOValidatorImpl v = new DOValidatorImpl(null, xmlSchemaMap, "dist/server/schematron/preprocessor.xslt", ruleSchemaMap);
                if (args[1].equals("1")) {
                    v.validate((InputStream)newIn, METSInOutTest.METS_EXT1_1.uri, 1, "ingest");
                    System.out.println("XML Schema validation: PASSED!");
                } else if (args[1].equals("2")) {
                    v.validate((InputStream)newIn, METSInOutTest.METS_EXT1_1.uri, 2, "ingest");
                    System.out.println("Schematron validation: PASSED!");
                } else {
                    System.out.println("Unrecognized validation level, '" + args[1] + "'");
                }
            } else {
                System.out.println("Here it is:");
                System.out.println(out.toString("UTF-8"));
            }
        }
        catch (Exception e) {
            System.out.println("Error: (" + e.getClass().getName() + "):" + e.getMessage());
            e.printStackTrace();
        }
    }
}

