/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Server;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.DigitalObject;

public class TranslatorTest {
    public static void main(String[] args) {
        FileInputStream in = null;
        try {
            if (args.length != 3) {
                throw new IOException("*Three* parameters needed, filename, format, and encoding.");
            }
            if (Constants.FEDORA_HOME == null) {
                throw new IOException("FEDORA_HOME is not set. Try using -Dfedora.home=path/to/fedorahome");
            }
            in = new FileInputStream(new File(args[0]));
            Server server = Server.getInstance((File)new File(Constants.FEDORA_HOME));
            DOTranslator trans = (DOTranslator)server.getModule("org.fcrepo.server.storage.translation.DOTranslator");
            if (trans == null) {
                throw new IOException("DOTranslator module not found via getModule");
            }
            BasicDigitalObject obj = new BasicDigitalObject();
            System.out.println("Deserializing...");
            trans.deserialize((InputStream)in, (DigitalObject)obj, args[1], args[2], 0);
            System.out.println("Done.");
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            System.out.println("Re-serializing...");
            trans.serialize((DigitalObject)obj, (OutputStream)outStream, args[1], args[2], 3);
            System.out.println("Done. Here it is:");
            System.out.println(outStream.toString(args[2]));
            server.shutdown(null);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getClass().getName() + " " + e.getMessage() + "\n");
            e.printStackTrace();
        }
    }
}

