/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.mock.server.utilities.MockTableSpec;
import org.fcrepo.server.errors.InconsistentTableSpecException;
import org.fcrepo.server.utilities.DerbyDDLConverter;
import org.fcrepo.server.utilities.TableSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class DerbyDDLConverterIntegrationTest {
    private DerbyDDLConverter converter;
    private List<String> expectedStmts;
    private final String OBJECT_PATHS_TABLE_SPEC = "CREATE TABLE objectPaths (\n  tokenDbID INT NOT NULL GENERATED ALWAYS AS IDENTITY,\n  token VARCHAR(64) UNIQUE NOT NULL DEFAULT '',\n  path VARCHAR(255) NOT NULL DEFAULT '',\n  PRIMARY KEY (tokenDbID))";
    private final String DATASTREAM_PATHS_TABLE_SPEC = "CREATE TABLE datastreamPaths (\n  tokenDbID INT NOT NULL GENERATED ALWAYS AS IDENTITY,\n  token VARCHAR(199) UNIQUE NOT NULL DEFAULT '',\n  path VARCHAR(255) NOT NULL DEFAULT '',\n  PRIMARY KEY (tokenDbID))";
    private final String PID_GEN_TABLE_SPEC = "CREATE TABLE pidGen (\n  namespace VARCHAR(255) NOT NULL,\n  highestID INT NOT NULL)";
    private final String DO_REGISTRY_TABLE_SPEC = "CREATE TABLE doRegistry (\n  doPID VARCHAR(64) NOT NULL,\n  systemVersion INT NOT NULL DEFAULT 0,\n  ownerId VARCHAR(64),\n  objectState VARCHAR(1) NOT NULL DEFAULT 'A',\n  label VARCHAR(255) DEFAULT '',\n  PRIMARY KEY (doPID))";
    private final String MODEL_DEPLOYMENT_MAP_TABLE_SPEC = "CREATE TABLE modelDeploymentMap (\n  cModel VARCHAR(64) NOT NULL,\n  sDef VARCHAR(64) NOT NULL,\n  sDep VARCHAR(64) NOT NULL)";
    private final String DO_FIELDS_TABLE_SPEC = "CREATE TABLE doFields (\n  pid VARCHAR(64) NOT NULL,\n  label VARCHAR(255),\n  state VARCHAR(1) NOT NULL DEFAULT 'A',\n  ownerId VARCHAR(64),\n  cDate BIGINT NOT NULL,\n  mDate BIGINT NOT NULL,\n  dcmDate BIGINT,\n  dcTitle CLOB,\n  dcCreator CLOB,\n  dcSubject CLOB,\n  dcDescription CLOB,\n  dcPublisher CLOB,\n  dcContributor CLOB,\n  dcDate CLOB,\n  dcType CLOB,\n  dcFormat CLOB,\n  dcIdentifier CLOB,\n  dcSource CLOB,\n  dcLanguage CLOB,\n  dcRelation CLOB,\n  dcCoverage CLOB,\n  dcRights CLOB)";
    private final String DC_DATES_TABLE_SPEC = "CREATE TABLE dcDates (\n  pid VARCHAR(64) NOT NULL,\n  dcDate BIGINT NOT NULL)";
    private final String DO_FIELDS_INDEX = "CREATE INDEX doFields_pid ON doFields (pid)";
    private final String DC_DATES_INDEX = "CREATE INDEX dcDates_pid ON dcDates (pid)";

    @Before
    public void setUp() throws Exception {
        this.converter = new DerbyDDLConverter();
        this.expectedStmts = new LinkedList<String>();
        this.expectedStmts.add("CREATE TABLE objectPaths (\n  tokenDbID INT NOT NULL GENERATED ALWAYS AS IDENTITY,\n  token VARCHAR(64) UNIQUE NOT NULL DEFAULT '',\n  path VARCHAR(255) NOT NULL DEFAULT '',\n  PRIMARY KEY (tokenDbID))");
        this.expectedStmts.add("CREATE TABLE datastreamPaths (\n  tokenDbID INT NOT NULL GENERATED ALWAYS AS IDENTITY,\n  token VARCHAR(199) UNIQUE NOT NULL DEFAULT '',\n  path VARCHAR(255) NOT NULL DEFAULT '',\n  PRIMARY KEY (tokenDbID))");
        this.expectedStmts.add("CREATE TABLE pidGen (\n  namespace VARCHAR(255) NOT NULL,\n  highestID INT NOT NULL)");
        this.expectedStmts.add("CREATE TABLE doRegistry (\n  doPID VARCHAR(64) NOT NULL,\n  systemVersion INT NOT NULL DEFAULT 0,\n  ownerId VARCHAR(64),\n  objectState VARCHAR(1) NOT NULL DEFAULT 'A',\n  label VARCHAR(255) DEFAULT '',\n  PRIMARY KEY (doPID))");
        this.expectedStmts.add("CREATE TABLE modelDeploymentMap (\n  cModel VARCHAR(64) NOT NULL,\n  sDef VARCHAR(64) NOT NULL,\n  sDep VARCHAR(64) NOT NULL)");
        this.expectedStmts.add("CREATE TABLE doFields (\n  pid VARCHAR(64) NOT NULL,\n  label VARCHAR(255),\n  state VARCHAR(1) NOT NULL DEFAULT 'A',\n  ownerId VARCHAR(64),\n  cDate BIGINT NOT NULL,\n  mDate BIGINT NOT NULL,\n  dcmDate BIGINT,\n  dcTitle CLOB,\n  dcCreator CLOB,\n  dcSubject CLOB,\n  dcDescription CLOB,\n  dcPublisher CLOB,\n  dcContributor CLOB,\n  dcDate CLOB,\n  dcType CLOB,\n  dcFormat CLOB,\n  dcIdentifier CLOB,\n  dcSource CLOB,\n  dcLanguage CLOB,\n  dcRelation CLOB,\n  dcCoverage CLOB,\n  dcRights CLOB)");
        this.expectedStmts.add("CREATE TABLE dcDates (\n  pid VARCHAR(64) NOT NULL,\n  dcDate BIGINT NOT NULL)");
        this.expectedStmts.add("CREATE INDEX doFields_pid ON doFields (pid)");
        this.expectedStmts.add("CREATE INDEX dcDates_pid ON dcDates (pid)");
    }

    @After
    public void tearDown() throws Exception {
        this.converter = null;
        this.expectedStmts = null;
    }

    @org.junit.Test
    public void testGetDDL() throws InconsistentTableSpecException, IOException {
        List tableSpecs = TableSpec.getTableSpecs((InputStream)MockTableSpec.getTableSpecStream());
        this.verifyInputTableSpec(tableSpecs);
        for (TableSpec spec : tableSpecs) {
            List statements = this.converter.getDDL(spec);
            for (String stmt : statements) {
                this.verifyAndEliminateStatement(stmt);
            }
        }
        Assert.assertTrue((String)("Some statements unverified: " + this.expectedStmts.size()), (boolean)this.expectedStmts.isEmpty());
    }

    private void verifyInputTableSpec(List<TableSpec> tableSpecs) throws InconsistentTableSpecException, IOException {
        int NUM_SPECS = 7;
        int numTableSpecs = tableSpecs.size();
        Assert.assertTrue((String)("There should be 7 tableSpecs: " + numTableSpecs), (numTableSpecs == 7 ? 1 : 0) != 0);
    }

    private void verifyAndEliminateStatement(String stmt) {
        Assert.assertNotNull((Object)stmt);
        String foundStmt = null;
        for (String expected : this.expectedStmts) {
            if (!stmt.equalsIgnoreCase(expected)) continue;
            foundStmt = expected;
        }
        Assert.assertTrue((String)("Creation statement invalid: '" + stmt + "'"), (foundStmt != null ? 1 : 0) != 0);
        this.expectedStmts.remove(foundStmt);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(DerbyDDLConverterIntegrationTest.class);
    }
}

