/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.fcrepo.server.utilities.PIDStreamIterableWrapper;
import org.junit.Assert;
import org.junit.Test;

public class PIDStreamIterableWrapperTest {
    @Test
    public void testEmpty() throws Exception {
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable(""));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("   "));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("\n"));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("   \n"));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("   \n"));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("   \n   \n"));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("\n\n\n\n"));
    }

    @Test
    public void testSingleItem() throws Exception {
        PIDStreamIterableWrapperTest.testIterable(new String[]{"item"}, PIDStreamIterableWrapperTest.getIterable("item"));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"item"}, PIDStreamIterableWrapperTest.getIterable("   item"));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"item"}, PIDStreamIterableWrapperTest.getIterable("   item   "));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"item"}, PIDStreamIterableWrapperTest.getIterable("\n   item   "));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"item"}, PIDStreamIterableWrapperTest.getIterable("\n   item   \n"));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"item"}, PIDStreamIterableWrapperTest.getIterable("item\n"));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"item"}, PIDStreamIterableWrapperTest.getIterable("\nitem"));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"item"}, PIDStreamIterableWrapperTest.getIterable("\nitem\n"));
    }

    @Test
    public void testXML() throws IOException {
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("<dummy>\n</dummy>"));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("\n<dummy>\n</dummy>"));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<dummy>\n</dummy>"));
        PIDStreamIterableWrapperTest.testIterable(new String[0], PIDStreamIterableWrapperTest.getIterable("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<dummy>\n</dummy>"));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"test"}, PIDStreamIterableWrapperTest.getIterable("<dummy>\n<pid>test</pid>\n</dummy>"));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"test"}, PIDStreamIterableWrapperTest.getIterable("\n<dummy>\n\n<pid>test</pid>\n</dummy>"));
        PIDStreamIterableWrapperTest.testIterable(new String[]{"test"}, PIDStreamIterableWrapperTest.getIterable("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<dummy>\n<pid>test</pid>\n</dummy>"));
        String test3 = "\n<dummy>\n\n<pid>test1</pid>\n\n     <pid>test2</pid>\n<pid>test3</pid>    \n</dummy>";
        String[] expected = new String[]{"test1", "test2", "test3"};
        PIDStreamIterableWrapperTest.testIterable(expected, PIDStreamIterableWrapperTest.getIterable(test3));
        test3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + test3;
        PIDStreamIterableWrapperTest.testIterable(expected, PIDStreamIterableWrapperTest.getIterable(test3));
    }

    private static Iterable<String> getIterable(String string) throws IOException {
        return PIDStreamIterableWrapperTest.getIterable(string.getBytes("UTF-8"));
    }

    private static Iterable<String> getIterable(byte[] bytes) throws IOException {
        return new PIDStreamIterableWrapper((InputStream)new ByteArrayInputStream(bytes));
    }

    private static void testIterable(String[] expected, Iterable<String> it) {
        ArrayList<String> res = new ArrayList<String>();
        for (String element : it) {
            res.add(element);
        }
        Assert.assertEquals((String)"Iterator count matches expected", (long)expected.length, (long)res.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)"Element matches", (Object)expected[i], res.get(i));
        }
    }
}

