/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.fcrepo.common.Constants;
import org.fcrepo.common.PID;
import org.fcrepo.common.rdf.SimpleLiteral;
import org.fcrepo.common.rdf.SimpleTriple;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.validation.MockTripleIterator;
import org.fcrepo.server.validation.RelsValidator;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.RDFFormat;

public class RelsValidatorTest
extends TestCase {
    private Collection<Triple> triples;
    private static byte[] RELS_EXT;
    private static byte[] RELS_INT;
    private PID pid;

    public void setUp() {
        this.triples = new HashSet<Triple>();
    }

    public void testValidateValidRelsExt() throws Exception {
        this.pid = PID.getInstance((String)"demo:888");
        ByteArrayInputStream in = new ByteArrayInputStream(RELS_EXT);
        RelsValidator validator = new RelsValidator();
        validator.validate(this.pid, "RELS-EXT", (InputStream)in);
    }

    public void testValidateValidRelsInt() throws Exception {
        this.pid = PID.getInstance((String)"demo:888");
        ByteArrayInputStream in = new ByteArrayInputStream(RELS_INT);
        RelsValidator validator = new RelsValidator();
        validator.validate(this.pid, "RELS-INT", (InputStream)in);
    }

    public void testValidateInvalidRelsExt() throws Exception {
        this.pid = PID.getInstance((String)"demo:888");
        ByteArrayInputStream in = new ByteArrayInputStream(RELS_INT);
        RelsValidator validator = new RelsValidator();
        try {
            validator.validate(this.pid, "RELS-EXT", (InputStream)in);
            RelsValidatorTest.fail((String)"Multiple Description elements not allowed for RELS-EXT");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testEmpty() throws Exception {
        this.testEmpty("RELS-EXT");
        this.testEmpty("RELS-INT");
    }

    private void testEmpty(String dsId) throws Exception {
        String[] empties;
        this.pid = PID.getInstance((String)"demo:demo");
        for (String s : empties = new String[]{"", " ", "</>"}) {
            ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
            try {
                new RelsValidator().validate(this.pid, dsId, (InputStream)in);
                RelsValidatorTest.fail((String)("Empty " + dsId + " datastream incorrectly passed" + " validation: \"" + s + "\""));
            }
            catch (ValidationException e) {
                // empty catch block
            }
        }
    }

    public void testBadSubjectURI() throws Exception {
        this.pid = PID.getInstance((String)"demo:foo");
        String s = PID.getInstance((String)"demo:bar").toURI();
        String p = "urn:p";
        String o = "urn:o";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, false, null));
        try {
            this.validateAndClear("RELS-EXT");
            RelsValidatorTest.fail((String)"RELS-EXT Assertion's subject URI different from digital object URI not allowed");
        }
        catch (ValidationException e) {
            // empty catch block
        }
        s = PID.getInstance((String)"demo:foo").toURI();
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, false, null));
        try {
            this.validateAndClear("RELS-INT");
            RelsValidatorTest.fail((String)"RELS-INT Assertion's subject URI is digital object URI not allowed");
        }
        catch (ValidationException e) {
            // empty catch block
        }
        s = PID.getInstance((String)"demo:bar").toURI() + "/DS1";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, false, null));
        try {
            this.validateAndClear("RELS-INT");
            RelsValidatorTest.fail((String)"RELS-INT Assertion's subject URI is datastream in different digital object not allowed");
        }
        catch (ValidationException e) {
            // empty catch block
        }
        s = PID.getInstance((String)"demo:foo").toURI() + "/";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, false, null));
        try {
            this.validateAndClear("RELS-INT");
            RelsValidatorTest.fail((String)"RELS-INT Assertion's subject URI zero length datastream ID not allowed");
        }
        catch (ValidationException e) {
            // empty catch block
        }
        s = PID.getInstance((String)"demo:foo") + "/DS1:Test";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, false, null));
        try {
            this.validateAndClear("RELS-INT");
            RelsValidatorTest.fail((String)"RELS-INT Assertion's subject URI invalid datastream ID not allowed (colon)");
        }
        catch (ValidationException e) {
            // empty catch block
        }
    }

    public void testBadAssertions() throws Exception {
        this.testBadAssertions("RELS-EXT");
        this.testBadAssertions("RELS-INT");
    }

    private void testBadAssertions(String dsId) throws Exception {
        this.pid = PID.getInstance((String)"demo:foo");
        String p = Constants.MODEL.CONTROL_GROUP.uri;
        String o = "demo:baz";
        this.triples.add(RelsValidatorTest.createTriple(this.pid, p, o, false, null));
        try {
            this.validateAndClear(dsId);
            RelsValidatorTest.fail((String)(dsId + "Fedora Model namespace assertions not allowed"));
        }
        catch (ValidationException e) {
            // empty catch block
        }
        p = Constants.VIEW.DISSEMINATES.uri;
        this.triples.add(RelsValidatorTest.createTriple(this.pid, p, o, false, null));
        try {
            this.validateAndClear(dsId);
            RelsValidatorTest.fail((String)(dsId + "Fedora View namespace assertions not allowed"));
        }
        catch (ValidationException e) {
            // empty catch block
        }
    }

    public void testAssertionsRelsExt() throws Exception {
        this.pid = PID.getInstance((String)"demo:foo");
        String p = "http://purl.org/dc/elements/1.1/title";
        String o = "The God of Small Things";
        this.triples.add(RelsValidatorTest.createTriple(this.pid, p, o, true, null));
        try {
            this.validateAndClear("RELS-EXT");
            RelsValidatorTest.fail((String)"RELS-EXT Dublin Core assertions not allowed");
        }
        catch (ValidationException e) {
            // empty catch block
        }
        o = "urn:xyz";
        p = Constants.MODEL.HAS_SERVICE.uri;
        this.triples.add(RelsValidatorTest.createTriple(this.pid, p, o, false, null));
        try {
            this.validateAndClear("RELS-EXT");
        }
        catch (ValidationException e) {
            RelsValidatorTest.fail((String)("RELS-EXT Model relationship " + p + " should be allowed"));
        }
        p = Constants.MODEL.IS_CONTRACTOR_OF.uri;
        this.triples.add(RelsValidatorTest.createTriple(this.pid, p, o, false, null));
        try {
            this.validateAndClear("RELS-EXT");
        }
        catch (ValidationException e) {
            RelsValidatorTest.fail((String)("RELS-EXT Model relationship " + p + " should be allowed"));
        }
        p = Constants.MODEL.HAS_MODEL.uri;
        this.triples.add(RelsValidatorTest.createTriple(this.pid, p, o, false, null));
        try {
            this.validateAndClear("RELS-EXT");
        }
        catch (ValidationException e) {
            RelsValidatorTest.fail((String)("RELS-EXT Model relationship " + p + " should be allowed"));
        }
        p = Constants.MODEL.IS_DEPLOYMENT_OF.uri;
        this.triples.add(RelsValidatorTest.createTriple(this.pid, p, o, false, null));
        try {
            this.validateAndClear("RELS-EXT");
        }
        catch (ValidationException e) {
            RelsValidatorTest.fail((String)("RELS-EXT Model relationship " + p + " should be allowed"));
        }
    }

    public void testResourceURI() throws Exception {
        this.testResourceURI("RELS-EXT");
        this.testResourceURI("RELS-INT");
    }

    private void testResourceURI(String dsId) throws Exception {
        this.pid = PID.getInstance((String)"demo:foo");
        String s = dsId.equals("RELS-INT") ? this.pid.toURI() + "/DS1" : this.pid.toURI();
        String p = "urn:p";
        String o = "urn:o";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, false, null));
        p = "urn:p";
        o = "urn:o";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, null));
        p = "urn:p";
        o = "1970-01-01T00:00:00Z";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        p = "urn:p";
        o = s;
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, false, null));
        try {
            this.validateAndClear(dsId);
        }
        catch (ValidationException e) {
            RelsValidatorTest.fail((String)(dsId + " Self-referential assertions should be allowed."));
        }
    }

    public void testDatatypes() throws Exception {
        this.testDatatypes("RELS-EXT");
        this.testDatatypes("RELS-INT");
    }

    private void testDatatypes(String dsId) throws Exception {
        this.pid = PID.getInstance((String)"demo:foo");
        String s = dsId.equals("RELS-INT") ? this.pid.toURI() + "/DS1" : this.pid.toURI();
        String p = "urn:p";
        String o = "abc:123";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, false, null));
        this.validateAndClear(dsId);
        o = "1";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.INT.uri));
        this.validateAndClear(dsId);
        o = "abc";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.INT.uri));
        try {
            this.validateAndClear(dsId);
            RelsValidatorTest.fail((String)("Invalid integer value: " + o));
        }
        catch (ValidationException e) {
            // empty catch block
        }
        o = "-0001-01-01T00:00:00";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "1970-01-01T00:00:00";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "1970-01-01T00:00:00.1";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "1970-01-01T00:00:00.01";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "1970-01-01T00:00:00.001";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "-0001-01-01T00:00:00Z";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "1970-01-01T00:00:00Z";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "1970-01-01T00:00:00.1Z";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "1970-01-01T00:00:00.01Z";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "1970-01-01T00:00:00.001Z";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        this.validateAndClear(dsId);
        o = "abc";
        this.triples.add(RelsValidatorTest.createTriple(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri));
        try {
            this.validateAndClear(dsId);
            RelsValidatorTest.fail((String)("Invalid dateTime value: " + o));
        }
        catch (ValidationException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAndClear(String dsId) throws Exception {
        try {
            MockTripleIterator iter = new MockTripleIterator(this.triples);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            iter.toStream(out, RDFFormat.RDF_XML, false);
            new RelsValidator().validate(this.pid, dsId, (InputStream)new ByteArrayInputStream(out.toByteArray()));
        }
        finally {
            this.triples.clear();
        }
    }

    private static Triple createTriple(PID pid, String predicate, String object, boolean isLiteral, String datatype) throws ServerException {
        return RelsValidatorTest.createTriple(pid.toURI(), predicate, object, isLiteral, datatype);
    }

    private static Triple createTriple(String subject, String predicate, String object, boolean isLiteral, String datatype) throws ServerException {
        Object o = null;
        try {
            o = isLiteral ? (datatype == null || datatype.length() == 0 ? new SimpleLiteral(object) : new SimpleLiteral(object, new URI(datatype))) : new SimpleURIReference(new URI(object));
            return new SimpleTriple((SubjectNode)new SimpleURIReference(new URI(subject)), (PredicateNode)new SimpleURIReference(new URI(predicate)), (ObjectNode)o);
        }
        catch (URISyntaxException e) {
            throw new GeneralException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        StringBuilder sbRelsExt = new StringBuilder();
        StringBuilder sbRelsInt = new StringBuilder();
        sbRelsExt.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"         xmlns:rel=\"info:fedora/fedora-system:def/relations-external#\">  <rdf:Description rdf:about=\"info:fedora/demo:888\">     <rel:isMemberOf rdf:resource=\"info:fedora/demo:X\" />  </rdf:Description></rdf:RDF>");
        sbRelsInt.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"         xmlns:relint=\"http://www.example.org/rels-int#\">  <rdf:Description rdf:about=\"info:fedora/demo:888/DS1\">     <relint:someRelation rdf:resource=\"info:fedora/demo:X\" />  </rdf:Description>  <rdf:Description rdf:about=\"info:fedora/demo:888/DS2\">     <relint:someProperty>value</relint:someProperty>  </rdf:Description></rdf:RDF>");
        try {
            RELS_EXT = sbRelsExt.toString().getBytes("UTF-8");
            RELS_INT = sbRelsInt.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

