/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.common.FaultException;
import org.fcrepo.common.PID;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.security.MockPolicyParser;
import org.fcrepo.server.security.PolicyParser;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.MockRepositoryReader;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.ObjectBuilder;
import org.fcrepo.server.validation.ValidationUtility;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ValidationUtilityTest {
    private static final String TEST_PID = "test:1";
    private static final String RELSEXT_GOOD = "<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n       xmlns:rel='info:fedora/fedora-system:def/relations-external#'>\n  <rdf:Description rdf:about='info:fedora/test:1'>\n     <rel:isMemberOf rdf:resource='info:fedora/test:X'/>\n  </rdf:Description>\n</rdf:RDF>";
    private static final String RELSINT_GOOD = "<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n       xmlns:foo='http://www.example.org/bar#'>\n  <rdf:Description rdf:about='info:fedora/test:1/DS1'>\n     <foo:baz rdf:resource='info:fedora/test:X'/>\n  </rdf:Description>\n  <rdf:Description rdf:about='info:fedora/test:1/DS2'>\n     <foo:qux>quux</foo:qux>\n  </rdf:Description>\n</rdf:RDF>";
    private final String tmpDir = System.getProperty("java.io.tmpdir");

    @Test
    public void testValidUrls() throws Exception {
        String[] urls;
        String[] urls_managed;
        for (String url : urls_managed = new String[]{"http://localhost", "http://localhost:8080", "uploaded:///tmp/foo.xml", "file:///etc/passwd", "file:/etc/passwd"}) {
            ValidationUtility.validateURL((String)url, (String)"M");
        }
        for (String url : urls = new String[]{"http://localhost", "http://localhost:8080", "uploaded:///tmp/foo.xml"}) {
            ValidationUtility.validateURL((String)url, (String)"M");
        }
    }

    @Test
    public void testInvalidUrls() {
        String[] urls;
        String[] urls_management;
        for (String url : urls_management = new String[]{"", "a", "temp:///etc/passwd", "copy:///etc/passwd", "temp://" + this.tmpDir + "/../etc/passwd", "temp://" + this.tmpDir + "/../../etc/passwd", "/etc/passwd", "../../etc/passwd"}) {
            try {
                ValidationUtility.validateURL((String)url, (String)"M");
            }
            catch (Exception e) {
                Assert.assertTrue((String)("Expected Exception of type " + ValidationException.class.getName() + " but got: " + e.getClass().getName()), (boolean)e.getClass().getName().equals(ValidationException.class.getName()));
                continue;
            }
            Assert.fail((String)("Expected " + ValidationException.class.getName() + " for URL:" + url + " but got none"));
        }
        for (String url : urls = new String[]{"", "a", "temp:///etc/passwd", "copy:///etc/passwd", "temp://" + this.tmpDir + "/../etc/passwd", "temp://" + this.tmpDir + "/../../etc/passwd", "/etc/passwd", "../../etc/passwd", "file:///etc/passwd", "file:/etc/passwd"}) {
            try {
                ValidationUtility.validateURL((String)url, (String)"R");
            }
            catch (Exception e) {
                Assert.assertTrue((String)("Expected Exception of type " + ValidationException.class.getName() + " but got: " + e.getClass().getName()), (boolean)e.getClass().getName().equals(ValidationException.class.getName()));
                continue;
            }
            Assert.fail((String)("Expected " + ValidationException.class.getName() + " for URL:" + url + " but got none"));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testValidatePolicyParserNotSet() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validatePolicy(null, "<Policy PolicyId='foo' RuleCombiningAlgId='urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable'/>");
    }

    @Test(expected=ValidationException.class)
    public void testValidatePolicyBad() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validatePolicy(new MockPolicyParser(), "<Policy unexpectedAttribute='thisOne' PolicyId='foo' RuleCombiningAlgId='urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable'/>");
    }

    @Test
    public void testValidatePolicyGood() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validatePolicy(new MockPolicyParser(), "<Policy PolicyId='foo' RuleCombiningAlgId='urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable'/>");
    }

    @Test(expected=ValidationException.class)
    public void testValidateRelsExtBad() throws ValidationException {
        ValidationUtilityTest.validateRels("RELS-EXT", "");
    }

    @Test(expected=ValidationException.class)
    public void testValidateRelsIntBad() throws ValidationException {
        ValidationUtilityTest.validateRels("RELS-INT", "");
    }

    @Test
    public void testValidateRelsExtGood() throws ValidationException {
        ValidationUtilityTest.validateRels("RELS-EXT", RELSEXT_GOOD);
    }

    @Test
    public void testValidateRelsIntGood() throws ValidationException {
        ValidationUtilityTest.validateRels("RELS-INT", RELSINT_GOOD);
    }

    @Test
    public void testValidateReservedNone() throws ValidationException {
        ValidationUtilityTest.validateReserved(null, new String[0]);
    }

    @Test(expected=ValidationException.class)
    public void testValidateReservedPolicyBad() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validateReserved(new MockPolicyParser(), new String[]{"POLICY", "<Policy unexpectedAttribute='thisOne' PolicyId='foo' RuleCombiningAlgId='urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable'/>"});
    }

    @Test
    public void testValidateReservedPolicyGood() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validateReserved(new MockPolicyParser(), new String[]{"POLICY", "<Policy PolicyId='foo' RuleCombiningAlgId='urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable'/>"});
    }

    @Test(expected=ValidationException.class)
    public void testValidateReservedRelsExtBad() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validateReserved(new MockPolicyParser(), new String[]{"RELS-EXT", ""});
    }

    @Test(expected=ValidationException.class)
    public void testValidateReservedRelsIntBad() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validateReserved(new MockPolicyParser(), new String[]{"RELS-INT", ""});
    }

    @Test
    public void testValidateReservedRelsExtGood() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validateReserved(new MockPolicyParser(), new String[]{"RELS-EXT", RELSEXT_GOOD});
    }

    @Test
    public void testValidateReservedRelsIntGood() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validateReserved(new MockPolicyParser(), new String[]{"RELS-INT", RELSINT_GOOD});
    }

    @Test
    public void testValidateReservedAllGood() throws IOException, SAXException, ValidationException {
        ValidationUtilityTest.validateReserved(new MockPolicyParser(), new String[]{"POLICY", "<Policy PolicyId='foo' RuleCombiningAlgId='urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable'/>", "RELS-EXT", RELSEXT_GOOD, "RELS-INT", RELSINT_GOOD});
    }

    private static void validatePolicy(PolicyParser parser, String policy) throws IOException, SAXException, ValidationException {
        ValidationUtility.setPolicyParser((PolicyParser)parser);
        DatastreamXMLMetadata dsxml = new DatastreamXMLMetadata();
        dsxml.xmlContent = policy.getBytes();
        ValidationUtility.validateReservedDatastream((PID)PID.getInstance((String)TEST_PID), (String)"POLICY", (Datastream)dsxml);
    }

    private static void validateRels(String dsId, String rels) throws ValidationException {
        DatastreamXMLMetadata dsxml = new DatastreamXMLMetadata();
        dsxml.xmlContent = rels.getBytes();
        ValidationUtility.validateReservedDatastream((PID)PID.getInstance((String)TEST_PID), (String)dsId, (Datastream)dsxml);
    }

    private static void validateReserved(PolicyParser parser, String[] dsData) throws ValidationException {
        ValidationUtility.setPolicyParser((PolicyParser)parser);
        ValidationUtility.validateReservedDatastreams((DOReader)ValidationUtilityTest.getDOReader(dsData));
    }

    private static DOReader getDOReader(String[] dsData) {
        MockRepositoryReader repo = new MockRepositoryReader();
        try {
            BasicDigitalObject obj = new BasicDigitalObject();
            obj.setPid(TEST_PID);
            for (int i = 0; i < dsData.length; i += 2) {
                ObjectBuilder.addXDatastream((DigitalObject)obj, dsData[i], dsData[i + 1]);
            }
            repo.putObject((DigitalObject)obj);
            DOReader reader = repo.getReader(false, (Context)ReadOnlyContext.EMPTY, TEST_PID);
            return reader;
        }
        catch (Exception wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ValidationUtilityTest.class);
    }
}

