/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utilities;

import java.util.HashMap;
import java.util.Iterator;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.utilities.NamespaceContextImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class NamespaceContextImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @org.junit.Test
    public void testNamespaceContextImpl() {
        NamespaceContextImpl nsCtx = new NamespaceContextImpl();
        Assert.assertEquals((Object)"", (Object)nsCtx.getNamespaceURI(""));
        Assert.assertEquals((Object)"http://www.w3.org/XML/1998/namespace", (Object)nsCtx.getNamespaceURI("xml"));
        Assert.assertEquals((Object)"http://www.w3.org/2000/xmlns/", (Object)nsCtx.getNamespaceURI("xmlns"));
    }

    @org.junit.Test
    public void testNamespaceContextImplMapOfStringString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("xml", "http://www.w3.org/XML/1998/namespace");
        try {
            new NamespaceContextImpl(map);
            Assert.fail((String)"Added a mapping for http://www.w3.org/XML/1998/namespace");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("not allowed."));
        }
    }

    @org.junit.Test
    public void testGetNamespaceURI() {
        NamespaceContextImpl nsCtx = new NamespaceContextImpl();
        Assert.assertEquals((Object)"", (Object)nsCtx.getNamespaceURI(""));
        Assert.assertEquals((Object)"http://www.w3.org/XML/1998/namespace", (Object)nsCtx.getNamespaceURI("xml"));
        Assert.assertEquals((Object)"http://www.w3.org/2000/xmlns/", (Object)nsCtx.getNamespaceURI("xmlns"));
    }

    @org.junit.Test
    public void testGetPrefix() {
        NamespaceContextImpl nsCtx = new NamespaceContextImpl();
        Assert.assertEquals((Object)"xml", (Object)nsCtx.getPrefix("http://www.w3.org/XML/1998/namespace"));
        Assert.assertEquals((Object)"xmlns", (Object)nsCtx.getPrefix("http://www.w3.org/2000/xmlns/"));
    }

    @org.junit.Test
    public void testGetPrefixes() {
        NamespaceContextImpl nsCtx = new NamespaceContextImpl();
        String prefix = "foo";
        String ns = "http://www.example.org/foo";
        nsCtx.addNamespace(prefix, ns);
        Iterator it = nsCtx.getPrefixes(ns);
        Assert.assertNotNull((Object)it);
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)prefix, it.next());
        try {
            it.remove();
            Assert.fail((String)"remove() succeeded on what should be an unmodifiable Iterator.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)it.hasNext());
        it = nsCtx.getPrefixes("noMapping");
        Assert.assertNotNull((Object)it);
        Assert.assertFalse((boolean)it.hasNext());
    }

    @org.junit.Test
    public void testAddNamespace() {
        NamespaceContextImpl nsCtx = new NamespaceContextImpl();
        String prefix = "foo";
        String ns = "http://www.example.org/foo";
        nsCtx.addNamespace(prefix, ns);
        Assert.assertEquals((Object)ns, (Object)nsCtx.getNamespaceURI(prefix));
        Assert.assertEquals((Object)prefix, (Object)nsCtx.getPrefix(ns));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(NamespaceContextImplTest.class);
    }
}

