/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.fcrepo.utilities.Zip;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestZip {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();
    private File TMP_DIR;
    private File SRC_DIR;
    private File ZIP_FILE;

    @Before
    public void setUp() throws Exception {
        this.TMP_DIR = folder.newFolder(new String[]{"TestZip"});
        this.SRC_DIR = new File(this.TMP_DIR, "src");
        this.ZIP_FILE = new File(this.TMP_DIR, "test.zip");
        File foo = new File(this.SRC_DIR, "foo");
        File bar = new File(this.SRC_DIR, "bar");
        File baz = new File(bar, "baz");
        File footxt = new File(foo, "foo.txt");
        File bartxt = new File(bar, "bar.txt");
        foo.mkdirs();
        baz.mkdirs();
        FileWriter fw = new FileWriter(footxt);
        fw.write("foo");
        fw.close();
        FileWriter bw = new FileWriter(bartxt);
        bw.write("bar");
        bw.close();
    }

    @Test
    public void testZip() throws Exception {
        Zip.zip((File)this.ZIP_FILE, (File[])this.SRC_DIR.listFiles());
        Assert.assertEquals((long)5L, (long)new ZipFile(this.ZIP_FILE).size());
    }

    @Test
    public void testUnzip() throws Exception {
        FileInputStream fis = new FileInputStream(this.ZIP_FILE);
        Zip.unzip((InputStream)fis, (File)this.TMP_DIR);
        FileReader fr = new FileReader(this.TMP_DIR + File.separator + "foo" + File.separator + "foo.txt");
        BufferedReader buff = new BufferedReader(fr);
        boolean eof = false;
        while (!eof) {
            String line = buff.readLine();
            if (line == null) {
                eof = true;
                continue;
            }
            Assert.assertEquals((Object)"foo", (Object)line);
        }
        buff.close();
    }
}

