/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.oai.sample;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.oai.BadResumptionTokenException;
import org.fcrepo.oai.DateGranularitySupport;
import org.fcrepo.oai.DeletedRecordSupport;
import org.fcrepo.oai.IDDoesNotExistException;
import org.fcrepo.oai.OAIProvider;
import org.fcrepo.oai.Record;
import org.fcrepo.oai.SimpleHeader;
import org.fcrepo.oai.SimpleMetadataFormat;
import org.fcrepo.oai.SimpleRecord;
import org.fcrepo.oai.SimpleSetInfo;

public class SampleOAIProvider
implements Constants,
OAIProvider {
    private static String s_rec1_identifier = "sample:1";
    private static String s_rec1_metadata = "        <oai_dc:dc\n           xmlns:oai_dc=\"" + SampleOAIProvider.OAI_DC.uri + "\"\n" + "           xmlns:dc=\"" + SampleOAIProvider.DC.uri + "\"\n" + "           xmlns:xsi=\"" + SampleOAIProvider.XSI.uri + "\"\n" + "           xsi:schemaLocation=\"" + SampleOAIProvider.OAI_DC.uri + "\n" + "           " + SampleOAIProvider.OAI_DC2_0.xsdLocation + "\">\n" + "          <dc:title>Using Structural Metadata to Localize Experience of \n" + "                    Digital Content</dc:title>\n" + "          <dc:creator>Dushay, Naomi</dc:creator>\n" + "          <dc:subject>Digital Libraries</dc:subject>\n" + "          <dc:description>With the increasing technical sophistication of\n" + "              both information consumers and providers, there is\n" + "              increasing demand for more meaningful experiences of digital\n" + "              information. We present a framework that separates digital\n" + "              object experience, or rendering, from digital object storage\n" + "              and manipulation, so the rendering can be tailored to\n" + "              particular communities of users.\n" + "          </dc:description>\n" + "          <dc:description>Comment: 23 pages including 2 appendices,\n" + "              8 figures</dc:description>\n" + "          <dc:date>2001-12-14</dc:date>\n" + "        </oai_dc:dc>";
    private static String s_rec1_about = "        <provenance\n         xmlns=\"" + SampleOAIProvider.OAI_PROV.uri + "\"\n" + "         xmlns:xsi=\"" + SampleOAIProvider.XSI.uri + "\"\n" + "         xsi:schemaLocation=\"" + SampleOAIProvider.OAI_PROV.uri + "\n" + "         " + SampleOAIProvider.OAI_PROV2_0.xsdLocation + "\">\n" + "         <originDescription harvestDate=\"2002-01-01T11:10:01Z\" altered=\"true\">\n" + "          <baseURL>http://some.oa.org</baseURL>\n" + "          <identifier>oai:r2.org:klik001</identifier>\n" + "          <datestamp>2001-01-01</datestamp>\n" + "          <metadataNamespace>" + SampleOAIProvider.OAI_DC.uri + "</metadataNamespace>\n" + "          </originDescription>\n" + "        </provenance>";
    private final SimpleHeader m_head1;
    private final SimpleRecord m_rec1;

    public SampleOAIProvider() {
        HashSet<String> s = new HashSet<String>();
        s.add("cs");
        s.add("cornell");
        this.m_head1 = new SimpleHeader(s_rec1_identifier, new Date(), s, true);
        HashSet<String> a = new HashSet<String>();
        a.add(s_rec1_about);
        this.m_rec1 = new SimpleRecord(this.m_head1, s_rec1_metadata, a);
    }

    @Override
    public String getRepositoryName() {
        return "My Repository";
    }

    @Override
    public String getBaseURL(String protocol, String port) {
        return protocol + "://localhost:" + port + "/path/to/servlet";
    }

    @Override
    public String getProtocolVersion() {
        return "2.0";
    }

    @Override
    public Date getEarliestDatestamp() {
        return new Date();
    }

    @Override
    public DeletedRecordSupport getDeletedRecordSupport() {
        return DeletedRecordSupport.NO;
    }

    @Override
    public DateGranularitySupport getDateGranularitySupport() {
        return DateGranularitySupport.SECONDS;
    }

    @Override
    public Set getAdminEmails() {
        HashSet<String> s = new HashSet<String>();
        s.add("nobody@nowhere.com");
        return s;
    }

    @Override
    public Set getSupportedCompressionEncodings() {
        return new HashSet();
    }

    @Override
    public Set getDescriptions() {
        return new HashSet();
    }

    @Override
    public Record getRecord(String identifier, String metadataPrefix) throws IDDoesNotExistException {
        if (identifier.equals("sample:1")) {
            return this.m_rec1;
        }
        throw new IDDoesNotExistException("An item with that id was not found.");
    }

    @Override
    public List getRecords(Date from, Date until, String metadataPrefix, String set) {
        ArrayList<SimpleRecord> a = new ArrayList<SimpleRecord>();
        a.add(this.m_rec1);
        return a;
    }

    @Override
    public List getRecords(String resumptionToken) throws BadResumptionTokenException {
        throw new BadResumptionTokenException("Sample doesn't support resumptionTokens.");
    }

    @Override
    public List getHeaders(Date from, Date until, String metadataPrefix, String set) {
        ArrayList<SimpleHeader> a = new ArrayList<SimpleHeader>();
        a.add(this.m_head1);
        return a;
    }

    @Override
    public List getHeaders(String resumptionToken) throws BadResumptionTokenException {
        throw new BadResumptionTokenException("Sample doesn't support resumptionTokens.");
    }

    @Override
    public List getSets() {
        ArrayList<SimpleSetInfo> a = new ArrayList<SimpleSetInfo>();
        a.add(new SimpleSetInfo("Computer Science", "cs", new HashSet()));
        a.add(new SimpleSetInfo("Cornell University", "cornell", new HashSet()));
        return a;
    }

    @Override
    public List getSets(String resumptionToken) throws BadResumptionTokenException {
        throw new BadResumptionTokenException("Sample doesn't support resumptionTokens.");
    }

    @Override
    public Set getMetadataFormats(String id) {
        HashSet<SimpleMetadataFormat> s = new HashSet<SimpleMetadataFormat>();
        s.add(new SimpleMetadataFormat(SampleOAIProvider.OAI_DC.prefix, SampleOAIProvider.OAI_DC2_0.xsdLocation, SampleOAIProvider.OAI_DC.uri));
        return s;
    }

    @Override
    public long getMaxSets() {
        return 10L;
    }

    @Override
    public long getMaxRecords() {
        return 10L;
    }

    @Override
    public long getMaxHeaders() {
        return 10L;
    }
}

