/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.util.Map;
import org.fcrepo.server.Pluggable;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Module
extends Pluggable {
    private static final Logger logger = LoggerFactory.getLogger(Module.class);
    private final String m_role;
    private final Server m_server;

    public Module(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters);
        this.m_role = role;
        this.m_server = server;
    }

    public Server getServer() {
        return this.m_server;
    }

    public final String getRole() {
        return this.m_role;
    }

    public void initModule() throws ModuleInitializationException {
    }

    public void postInitModule() throws ModuleInitializationException {
    }

    public void shutdownModule() throws ModuleShutdownException {
        logger.info("Shutting down " + this.getClass().getName());
    }
}

