/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.server.config.Parameter;

public abstract class Parameterized
implements Constants {
    private final Map<String, Parameter> m_parameters = new HashMap<String, Parameter>();

    public Parameterized() {
    }

    public Parameterized(Map<String, String> parameters) {
        this.setParameters(parameters);
    }

    public Parameterized(List<Parameter> parameters) {
        this.setParameters(parameters);
    }

    protected final void setParameters(Map<String, String> parameters) {
        this.setParameters(Parameterized.getParameterList(parameters));
    }

    protected final void setParameters(List<Parameter> parameters) {
        if (parameters == null) {
            this.m_parameters.clear();
        } else {
            this.m_parameters.clear();
            for (Parameter p : parameters) {
                this.m_parameters.put(p.getName(), p);
            }
        }
    }

    public final String getParameter(String name, boolean asAbsolutePath) {
        File f;
        if (!this.m_parameters.containsKey(name)) {
            return null;
        }
        String paramValue = this.m_parameters.get(name).getValue();
        if (asAbsolutePath && paramValue != null && !(f = new File(paramValue)).isAbsolute()) {
            paramValue = FEDORA_HOME + File.separator + paramValue;
        }
        return paramValue;
    }

    public final String getParameter(String name) {
        return this.getParameter(name, false);
    }

    public final Parameter getParameter(String name, Class<Parameter> type) {
        return this.m_parameters.get(name);
    }

    protected final void setParameter(String name, String value) {
        Parameter parm = this.m_parameters.get(name);
        if (parm == null) {
            parm = new Parameter(name);
            this.m_parameters.put(name, parm);
        }
        parm.setValue(value);
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> result = new HashMap<String, String>(this.m_parameters.size(), 1.0f);
        for (Map.Entry<String, Parameter> entry : this.m_parameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return result;
    }

    public Collection<Parameter> getParameters(Class<Parameter> type) {
        return this.m_parameters.values();
    }

    public final Iterator<String> parameterNames() {
        return this.m_parameters.keySet().iterator();
    }

    protected static List<Parameter> getParameterList(Map<String, String> map) {
        Set<String> keys = map.keySet();
        Parameter[] parms = new Parameter[keys.size()];
        int i = 0;
        for (String key : keys) {
            parms[i] = new Parameter(key);
            parms[i].setValue(map.get(key));
            ++i;
        }
        return Arrays.asList(parms);
    }
}

