/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.fcrepo.common.Constants;
import org.fcrepo.common.FaultException;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.common.http.WebClientConfiguration;
import org.fcrepo.server.Context;
import org.fcrepo.server.DatastoreConfig;
import org.fcrepo.server.Module;
import org.fcrepo.server.Pluggable;
import org.fcrepo.server.config.DatastoreConfiguration;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.config.Parameter;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.config.ServerConfigurationParser;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.MalformedPidException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.errors.ServerInitializationException;
import org.fcrepo.server.errors.ServerShutdownException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.resourceIndex.ModelBasedTripleGenerator;
import org.fcrepo.server.security.Authorization;
import org.fcrepo.server.utilities.status.ServerState;
import org.fcrepo.server.utilities.status.ServerStatusFile;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Server
extends Pluggable
implements ApplicationContextAware,
BeanDefinitionRegistry,
ListableBeanFactory {
    public static final boolean USE_CACHE = true;
    public static final boolean USE_DEFINITIVE_STORE = false;
    public static final boolean GLOBAL_CHOICE = false;
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private static ResourceBundle s_const = ResourceBundle.getBundle("org.fcrepo.server.resources.Server");
    private static MetadataReaderFactory s_readerFactory = new SimpleMetadataReaderFactory();
    public static String VERSION = s_const.getString("version");
    public static String BUILD_DATE = s_const.getString("buildDate");
    public static String HOME_PROPERTY = s_const.getString("home.property");
    public static String STORAGE_FORMAT = s_const.getString("format.storage");
    public static String CONFIG_DIR = s_const.getString("config.dir");
    public static String SPRING_DIR = s_const.getString("spring.dir");
    public static String LOG_STARTUP_FILE = s_const.getString("log.startup.file");
    public static String CONFIG_FILE = s_const.getString("config.file");
    public static String EXTENSION_DIR = s_const.getString("extension.dir");
    public static String BIN_DIR = s_const.getString("bin.dir");
    public static String NAMESPACE_PREFIX = MessageFormat.format(s_const.getString("namespace.prefix"), "1", "0");
    public static String CONFIG_NAMESPACE = MessageFormat.format(s_const.getString("config.namespace"), NAMESPACE_PREFIX);
    public static String CONFIG_ELEMENT_ROOT = s_const.getString("config.element.root");
    public static String CONFIG_ELEMENT_COMMENT = s_const.getString("config.element.comment");
    public static String CONFIG_ELEMENT_DATASTORE = s_const.getString("config.element.datastore");
    public static String CONFIG_ELEMENT_MODULE = s_const.getString("config.element.module");
    public static String CONFIG_ELEMENT_PARAM = s_const.getString("config.element.param");
    public static String CONFIG_ATTRIBUTE_CLASS = s_const.getString("config.attribute.class");
    public static String CONFIG_ATTRIBUTE_ROLE = s_const.getString("config.attribute.role");
    public static String CONFIG_ATTRIBUTE_NAME = s_const.getString("config.attribute.name");
    public static String CONFIG_ATTRIBUTE_VALUE = s_const.getString("config.attribute.value");
    public static String CONFIG_ATTRIBUTE_ID = s_const.getString("config.attribute.id");
    public static String SERVER_CONSTRUCTOR_PARAM1_CLASS = s_const.getString("server.constructor.param1.class");
    public static String SERVER_CONSTRUCTOR_PARAM2_CLASS = s_const.getString("server.constructor.param2.class");
    public static String MODULE_CONSTRUCTOR_PARAM1_CLASS = s_const.getString("module.constructor.param1.class");
    public static String MODULE_CONSTRUCTOR_PARAM2_CLASS = s_const.getString("module.constructor.param2.class");
    public static String MODULE_CONSTRUCTOR_PARAM3_CLASS = s_const.getString("module.constructor.param3.class");
    public static String DEFAULT_SERVER_CLASS = s_const.getString("default.server.class");
    public static String INIT_XMLPARSER_SEVERE_MISSING = s_const.getString("init.xmlparser.severe.missing");
    public static String INIT_CONFIG_SEVERE_UNREADABLE = s_const.getString("init.config.severe.unreadable");
    public static String INIT_CONFIG_SEVERE_MALFORMEDXML = s_const.getString("init.config.severe.malformedxml");
    public static String INIT_CONFIG_SEVERE_BADROOTELEMENT = s_const.getString("init.config.severe.badrootelement");
    public static String INIT_CONFIG_SEVERE_BADELEMENT = s_const.getString("init.config.severe.badelement");
    public static String INIT_CONFIG_SEVERE_NOIDGIVEN = MessageFormat.format(s_const.getString("init.config.severe.noidgiven"), CONFIG_ELEMENT_DATASTORE, CONFIG_ATTRIBUTE_ID);
    public static String INIT_CONFIG_SEVERE_BADNAMESPACE = s_const.getString("init.config.severe.badnamespace");
    public static String INIT_CONFIG_SEVERE_NOROLEGIVEN = MessageFormat.format(s_const.getString("init.config.severe.norolegiven"), CONFIG_ELEMENT_MODULE, CONFIG_ATTRIBUTE_ROLE);
    public static String INIT_CONFIG_SEVERE_NOCLASSGIVEN = MessageFormat.format(s_const.getString("init.config.severe.noclassgiven"), CONFIG_ELEMENT_MODULE, CONFIG_ATTRIBUTE_CLASS);
    public static String INIT_CONFIG_SEVERE_REASSIGNMENT = s_const.getString("init.config.severe.reassignment");
    public static String INIT_CONFIG_SEVERE_INCOMPLETEPARAM = MessageFormat.format(s_const.getString("init.config.severe.incompleteparam"), CONFIG_ELEMENT_PARAM, CONFIG_ATTRIBUTE_NAME, CONFIG_ATTRIBUTE_VALUE);
    public static String INIT_CONFIG_CONFIG_EXAMININGELEMENT = s_const.getString("init.config.config.examiningelement");
    public static String INIT_CONFIG_CONFIG_PARAMETERIS = s_const.getString("init.config.config.parameteris");
    public static String INIT_SERVER_SEVERE_CLASSNOTFOUND = s_const.getString("init.server.severe.classnotfound");
    public static String INIT_SERVER_SEVERE_ILLEGALACCESS = s_const.getString("init.server.severe.illegalaccess");
    public static String INIT_SERVER_SEVERE_BADARGS = s_const.getString("init.server.severe.badargs");
    public static String INIT_SERVER_SEVERE_MISSINGCONSTRUCTOR = s_const.getString("init.server.severe.missingconstructor");
    public static String INIT_SERVER_SEVERE_UNFULFILLEDROLE = s_const.getString("init.server.severe.unfulfilledrole");
    public static String INIT_MODULE_SEVERE_UNFULFILLEDROLE = s_const.getString("init.module.severe.unfulfilledrole");
    public static String INIT_SERVER_SEVERE_ISABSTRACT = s_const.getString("init.server.severe.isabstract");
    public static String INIT_MODULE_SEVERE_CLASSNOTFOUND = s_const.getString("init.module.severe.classnotfound");
    public static String INIT_MODULE_SEVERE_ILLEGALACCESS = s_const.getString("init.module.severe.illegalaccess");
    public static String INIT_MODULE_SEVERE_BADARGS = s_const.getString("init.module.severe.badargs");
    public static String INIT_MODULE_SEVERE_MISSINGCONSTRUCTOR = s_const.getString("init.module.severe.missingconstructor");
    public static String INIT_MODULE_SEVERE_ISABSTRACT = s_const.getString("init.module.severe.isabstract");
    public static String INIT_LOG_WARNING_CANTWRITESTARTUPLOG = s_const.getString("init.log.warning.cantwritestartuplog");
    private static Locale s_locale;
    protected static Map<File, Server> s_instances;
    private final File m_serverDir;
    private AbstractApplicationContext m_serverContext;
    private GenericApplicationContext m_moduleContext;
    private final File m_uploadDir;
    @Deprecated
    protected Map<String, Module> m_loadedModules;
    @Deprecated
    protected Set<String> m_loadedModuleRoles;
    private final File m_configFile;
    private boolean m_initialized;
    private final ServerStatusFile m_statusFile;
    private static String s_serverProfile;
    private WebClientConfiguration m_webClientConfig;

    protected Server(Map<String, String> params, File homeDir) throws ServerInitializationException, ModuleInitializationException {
        this.setParameters(params);
        this.m_initialized = false;
        this.m_loadedModuleRoles = new HashSet<String>();
        this.m_serverDir = new File(homeDir, "server");
        this.m_uploadDir = new File(this.m_serverDir, "management/upload");
        try {
            this.m_statusFile = new ServerStatusFile(this.m_serverDir);
        }
        catch (Exception e) {
            throw new ServerInitializationException(e.toString());
        }
        File logDir = new File(this.m_serverDir, "logs");
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        this.m_configFile = new File(this.m_serverDir + File.separator + CONFIG_DIR + File.separator + CONFIG_FILE);
        s_instances.put(homeDir, this);
    }

    protected Server(Element rootConfigElement, File homeDir) throws ServerInitializationException, ModuleInitializationException {
        this(Server.loadParameters(rootConfigElement, ""), homeDir);
    }

    public void init() throws ServerInitializationException, ModuleInitializationException {
        logger.info("Registered server at " + this.getHomeDir().getPath());
        try {
            String[] moduleNames;
            String[] reqRoles;
            if (this.m_serverContext == null) {
                this.m_serverContext = this.getDefaultContext();
            }
            this.m_moduleContext = new GenericApplicationContext((ApplicationContext)this.m_serverContext);
            this.registerBeanDefinition(CommonAnnotationBeanPostProcessor.class.getName(), (BeanDefinition)Server.getScannedBeanDefinition(CommonAnnotationBeanPostProcessor.class.getName()));
            this.loadSpringModules();
            if (!this.knownBeanDefinition(ModelBasedTripleGenerator.class.getName())) {
                ScannedGenericBeanDefinition tripleGen = Server.getScannedBeanDefinition(ModelBasedTripleGenerator.class.getName());
                tripleGen.setScope("prototype");
                this.registerBeanDefinition(ModelBasedTripleGenerator.class.getName(), (BeanDefinition)tripleGen);
            }
            logger.info("Server home is " + this.m_serverDir.toString());
            if (s_serverProfile == null) {
                logger.debug("fedora.serverProfile property not set... will always use param 'value' attributes from configuration for param values.");
            } else {
                logger.debug("fedora.serverProfile property was '" + s_serverProfile + "'... will use param '" + s_serverProfile + "value' attributes from " + "configuration for param values, falling back to " + "'value' attributes where unspecified.");
            }
            logger.debug("Loading and validating configuration file \"" + this.m_configFile + "\"");
            ServerConfiguration serverConfig = Server.getConfig();
            List<DatastoreConfiguration> dsConfigs = serverConfig.getDatastoreConfigurations();
            List<ModuleConfiguration> moduleConfigs = serverConfig.getModuleConfigurations();
            for (String element : reqRoles = this.getRequiredModuleRoles()) {
                if (this.knownBeanDefinition(element) || serverConfig.getModuleConfiguration(element) != null) continue;
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_UNFULFILLEDROLE, element));
            }
            this.m_statusFile.append(ServerState.STARTING, "Initializing Server");
            this.initServer();
            this.m_statusFile.append(ServerState.STARTING, "Initializing datastore definitions");
            for (DatastoreConfiguration ds : dsConfigs) {
                String id = ds.getId();
                logger.info("Loading fcfg datastore definitions for " + id);
                this.registerBeanDefinition(id, (BeanDefinition)Server.createDatastoreConfigurationBeanDefinition(id));
            }
            this.initWebClientConfig();
            this.m_statusFile.append(ServerState.STARTING, "Loading Module Definitions");
            for (ModuleConfiguration mconfig : moduleConfigs) {
                String role = mconfig.getRole();
                String className = mconfig.getClassName();
                if (!this.knownBeanDefinition(role)) {
                    logger.info("Loading bean definitions for {} impl class={}", (Object)className, (Object)role);
                    this.registerBeanDefinition(role, (BeanDefinition)Server.createModuleBeanDefinition(className, mconfig.getParameters(), role));
                } else {
                    logger.info("FCFG bean definitions for {} superceded by existing Spring bean definition", (Object)className);
                }
                if (this.knownBeanDefinition(role + "Configuration")) continue;
                this.registerBeanDefinition(role + "Configuration", (BeanDefinition)Server.createModuleConfigurationBeanDefinition(role));
            }
            this.registerBeanDefinitions();
            this.m_statusFile.append(ServerState.STARTING, "Initializing Modules");
            this.m_moduleContext.refresh();
            for (String moduleName : moduleNames = this.getBeanNamesForType(Module.class, false, true)) {
                this.getBean(moduleName);
            }
            this.m_statusFile.append(ServerState.STARTING, "Post-Initializing Modules");
            for (String moduleName : moduleNames) {
                Module m = this.getModule(moduleName);
                logger.info("Post-Initializing " + m.getClass().getName());
                reqRoles = m.getRequiredModuleRoles();
                logger.debug("verifying dependencies have been loaded...");
                for (String element : reqRoles) {
                    if (this.getModule(element) != null) continue;
                    throw new ModuleInitializationException(MessageFormat.format(INIT_MODULE_SEVERE_UNFULFILLEDROLE, element), moduleName);
                }
                logger.debug(reqRoles.length + " dependencies, all loaded, ok.");
                m.postInitModule();
            }
            logger.debug("Post-initializing server");
            this.postInitServer();
            logger.info("Server startup complete");
            this.m_initialized = true;
        }
        catch (ServerInitializationException sie) {
            logger.error("Server failed to initialize", (Throwable)sie);
            try {
                this.shutdown(null);
            }
            catch (Throwable th) {
                logger.warn("Error shutting down server after failed startup", th);
            }
            throw sie;
        }
        catch (ModuleInitializationException mie) {
            logger.error("Module (" + mie.getRole() + ") failed to initialize", (Throwable)mie);
            try {
                this.shutdown(null);
            }
            catch (Throwable th) {
                logger.warn("Error shutting down server after failed startup", th);
            }
            throw mie;
        }
        catch (Throwable th) {
            String msg = "Fatal error while starting server";
            logger.error(msg, th);
            try {
                this.shutdown(null);
            }
            catch (Throwable oth) {
                logger.warn("Error shutting down server after failed startup", oth);
            }
            throw new RuntimeException(msg, th);
        }
    }

    protected AbstractApplicationContext getDefaultContext() throws IOException {
        GenericApplicationContext appContext = new GenericApplicationContext();
        appContext.refresh();
        appContext.registerBeanDefinition(MODULE_CONSTRUCTOR_PARAM2_CLASS, this.getServerBeanDefinition());
        appContext.getBeanFactory().registerSingleton(MODULE_CONSTRUCTOR_PARAM2_CLASS, (Object)this);
        appContext.registerBeanDefinition(ServerConfiguration.class.getName(), Server.getServerConfigurationBeanDefinition());
        ScannedGenericBeanDefinition moduleDef = Server.getScannedBeanDefinition(Module.class.getName());
        moduleDef.setAbstract(true);
        moduleDef.setInitMethodName("initModule");
        moduleDef.setDestroyMethodName("shutdownModule");
        appContext.registerBeanDefinition(Module.class.getName(), (BeanDefinition)moduleDef);
        return appContext;
    }

    protected Server(File homeDir) throws ServerInitializationException, ModuleInitializationException {
        this(Server.getConfigElement(homeDir), homeDir);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.m_serverContext = (AbstractApplicationContext)applicationContext;
    }

    protected BeanDefinition getServerBeanDefinition() {
        GenericBeanDefinition result = new GenericBeanDefinition();
        result.setAutowireCandidate(true);
        result.setScope("singleton");
        result.setBeanClass(this.getClass());
        result.setAttribute("id", (Object)MODULE_CONSTRUCTOR_PARAM2_CLASS);
        result.setAttribute("name", (Object)MODULE_CONSTRUCTOR_PARAM2_CLASS);
        return result;
    }

    protected static BeanDefinition getServerConfigurationBeanDefinition() {
        String className = ServerConfiguration.class.getName();
        GenericBeanDefinition result = new GenericBeanDefinition();
        result.setAutowireCandidate(true);
        result.setScope("singleton");
        result.setBeanClass(Server.class);
        result.setFactoryMethodName("getConfig");
        result.setAttribute("id", (Object)className);
        result.setAttribute("name", (Object)className);
        return result;
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) {
        String beanClassName = this.overrideModuleClass(beanDefinition.getBeanClassName());
        if (beanClassName != null) {
            beanDefinition.setBeanClassName(beanClassName);
        }
        if (this.overrideModuleRole(beanName)) {
            beanDefinition.setScope("prototype");
            if (beanDefinition instanceof GenericBeanDefinition) {
                ((GenericBeanDefinition)beanDefinition).setAbstract(true);
            }
        }
        this.m_moduleContext.registerBeanDefinition(beanName, beanDefinition);
    }

    protected void registerBeanDefinitions() throws ServerInitializationException {
    }

    protected static ScannedGenericBeanDefinition getScannedBeanDefinition(String className) throws IOException {
        MetadataReader reader = s_readerFactory.getMetadataReader(className);
        ScannedGenericBeanDefinition beanDefinition = new ScannedGenericBeanDefinition(reader);
        return beanDefinition;
    }

    protected static GenericBeanDefinition createModuleBeanDefinition(String className, Map<String, String> params, String role) throws IOException {
        ScannedGenericBeanDefinition result = Server.getScannedBeanDefinition(className);
        result.setParentName(Module.class.getName());
        result.setScope("singleton");
        result.setAttribute("id", (Object)role);
        result.setAttribute("name", (Object)role);
        result.setAttribute("init-method", (Object)"initModule");
        result.setEnforceInitMethod(true);
        result.setAttribute("destroy-method", (Object)"shutdownModule");
        result.setEnforceDestroyMethod(true);
        ConstructorArgumentValues cArgs = new ConstructorArgumentValues();
        cArgs.addIndexedArgumentValue(0, params, MODULE_CONSTRUCTOR_PARAM1_CLASS);
        RuntimeBeanReference serverRef = new RuntimeBeanReference(MODULE_CONSTRUCTOR_PARAM2_CLASS);
        cArgs.addIndexedArgumentValue(1, (Object)serverRef);
        cArgs.addIndexedArgumentValue(2, (Object)role, MODULE_CONSTRUCTOR_PARAM3_CLASS);
        result.setConstructorArgumentValues(cArgs);
        return result;
    }

    protected static GenericBeanDefinition createModuleConfigurationBeanDefinition(String role) {
        GenericBeanDefinition result = new GenericBeanDefinition();
        result.setScope("singleton");
        result.setBeanClassName(ModuleConfiguration.class.getName());
        String name = role + "Configuration";
        result.setAttribute("id", (Object)name);
        result.setAttribute("name", (Object)name);
        result.setFactoryBeanName(ServerConfiguration.class.getName());
        result.setFactoryMethodName("getModuleConfiguration");
        ConstructorArgumentValues cArgs = new ConstructorArgumentValues();
        cArgs.addGenericArgumentValue((Object)role);
        result.setConstructorArgumentValues(cArgs);
        return result;
    }

    protected static GenericBeanDefinition createDatastoreConfigurationBeanDefinition(String id) {
        GenericBeanDefinition result = new GenericBeanDefinition();
        result.setScope("singleton");
        result.setBeanClassName(DatastoreConfiguration.class.getName());
        result.setAttribute("id", (Object)id);
        result.setAttribute("name", (Object)id);
        result.setFactoryBeanName(ServerConfiguration.class.getName());
        result.setFactoryMethodName("getDatastoreConfiguration");
        ConstructorArgumentValues cArgs = new ConstructorArgumentValues();
        cArgs.addGenericArgumentValue((Object)id);
        result.setConstructorArgumentValues(cArgs);
        return result;
    }

    protected static GenericBeanDefinition getTriplestoreConnectorBeanDefinition(DatastoreConfiguration tsDC) throws IOException {
        String tsConnector = tsDC.getParameter("connectorClassName", Parameter.class).getValue();
        ScannedGenericBeanDefinition beanDefinition = Server.getScannedBeanDefinition(tsConnector);
        beanDefinition.setAutowireCandidate(true);
        HashMap<String, String> tsTC = new HashMap<String, String>();
        for (Parameter p : tsDC.getParameters(Parameter.class)) {
            tsTC.put(p.getName(), p.getValue(p.getIsFilePath()));
        }
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.addPropertyValue("configuration", tsTC);
        beanDefinition.setPropertyValues(propertyValues);
        return beanDefinition;
    }

    private void loadSpringModules() {
        File springDir = new File(this.m_serverDir + File.separator + CONFIG_DIR + File.separator + SPRING_DIR);
        if (springDir.exists() && springDir.isDirectory()) {
            XmlBeanDefinitionReader beanReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this);
            for (String path : springDir.list()) {
                if (!path.endsWith(".xml")) continue;
                File springConfig = new File(springDir, path);
                logger.info("loading spring beans from " + springConfig.getAbsolutePath());
                FileSystemResource beanConfig = new FileSystemResource(springConfig);
                int count = beanReader.loadBeanDefinitions((Resource)beanConfig);
                if (count >= 1) continue;
                logger.warn("Loaded " + Integer.toString(count) + " beans from " + springConfig.getAbsolutePath());
            }
        }
    }

    public Object getBean(String name) throws BeansException {
        return this.m_moduleContext.getBean(name);
    }

    public boolean containsBean(String name) throws BeansException {
        return this.m_moduleContext.containsBean(name);
    }

    public final Module getModule(String role) {
        if (this.m_moduleContext.containsBean(role)) {
            try {
                return (Module)this.m_moduleContext.getBean(role, Module.class);
            }
            catch (Throwable e) {
                logger.warn(e.toString());
            }
        }
        return null;
    }

    protected boolean overrideModuleRole(String moduleRole) {
        return false;
    }

    protected String overrideModuleClass(String moduleClass) {
        return null;
    }

    private static final Map<String, String> loadParameters(Element element, String dAttribute) throws ServerInitializationException {
        HashMap<String, String> params = new HashMap<String, String>();
        logger.debug(MessageFormat.format(INIT_CONFIG_CONFIG_EXAMININGELEMENT, element.getLocalName(), dAttribute));
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node n = element.getChildNodes().item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getLocalName().equals(CONFIG_ELEMENT_PARAM)) {
                NamedNodeMap attrs = n.getAttributes();
                Node nameNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_NAME);
                if (nameNode == null) {
                    nameNode = attrs.getNamedItem(CONFIG_ATTRIBUTE_NAME);
                }
                Node valueNode = null;
                if (s_serverProfile != null && (valueNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, s_serverProfile + "value")) == null) {
                    valueNode = attrs.getNamedItem(s_serverProfile + "value");
                }
                if (valueNode == null) {
                    valueNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_VALUE);
                    if (valueNode == null) {
                        valueNode = attrs.getNamedItem(CONFIG_ATTRIBUTE_VALUE);
                    }
                    if (nameNode == null || valueNode == null) {
                        throw new ServerInitializationException(INIT_CONFIG_SEVERE_INCOMPLETEPARAM);
                    }
                }
                if (nameNode.getNodeValue().equals("") || valueNode.getNodeValue().equals("")) {
                    throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_INCOMPLETEPARAM, CONFIG_ELEMENT_PARAM, CONFIG_ATTRIBUTE_NAME, CONFIG_ATTRIBUTE_VALUE));
                }
                if (params.get(nameNode.getNodeValue()) != null) {
                    throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_REASSIGNMENT, CONFIG_ELEMENT_PARAM, CONFIG_ATTRIBUTE_NAME, nameNode.getNodeValue()));
                }
                params.put(nameNode.getNodeValue(), valueNode.getNodeValue());
                logger.debug(MessageFormat.format(INIT_CONFIG_CONFIG_PARAMETERIS, nameNode.getNodeValue(), valueNode.getNodeValue()));
                continue;
            }
            if (n.getLocalName().equals(CONFIG_ELEMENT_COMMENT)) continue;
        }
        params.remove(null);
        return params;
    }

    public final boolean hasInitialized() {
        return this.m_initialized;
    }

    public ServerStatusFile getStatusFile() {
        return this.m_statusFile;
    }

    public static final boolean hasInstance(File homeDir) {
        return s_instances.get(homeDir) != null;
    }

    public final String status(Context context) throws AuthzException {
        this.getBean("org.fcrepo.server.security.Authorization", Authorization.class).enforceServerStatus(context);
        return "RUNNING";
    }

    public static final Server getInstance(File homeDir, boolean okToStart) throws ServerInitializationException, ModuleInitializationException {
        if (okToStart) {
            return Server.getInstance(homeDir);
        }
        Server instance = s_instances.get(homeDir);
        if (instance == null) {
            throw new ServerInitializationException("The Fedora server is not yet running.");
        }
        return instance;
    }

    public static final Element getConfigElement(File homeDir) throws ServerInitializationException {
        File configFile = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            configFile = new File(homeDir + File.separator + "server" + File.separator + CONFIG_DIR + File.separator + CONFIG_FILE);
            Element rootElement = builder.parse(configFile).getDocumentElement();
            if (!rootElement.getLocalName().equals(CONFIG_ELEMENT_ROOT)) {
                throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_BADROOTELEMENT, configFile, CONFIG_ELEMENT_ROOT, rootElement.getLocalName()));
            }
            if (!rootElement.getNamespaceURI().equals(CONFIG_NAMESPACE)) {
                throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_BADNAMESPACE, configFile, CONFIG_NAMESPACE));
            }
            return rootElement;
        }
        catch (IOException ioe) {
            throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_UNREADABLE, configFile, ioe.getMessage()));
        }
        catch (ParserConfigurationException pce) {
            throw new ServerInitializationException(INIT_XMLPARSER_SEVERE_MISSING);
        }
        catch (SAXException saxe) {
            throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_MALFORMEDXML, configFile, saxe.getMessage()));
        }
    }

    public static final synchronized Server getInstance(File homeDir) throws ServerInitializationException, ModuleInitializationException {
        Server instance = s_instances.get(homeDir);
        if (instance != null) {
            return instance;
        }
        logger.info("Starting up server");
        Object configFile = null;
        try {
            Element rootElement = Server.getConfigElement(homeDir);
            String className = rootElement.getAttribute(CONFIG_ATTRIBUTE_CLASS);
            if (className.equals("") && (className = rootElement.getAttributeNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_CLASS)).equals("")) {
                className = DEFAULT_SERVER_CLASS;
            }
            try {
                Class<?> serverClass = Class.forName(className);
                Class<?> param1Class = Class.forName(SERVER_CONSTRUCTOR_PARAM1_CLASS);
                Class<?> param2Class = Class.forName(SERVER_CONSTRUCTOR_PARAM2_CLASS);
                Constructor<?> serverConstructor = serverClass.getConstructor(param1Class, param2Class);
                Server inst = (Server)serverConstructor.newInstance(rootElement, homeDir);
                inst.init();
                return inst;
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_CLASSNOTFOUND, className));
            }
            catch (IllegalAccessException iae) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_ILLEGALACCESS, className));
            }
            catch (IllegalArgumentException iae) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_BADARGS, className));
            }
            catch (InstantiationException ie) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_MISSINGCONSTRUCTOR, className));
            }
            catch (NoSuchMethodException nsme) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_ISABSTRACT, className));
            }
            catch (InvocationTargetException ite) {
                try {
                    throw ite.getCause();
                }
                catch (ServerInitializationException sie) {
                    throw sie;
                }
                catch (ModuleInitializationException mie) {
                    throw mie;
                }
                catch (Throwable t) {
                    StringBuffer s = new StringBuffer();
                    s.append(t.getClass().getName());
                    s.append(": ");
                    for (int i = 0; i < t.getStackTrace().length; ++i) {
                        s.append(t.getStackTrace()[i] + "\n");
                    }
                    throw new ServerInitializationException(s.toString());
                }
            }
        }
        catch (FactoryConfigurationError fce) {
            throw new ServerInitializationException(INIT_XMLPARSER_SEVERE_MISSING);
        }
        catch (IllegalArgumentException iae) {
            throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_UNREADABLE, configFile, iae.getMessage()));
        }
    }

    public final File getHomeDir() {
        return this.m_serverDir;
    }

    public final File getUploadDir() {
        return this.m_uploadDir;
    }

    public final DatastoreConfig getDatastoreConfig(String id) {
        try {
            return (DatastoreConfig)this.m_moduleContext.getBean(id, DatastoreConfiguration.class);
        }
        catch (Throwable t) {
            logger.info(t.getMessage(), t);
            return null;
        }
    }

    public Iterator<String> datastoreConfigIds() {
        String[] dsNames = this.m_moduleContext.getBeanNamesForType(DatastoreConfiguration.class, false, true);
        return Arrays.asList(dsNames).iterator();
    }

    public final Iterator<String> loadedModuleRoles() {
        String[] names = this.m_moduleContext.getBeanNamesForType(Module.class, false, true);
        return Arrays.asList(names).iterator();
    }

    protected void initServer() throws ServerInitializationException {
    }

    protected void postInitServer() throws ServerInitializationException {
    }

    public final void shutdown(Context context) throws ServerShutdownException, ModuleShutdownException, AuthzException {
        logger.info("Shutting down server");
        Throwable mse = null;
        try {
            this.m_moduleContext.close();
            this.m_moduleContext.destroy();
        }
        catch (Throwable e) {
            logger.error("Shutdown error: " + e.toString(), e);
            mse = e;
        }
        this.shutdownServer();
        logger.info("Server shutdown complete");
        s_instances.remove(this.getHomeDir());
        if (mse != null) {
            throw new ServerShutdownException(mse.toString());
        }
    }

    protected void shutdownServer() throws ServerShutdownException {
    }

    public final void finalize() throws ServerShutdownException, ModuleShutdownException {
        this.shutdownServer();
    }

    public static final Locale getLocale() {
        if (s_locale == null) {
            String language = System.getProperty("locale.language");
            String country = System.getProperty("locale.country");
            String variant = System.getProperty("locale.variant");
            s_locale = language != null && country != null ? (variant != null ? new Locale(language, country, variant) : new Locale(language, country)) : Locale.getDefault();
        }
        return s_locale;
    }

    public String getConfigSummary() {
        int i;
        StringBuffer out = new StringBuffer();
        out.append("[ Fedora Server Configuration Summary ]\n\n");
        out.append("Server class     : " + this.getClass().getName() + "\n");
        out.append("Required modules : ");
        String padding = "                   ";
        String[] roles = this.getRequiredModuleRoles();
        if (roles.length == 0) {
            out.append("<none>\n");
        } else {
            for (i = 0; i < roles.length; ++i) {
                if (i > 0) {
                    out.append(padding);
                }
                out.append(roles[i] + "\n");
            }
        }
        out.append("Parameters       : ");
        Iterator<String> iter = this.parameterNames();
        i = 0;
        while (iter.hasNext()) {
            String name = iter.next();
            String value = this.getParameter(name);
            if (i > 0) {
                out.append(padding);
            }
            out.append(name + "=" + value + "\n");
            ++i;
        }
        if (i == 0) {
            out.append("<none>\n");
        }
        iter = this.loadedModuleRoles();
        while (iter.hasNext()) {
            String role = iter.next();
            out.append("\nLoaded Module : " + role + "\n");
            Module module = this.getModule(role);
            out.append("Class         : " + module.getClass().getName() + "\n");
            out.append("Dependencies  : " + module.getRequiredModuleRoles().length + "\n");
            for (i = 0; i < module.getRequiredModuleRoles().length; ++i) {
                out.append("Dependency    : " + module.getRequiredModuleRoles()[i] + "\n");
            }
            out.append("Parameters    : ");
            padding = "                ";
            i = 0;
            Iterator<String> iter2 = module.parameterNames();
            while (iter2.hasNext()) {
                String name = iter2.next();
                String value = module.getParameter(name);
                if (i > 0) {
                    out.append(padding);
                }
                out.append(name + "=" + value + "\n");
                ++i;
            }
            if (i != 0) continue;
            out.append("<none>\n");
        }
        iter = this.datastoreConfigIds();
        while (iter.hasNext()) {
            String id = iter.next();
            out.append("\nDatastore Cfg : " + id + "\n");
            out.append("Parameters    : ");
            padding = "                ";
            i = 0;
            Iterator<String> iter2 = this.getDatastoreConfig(id).parameterNames();
            while (iter2.hasNext()) {
                String name = iter2.next();
                String value = this.getDatastoreConfig(id).getParameter(name);
                if (i > 0) {
                    out.append(padding);
                }
                out.append(name + "=" + value + "\n");
                ++i;
            }
            if (i != 0) continue;
            out.append("<none>\n");
        }
        return out.toString();
    }

    public static PID getPID(String pidString) throws MalformedPidException {
        try {
            return new PID(pidString);
        }
        catch (MalformedPIDException e) {
            throw new MalformedPidException(e.getMessage());
        }
    }

    public static PID pidFromFilename(String filename) throws MalformedPidException {
        try {
            return PID.fromFilename((String)filename);
        }
        catch (MalformedPIDException e) {
            throw new MalformedPidException(e.getMessage());
        }
    }

    public static Date getCurrentDate(Context context) throws GeneralException {
        String propName = Constants.ENVIRONMENT.CURRENT_DATE_TIME.uri;
        String dateTimeValue = context.getEnvironmentValue(propName);
        if (dateTimeValue == null) {
            throw new GeneralException("Missing value for environment context attribute: " + propName);
        }
        try {
            return DateUtility.parseDateStrict((String)dateTimeValue);
        }
        catch (ParseException e) {
            throw new GeneralException(e.getMessage());
        }
    }

    public static ServerConfiguration getConfig() {
        try {
            FileInputStream fcfg = new FileInputStream(new File(Constants.FEDORA_HOME, "server/config/fedora.fcfg"));
            ServerConfigurationParser parser = new ServerConfigurationParser(fcfg);
            return parser.parse();
        }
        catch (IOException e) {
            throw new FaultException("Error loading server configuration", (Throwable)e);
        }
    }

    private void initWebClientConfig() {
        this.m_webClientConfig = new WebClientConfiguration();
        if (this.getParameter("httpClientTimeoutSecs") != null) {
            this.m_webClientConfig.setTimeoutSecs(Integer.parseInt(this.getParameter("httpClientTimeoutSecs")));
        }
        if (this.getParameter("httpClientSocketTimeoutSecs") != null) {
            this.m_webClientConfig.setSockTimeoutSecs(Integer.parseInt(this.getParameter("httpClientSocketTimeoutSecs")));
        }
        if (this.getParameter("httpClientMaxConnectionsPerHost") != null) {
            this.m_webClientConfig.setMaxConnPerHost(Integer.parseInt(this.getParameter("httpClientMaxConnectionsPerHost")));
        }
        if (this.getParameter("httpClientMaxTotalConnections") != null) {
            this.m_webClientConfig.setMaxTotalConn(Integer.parseInt(this.getParameter("httpClientMaxTotalConnections")));
        }
        if (this.getParameter("httpClientFollowRedirects") != null) {
            this.m_webClientConfig.setFollowRedirects(Boolean.parseBoolean(this.getParameter("httpClientFollowRedirects")));
        }
        if (this.getParameter("httpClientMaxFollowRedirects") != null) {
            this.m_webClientConfig.setMaxRedirects(Integer.parseInt(this.getParameter("httpClientMaxFollowRedirects")));
        }
        if (this.getParameter("httpClientUserAgent") != null) {
            this.m_webClientConfig.setUserAgent(this.getParameter("httpClientUserAgent"));
        }
    }

    public WebClientConfiguration getWebClientConfig() {
        return this.m_webClientConfig;
    }

    protected boolean knownBeanDefinition(String beanName) {
        return this.m_moduleContext.containsBeanDefinition(beanName) || this.m_moduleContext.getParent().containsBeanDefinition(beanName);
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.m_moduleContext.containsBeanDefinition(beanName);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        return this.m_moduleContext.getBeanDefinition(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.m_moduleContext.getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.m_moduleContext.getBeanDefinitionNames();
    }

    public boolean isBeanNameInUse(String beanName) {
        return this.m_moduleContext.isBeanNameInUse(beanName);
    }

    public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        this.m_moduleContext.removeBeanDefinition(beanName);
    }

    public String[] getAliases(String name) {
        return this.m_moduleContext.getAliases(name);
    }

    public boolean isAlias(String beanName) {
        return this.m_moduleContext.isAlias(beanName);
    }

    public void registerAlias(String beanName, String alias) {
        this.m_moduleContext.registerAlias(beanName, alias);
    }

    public void removeAlias(String alias) {
        this.m_moduleContext.removeAlias(alias);
    }

    public String[] getBeanNamesForType(Class type) {
        return this.m_moduleContext.getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.m_moduleContext.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.m_moduleContext.getBeansOfType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.m_moduleContext.getBeansOfType(type, includeNonSingletons, allowEagerInit);
    }

    public <T> T getBean(String name, Class<T> type) throws BeansException {
        return (T)this.m_moduleContext.getBean(name, type);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)this.m_moduleContext.getBean(requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.m_moduleContext.getBean(name, args);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.m_moduleContext.getType(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.m_moduleContext.isPrototype(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.m_moduleContext.isSingleton(name);
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        return this.m_moduleContext.isTypeMatch(name, targetType);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        return this.m_moduleContext.getBeansWithAnnotation(annotationType);
    }

    public <T extends Annotation> T findAnnotationOnBean(String beanName, Class<T> annotationType) {
        return (T)this.m_moduleContext.findAnnotationOnBean(beanName, annotationType);
    }

    static {
        s_instances = new HashMap<File, Server>();
        s_serverProfile = System.getProperty("fedora.serverProfile");
    }
}

