/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Server;
import org.fcrepo.server.utilities.status.ServerState;
import org.fcrepo.server.utilities.status.ServerStatusFile;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class SpringServlet
extends HttpServlet {
    protected ApplicationContext m_appContext;
    protected Server m_server;
    protected ServerStatusFile m_status;

    protected void failStartup(String message, Throwable th) throws ServletException {
        System.err.println("\n**************************");
        System.err.println("** FEDORA STARTUP ERROR **");
        System.err.println("**************************\n");
        System.err.println(message);
        if (th == null) {
            System.err.println();
            throw new ServletException(message);
        }
        th.printStackTrace();
        System.err.println();
        throw new ServletException(message, th);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        File fedoraHomeDir = this.getFedoraHomeDir();
        try {
            this.m_status = new ServerStatusFile(new File(fedoraHomeDir, "server"));
        }
        catch (Throwable th) {
            this.failStartup("Error initializing server status file", th);
        }
        try {
            this.m_appContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)config.getServletContext());
            this.m_server = (Server)this.m_appContext.getBean("org.fcrepo.server.Server");
            if (this.m_server == null) {
                this.failStartup("Could not retrieve org.fcrepo.server.Server bean", null);
            }
        }
        catch (Throwable th) {
            String msg = "Fedora startup failed";
            try {
                this.m_status.appendError(ServerState.STARTUP_FAILED, th);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.failStartup(msg, th);
        }
    }

    public void destroy() {
        this.m_appContext = null;
        this.m_status = null;
    }

    private File getFedoraHomeDir() throws ServletException {
        File fedoraHomeDir;
        String fedoraHome = Constants.FEDORA_HOME;
        if (fedoraHome == null) {
            this.failStartup("FEDORA_HOME was not configured properly.  It must be set via the fedora.home servlet init-param (preferred), the fedora.home system property, or the FEDORA_HOME environment variable.", null);
        }
        if (!(fedoraHomeDir = new File(fedoraHome)).isDirectory()) {
            this.failStartup("The FEDORA_HOME directory, " + fedoraHomeDir.getPath() + " does not exist", null);
        }
        File writeTest = new File(fedoraHomeDir, "writeTest.tmp");
        String writeErrorMessage = "The FEDORA_HOME directory, " + fedoraHomeDir.getPath() + " is not writable by " + "the current user, " + System.getProperty("user.name");
        try {
            writeTest.createNewFile();
            if (!writeTest.exists()) {
                throw new IOException("");
            }
            writeTest.delete();
        }
        catch (IOException e) {
            this.failStartup(writeErrorMessage, null);
        }
        return fedoraHomeDir;
    }
}

