/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.access.RepositoryInfo;
import org.fcrepo.server.access.SpringAccessServlet;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribeRepositoryServlet
extends SpringAccessServlet
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(DescribeRepositoryServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final String CONTENT_TYPE_XML = "text/xml; charset=UTF-8";
    String ACTION_LABEL = "describe repository";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean xml = false;
        logger.debug("Got request: " + request.getRequestURL().toString() + "?" + request.getQueryString());
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = URLDecoder.decode((String)e.nextElement(), "UTF-8");
            if (!name.equalsIgnoreCase("xml")) continue;
            xml = new Boolean(request.getParameter(name));
        }
        ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, request);
        try {
            this.describeRepository(context, xml, response);
        }
        catch (AuthzException ae) {
            throw RootException.getServletException(ae, request, this.ACTION_LABEL, new String[0]);
        }
        catch (Throwable th) {
            throw new InternalError500Exception("", th, request, this.ACTION_LABEL, "", new String[0]);
        }
    }

    public void describeRepository(Context context, boolean xml, HttpServletResponse response) throws ServerException {
        OutputStreamWriter out = null;
        RepositoryInfo repositoryInfo = null;
        PipedWriter pw = null;
        PipedReader pr = null;
        try {
            pw = new PipedWriter();
            pr = new PipedReader(pw);
            repositoryInfo = this.m_access.describeRepository(context);
            if (repositoryInfo != null) {
                new ReposInfoSerializerThread(context, repositoryInfo, pw).start();
                if (xml) {
                    response.setContentType(CONTENT_TYPE_XML);
                    out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                    int bufSize = 4096;
                    char[] buf = new char[bufSize];
                    int len = 0;
                    while ((len = pr.read(buf, 0, bufSize)) != -1) {
                        out.write(buf, 0, len);
                    }
                    out.flush();
                } else {
                    response.setContentType(CONTENT_TYPE_HTML);
                    out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                    File xslFile = new File(this.m_server.getHomeDir(), "access/viewRepositoryInfo.xslt");
                    TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
                    Templates template = factory.newTemplates(new StreamSource(xslFile));
                    Transformer transformer = template.newTransformer();
                    transformer.setParameter("fedora", context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
                    transformer.transform(new StreamSource(pr), new StreamResult(out));
                }
                out.flush();
            } else {
                logger.error("No repository info returned");
            }
        }
        catch (AuthzException ae) {
            throw ae;
        }
        catch (Throwable th) {
            String msg = "Error describing repository";
            logger.error(msg, th);
            throw new GeneralException(msg, th);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable th) {
                String message = "[DescribeRepositoryServlet] An error has occured.  The error was a \" " + th.getClass().getName() + " \". Reason: " + th.getMessage();
                throw new StreamIOException(message);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public class ReposInfoSerializerThread
    extends Thread {
        private PipedWriter pw = null;
        private RepositoryInfo repositoryInfo = null;

        public ReposInfoSerializerThread(Context context, RepositoryInfo repositoryInfo, PipedWriter pw) {
            this.pw = pw;
            this.repositoryInfo = repositoryInfo;
            if (Constants.HTTP_REQUEST.SECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri)) || Constants.HTTP_REQUEST.INSECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri))) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.pw != null) {
                try {
                    String[] emails;
                    String[] retainPIDs;
                    this.pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    this.pw.write("<fedoraRepository xmlns=\"" + Constants.REPO_DESC1_0.namespace.uri + "\"" + " xmlns:xsd=\"" + Constants.XML_XSD.uri + "\"" + " xmlns:xsi=\"" + Constants.XSI.uri + "\"" + " xsi:schemaLocation=\"" + Constants.ACCESS.uri + " " + Constants.REPO_DESC1_0.xsdLocation + "\">");
                    this.pw.write("<repositoryName>" + this.repositoryInfo.repositoryName + "</repositoryName>");
                    this.pw.write("<repositoryBaseURL>" + this.repositoryInfo.repositoryBaseURL + "</repositoryBaseURL>");
                    this.pw.write("<repositoryVersion>" + this.repositoryInfo.repositoryVersion + "</repositoryVersion>");
                    this.pw.write("<repositoryPID>");
                    this.pw.write("    <PID-namespaceIdentifier>" + this.repositoryInfo.repositoryPIDNamespace + "</PID-namespaceIdentifier>");
                    this.pw.write("    <PID-delimiter>:</PID-delimiter>");
                    this.pw.write("    <PID-sample>" + this.repositoryInfo.samplePID + "</PID-sample>");
                    for (String element : retainPIDs = this.repositoryInfo.retainPIDs) {
                        this.pw.write("    <retainPID>" + element + "</retainPID>");
                    }
                    this.pw.write("</repositoryPID>");
                    this.pw.write("<repositoryOAI-identifier>");
                    this.pw.write("    <OAI-namespaceIdentifier>" + this.repositoryInfo.OAINamespace + "</OAI-namespaceIdentifier>");
                    this.pw.write("    <OAI-delimiter>:</OAI-delimiter>");
                    this.pw.write("    <OAI-sample>" + this.repositoryInfo.sampleOAIIdentifer + "</OAI-sample>");
                    this.pw.write("</repositoryOAI-identifier>");
                    this.pw.write("<sampleSearch-URL>" + this.repositoryInfo.sampleSearchURL + "</sampleSearch-URL>");
                    this.pw.write("<sampleAccess-URL>" + this.repositoryInfo.sampleAccessURL + "</sampleAccess-URL>");
                    this.pw.write("<sampleOAI-URL>" + this.repositoryInfo.sampleOAIURL + "</sampleOAI-URL>");
                    for (String element : emails = this.repositoryInfo.adminEmailList) {
                        this.pw.write("<adminEmail>" + element + "</adminEmail>");
                    }
                    this.pw.write("</fedoraRepository>");
                    this.pw.flush();
                    this.pw.close();
                }
                catch (IOException ioe) {
                    logger.error("WriteThread IOException", (Throwable)ioe);
                }
                finally {
                    try {
                        if (this.pw != null) {
                            this.pw.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.error("WriteThread IOException", (Throwable)ioe);
                    }
                }
            }
        }
    }
}

