/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.fcrepo.server.Context;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.Access;
import org.fcrepo.server.access.DynamicAccessImpl;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.access.RepositoryInfo;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.types.DatastreamDef;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.MethodDef;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.server.storage.types.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAccessModule
extends Module
implements Access {
    private static final Logger logger = LoggerFactory.getLogger(DynamicAccessModule.class);
    private DynamicAccessImpl da = null;
    private DOManager m_manager;
    private Access m_access;
    private Hashtable dynamicServiceToDeployment = null;
    private File reposHomeDir = null;

    public DynamicAccessModule(Map moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        this.m_manager = (DOManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.DOManager"));
        if (this.m_manager == null) {
            throw new ModuleInitializationException("[DynamicAccessModule] Can't get a DOManager from Server.getModule", this.getRole());
        }
        this.m_access = (Access)((Object)this.getServer().getModule("org.fcrepo.server.access.Access"));
        if (this.m_access == null) {
            throw new ModuleInitializationException("[DynamicAccessModule] Can't get a ref to Access from Server.getModule", this.getRole());
        }
        InetAddress hostIP = null;
        try {
            hostIP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            logger.error("Unable to resolve Fedora host", (Throwable)uhe);
        }
        String fedoraServerHost = this.getServer().getParameter("fedoraServerHost");
        if (fedoraServerHost == null || fedoraServerHost.equals("")) {
            fedoraServerHost = hostIP.getHostName();
        }
        this.reposHomeDir = this.getServer().getHomeDir();
        this.dynamicServiceToDeployment = new Hashtable();
        try {
            this.dynamicServiceToDeployment.put("fedora-system:3", Class.forName(this.getParameter("fedora-system:4")));
        }
        catch (Exception e) {
            throw new ModuleInitializationException(e.getMessage(), "org.fcrepo.server.validation.DOValidatorModule");
        }
        this.da = new DynamicAccessImpl(this.m_access, this.reposHomeDir, this.dynamicServiceToDeployment);
    }

    public String[] getServiceDefinitions(Context context, String PID2, Date asOfDateTime) throws ServerException {
        return this.da.getServiceDefinitions(context, PID2, asOfDateTime);
    }

    public MethodDef[] getMethods(Context context, String PID2, String sDefPID, Date asOfDateTime) throws ServerException {
        return this.da.getMethods(context, PID2, sDefPID, asOfDateTime);
    }

    public MIMETypedStream getMethodsXML(Context context, String PID2, String sDefPID, Date asOfDateTime) throws ServerException {
        return this.da.getMethodsXML(context, PID2, sDefPID, asOfDateTime);
    }

    @Override
    public MIMETypedStream getDatastreamDissemination(Context context, String PID2, String dsID, Date asOfDateTime) throws ServerException {
        return this.da.getDatastreamDissemination(context, PID2, dsID, asOfDateTime);
    }

    @Override
    public MIMETypedStream getDissemination(Context context, String PID2, String sDefPID, String methodName, Property[] userParms, Date asOfDateTime) throws ServerException {
        this.setParameter("useCachedObject", "false");
        return this.da.getDissemination(context, PID2, sDefPID, methodName, userParms, asOfDateTime, this.m_manager.getReader(false, context, PID2));
    }

    @Override
    public ObjectMethodsDef[] listMethods(Context context, String PID2, Date asOfDateTime) throws ServerException {
        return this.da.listMethods(context, PID2, asOfDateTime);
    }

    @Override
    public ObjectProfile getObjectProfile(Context context, String PID2, Date asOfDateTime) throws ServerException {
        return null;
    }

    @Override
    public FieldSearchResult findObjects(Context context, String[] resultFields, int maxResults, FieldSearchQuery query) throws ServerException {
        return null;
    }

    @Override
    public FieldSearchResult resumeFindObjects(Context context, String sessionToken) throws ServerException {
        return null;
    }

    @Override
    public RepositoryInfo describeRepository(Context context) throws ServerException {
        return null;
    }

    @Override
    public String[] getObjectHistory(Context context, String PID2) throws ServerException {
        return this.da.getObjectHistory(context, PID2);
    }

    protected boolean isDynamicService(Context context, String PID2, String sDefPID) throws ServerException {
        return this.da.isDynamicDeployment(context, PID2, sDefPID);
    }

    @Override
    public DatastreamDef[] listDatastreams(Context context, String PID2, Date asOfDateTime) throws ServerException {
        return this.da.listDatastreams(context, PID2, asOfDateTime);
    }
}

