/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.binding.soap.SoapFault;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.Access;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.access.RepositoryInfo;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.storage.types.Property;
import org.fcrepo.server.types.gen.ArrayOfString;
import org.fcrepo.server.types.gen.DatastreamDef;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.ObjectMethodsDef;
import org.fcrepo.server.types.mtom.gen.GetDissemination;
import org.fcrepo.server.types.mtom.gen.MIMETypedStream;
import org.fcrepo.server.utilities.CXFUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraAPIAMTOMImpl
implements FedoraAPIAMTOM {
    private static final Logger LOG = LoggerFactory.getLogger(FedoraAPIAMTOMImpl.class);
    @Resource
    private WebServiceContext context;
    private final Server m_server;
    private final Access m_access;
    private boolean debug = false;

    public FedoraAPIAMTOMImpl(Server server) {
        this.m_server = server;
        this.m_access = (Access)((Object)this.m_server.getModule("org.fcrepo.server.access.Access"));
        Boolean debugBool = new Boolean(this.m_server.getParameter("debug"));
        this.debug = debugBool;
    }

    public MIMETypedStream getDatastreamDissemination(String pid, String dsID, String asOfDateTime) {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            org.fcrepo.server.storage.types.MIMETypedStream mimeTypedStream = this.m_access.getDatastreamDissemination(context, pid, dsID, DateUtility.parseDateOrNull((String)asOfDateTime));
            MIMETypedStream genMIMETypedStream = TypeUtility.convertMIMETypedStreamToGenMIMETypedStreamMTOM(mimeTypedStream);
            return genMIMETypedStream;
        }
        catch (OutOfMemoryError oome) {
            LOG.error("Out of memory error getting " + dsID + " datastream dissemination for " + pid);
            String exceptionText = "The datastream you are attempting to retrieve is too large to transfer via getDatastreamDissemination (as determined by the server memory allocation.) Consider retrieving this datastream via REST at: ";
            String restURL = this.describeRepository().getRepositoryBaseURL() + "/get/" + pid + "/" + dsID;
            throw CXFUtility.getFault(new Exception(exceptionText + restURL));
        }
        catch (Throwable th) {
            LOG.error("Error getting datastream dissemination", th);
            throw CXFUtility.getFault(th);
        }
    }

    public MIMETypedStream getDissemination(String pid, String serviceDefinitionPid, String methodName, GetDissemination.Parameters parameters, String asOfDateTime) {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            Property[] properties = TypeUtility.convertGenPropertyArrayToPropertyArray(parameters);
            org.fcrepo.server.storage.types.MIMETypedStream mimeTypedStream = this.m_access.getDissemination(context, pid, serviceDefinitionPid, methodName, properties, DateUtility.parseDateOrNull((String)asOfDateTime));
            MIMETypedStream genMIMETypedStream = TypeUtility.convertMIMETypedStreamToGenMIMETypedStreamMTOM(mimeTypedStream);
            return genMIMETypedStream;
        }
        catch (Throwable th) {
            LOG.error("Error getting dissemination", th);
            throw CXFUtility.getFault(th);
        }
    }

    public org.fcrepo.server.types.gen.ObjectProfile getObjectProfile(String pid, String asOfDateTime) {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            ObjectProfile objectProfile = this.m_access.getObjectProfile(context, pid, DateUtility.parseDateOrNull((String)asOfDateTime));
            org.fcrepo.server.types.gen.ObjectProfile genObjectProfile = TypeUtility.convertObjectProfileToGenObjectProfile(objectProfile);
            return genObjectProfile;
        }
        catch (Throwable th) {
            LOG.error("Error getting object profile", th);
            throw CXFUtility.getFault(th);
        }
    }

    public org.fcrepo.server.types.gen.FieldSearchResult findObjects(ArrayOfString resultFields, BigInteger maxResults, FieldSearchQuery query) {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            String[] resultFieldsArray = null;
            if (resultFields != null && resultFields.getItem() != null) {
                resultFieldsArray = resultFields.getItem().toArray(new String[0]);
            }
            FieldSearchResult result = this.m_access.findObjects(context, resultFieldsArray, maxResults.intValue(), TypeUtility.convertGenFieldSearchQueryToFieldSearchQuery(query));
            return TypeUtility.convertFieldSearchResultToGenFieldSearchResult(result);
        }
        catch (Throwable th) {
            LOG.error("Error finding objects", th);
            throw CXFUtility.getFault(th);
        }
    }

    public List<String> getObjectHistory(String pid) {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            String[] sDefs = this.m_access.getObjectHistory(context, pid);
            if (sDefs != null && this.debug) {
                for (int i = 0; i < sDefs.length; ++i) {
                    LOG.debug("sDef[" + i + "] = " + sDefs[i]);
                }
            }
            return sDefs == null ? null : Arrays.asList(sDefs);
        }
        catch (Throwable th) {
            LOG.error("Error getting object history", th);
            throw CXFUtility.getFault(th);
        }
    }

    public org.fcrepo.server.types.gen.RepositoryInfo describeRepository() {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            RepositoryInfo repositoryInfo = this.m_access.describeRepository(context);
            org.fcrepo.server.types.gen.RepositoryInfo genRepositoryInfo = TypeUtility.convertReposInfoToGenReposInfo(repositoryInfo);
            return genRepositoryInfo;
        }
        catch (Throwable th) {
            LOG.error("Error describing repository", th);
            throw CXFUtility.getFault(th);
        }
    }

    public List<ObjectMethodsDef> listMethods(String pid, String asOfDateTime) {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            org.fcrepo.server.storage.types.ObjectMethodsDef[] objectMethodDefs = this.m_access.listMethods(context, pid, DateUtility.parseDateOrNull((String)asOfDateTime));
            return TypeUtility.convertObjectMethodsDefArrayToGenObjectMethodsDefList(objectMethodDefs);
        }
        catch (Throwable th) {
            LOG.error("Error listing methods", th);
            throw CXFUtility.getFault(th);
        }
    }

    public org.fcrepo.server.types.gen.FieldSearchResult resumeFindObjects(String sessionToken) {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            FieldSearchResult result = this.m_access.resumeFindObjects(context, sessionToken);
            return TypeUtility.convertFieldSearchResultToGenFieldSearchResult(result);
        }
        catch (Throwable th) {
            LOG.error("Error resuming finding objects", th);
            throw CXFUtility.getFault(th);
        }
    }

    public List<DatastreamDef> listDatastreams(String pid, String asOfDateTime) {
        MessageContext ctx = this.context.getMessageContext();
        Context context = ReadOnlyContext.getSoapContext(ctx);
        this.assertInitialized();
        try {
            org.fcrepo.server.storage.types.DatastreamDef[] datastreamDefs = this.m_access.listDatastreams(context, pid, DateUtility.parseDateOrNull((String)asOfDateTime));
            return TypeUtility.convertDatastreamDefArrayToGenDatastreamDefList(datastreamDefs);
        }
        catch (Throwable th) {
            LOG.error("Error listing datastreams", th);
            throw CXFUtility.getFault(th);
        }
    }

    private void assertInitialized() throws SoapFault {
        if (this.m_server == null) {
            CXFUtility.throwFault(new ModuleInitializationException("Null was injected for Server to WS implementor", "org.fcrepo.server.access.FedoraAPIAMTOM"));
        }
        if (this.m_access == null) {
            CXFUtility.throwFault(new ModuleInitializationException("No Access module found for WS implementor", "org.fcrepo.server.access.FedoraAPIAMTOM"));
        }
    }
}

