/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.access.SpringAccessServlet;
import org.fcrepo.server.errors.DatastreamNotFoundException;
import org.fcrepo.server.errors.DisseminationException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.MethodNotFoundException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.NotFound404Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.Property;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.utilities.DateUtility;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraAccessServlet
extends SpringAccessServlet
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(FedoraAccessServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final String CONTENT_TYPE_XML = "text/xml; charset=UTF-8";
    private String requestURI = null;
    private static final int BUF = 4096;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String PID2 = null;
        String sDefPID = null;
        String methodName = null;
        String dsID = null;
        Date asOfDateTime = null;
        Date versDateTime = null;
        Property[] userParms = null;
        boolean isGetObjectProfileRequest = false;
        boolean isGetDisseminationRequest = false;
        boolean isGetDatastreamDisseminationRequest = false;
        boolean xml = false;
        this.requestURI = request.getRequestURL().toString() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
        logger.info("Got request: " + this.requestURI);
        String[] URIArray = request.getRequestURL().toString().split("/");
        if (URIArray.length == 6 || URIArray.length == 7) {
            if (URIArray.length == 7) {
                if (URIArray[6].indexOf(":") == -1) {
                    dsID = URLDecoder.decode(URIArray[6], "UTF-8");
                    isGetDatastreamDisseminationRequest = true;
                } else {
                    try {
                        versDateTime = DateUtility.parseDateStrict((String)URIArray[6]);
                    }
                    catch (ParseException e) {
                        String message = "ObjectProfile Request Syntax Error: DateTime value of \"" + URIArray[6] + "\" is not a valid DateTime format. " + " <br></br> The expected format for DateTime is \"" + "YYYY-MM-DDTHH:MM:SS.SSSZ\".  " + " <br></br> The expected syntax for " + "ObjectProfile requests is: \"" + URIArray[0] + "//" + URIArray[2] + "/" + URIArray[3] + "/" + URIArray[4] + "/PID[/dateTime] \"  ." + " <br></br> Submitted request was: \"" + this.requestURI + "\"  .  ";
                        logger.warn(message);
                        throw new ServletException("from FedoraAccessServlet" + message);
                    }
                    asOfDateTime = versDateTime;
                    isGetObjectProfileRequest = true;
                }
            } else {
                isGetObjectProfileRequest = true;
            }
        } else if (URIArray.length > 7) {
            methodName = URLDecoder.decode(URIArray[7], "UTF-8");
            if (URIArray.length == 8) {
                if (URIArray[6].indexOf(":") == -1) {
                    dsID = URLDecoder.decode(URIArray[6], "UTF-8");
                    try {
                        versDateTime = DateUtility.parseDateStrict((String)URIArray[7]);
                    }
                    catch (ParseException e) {
                        String message = "GetDatastreamDissemination Request Syntax Error: DateTime value of \"" + URIArray[7] + "\" is not a valid DateTime format. " + " <br></br> The expected format for DateTime is \"" + "YYYY-MM-DDTHH:MM:SS.SSSZ\".  " + " <br></br> The expected syntax for GetDatastreamDissemination requests is: \"" + URIArray[0] + "//" + URIArray[2] + "/" + URIArray[3] + "/" + URIArray[4] + "/PID/dsID[/dateTime] \"  " + " <br></br> Submitted request was: \"" + this.requestURI + "\"  .  ";
                        logger.warn(message);
                        throw new ServletException("from FedoraAccessServlet" + message);
                    }
                    asOfDateTime = versDateTime;
                    isGetDatastreamDisseminationRequest = true;
                } else {
                    isGetDisseminationRequest = true;
                }
            } else if (URIArray.length == 9) {
                try {
                    versDateTime = DateUtility.parseDateStrict((String)URIArray[8]);
                }
                catch (ParseException e) {
                    String message = "Dissemination Request Syntax Error: DateTime value of \"" + URIArray[8] + "\" is not a valid DateTime format. " + " <br></br> The expected format for DateTime is \"" + "YYYY-MM-DDTHH:MM:SS.SSS\".  " + " <br></br> The expected syntax for Dissemination requests is: \"" + URIArray[0] + "//" + URIArray[2] + "/" + URIArray[3] + "/" + URIArray[4] + "/PID/sDefPID/methodName[/dateTime][?ParmArray] \"  " + " <br></br> Submitted request was: \"" + this.requestURI + "\"  .  ";
                    logger.warn(message);
                    throw new ServletException("from FedoraAccessServlet" + message);
                }
                asOfDateTime = versDateTime;
                isGetDisseminationRequest = true;
            }
            if (URIArray.length > 9) {
                String message = "Dissemination Request Syntax Error: The expected syntax for Dissemination requests is: \"" + URIArray[0] + "//" + URIArray[2] + "/" + URIArray[3] + "/" + URIArray[4] + "/PID/sDefPID/methodName[/dateTime][?ParmArray] \"  " + " <br></br> Submitted request was: \"" + this.requestURI + "\"  .  ";
                logger.warn(message);
                throw new ServletException("from FedoraAccessServlet" + message);
            }
        } else {
            response.sendRedirect("/userdocs/client/browser/apialite/index.html");
            return;
        }
        Hashtable<String, String> h_userParms = new Hashtable<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = URLDecoder.decode((String)e.nextElement(), "UTF-8");
            if (isGetObjectProfileRequest && name.equalsIgnoreCase("xml")) {
                xml = new Boolean(request.getParameter(name));
                continue;
            }
            String value = URLDecoder.decode(request.getParameter(name), "UTF-8");
            h_userParms.put(name, value);
        }
        int userParmCounter = 0;
        userParms = new Property[h_userParms.size()];
        Enumeration e2 = h_userParms.keys();
        while (e2.hasMoreElements()) {
            Property userParm = new Property();
            userParm.name = (String)e2.nextElement();
            userParm.value = (String)h_userParms.get(userParm.name);
            userParms[userParmCounter] = userParm;
            ++userParmCounter;
        }
        PID2 = URIArray[5];
        String actionLabel = "Access";
        try {
            ReadOnlyContext context;
            if (isGetObjectProfileRequest) {
                logger.debug("Servicing getObjectProfile request (PID=" + PID2 + ", asOfDate=" + versDateTime + ")");
                context = ReadOnlyContext.getContext(FedoraAccessServlet.HTTP_REQUEST.REST.uri, request);
                this.getObjectProfile(context, PID2, asOfDateTime, xml, request, response);
                logger.debug("Finished servicing getObjectProfile request");
            } else if (isGetDisseminationRequest) {
                sDefPID = URIArray[6];
                logger.debug("Servicing getDissemination request (PID=" + PID2 + ", sDefPID=" + sDefPID + ", methodName=" + methodName + ", asOfDate=" + versDateTime + ")");
                context = ReadOnlyContext.getContext(FedoraAccessServlet.HTTP_REQUEST.REST.uri, request);
                this.getDissemination(context, PID2, sDefPID, methodName, userParms, asOfDateTime, response, request);
                logger.debug("Finished servicing getDissemination request");
            } else if (isGetDatastreamDisseminationRequest) {
                logger.debug("Servicing getDatastreamDissemination request (PID=" + PID2 + ", dsID=" + dsID + ", asOfDate=" + versDateTime + ")");
                context = ReadOnlyContext.getContext(FedoraAccessServlet.HTTP_REQUEST.REST.uri, request);
                this.getDatastreamDissemination(context, PID2, dsID, asOfDateTime, response, request);
                logger.debug("Finished servicing getDatastreamDissemination request");
            }
        }
        catch (MethodNotFoundException e3) {
            logger.error("Method not found for request: " + this.requestURI + " (actionLabel=" + actionLabel + ")", (Throwable)e3);
            throw new NotFound404Exception("", e3, request, actionLabel, e3.getMessage(), new String[0]);
        }
        catch (DatastreamNotFoundException e4) {
            logger.error("Datastream not found for request: " + this.requestURI + " (actionLabel=" + actionLabel + ")", (Throwable)e4);
            throw new NotFound404Exception("", e4, request, actionLabel, e4.getMessage(), new String[0]);
        }
        catch (ObjectNotFoundException e5) {
            logger.error("Object not found for request: " + this.requestURI + " (actionLabel=" + actionLabel + ")", (Throwable)e5);
            throw new NotFound404Exception("", e5, request, actionLabel, e5.getMessage(), new String[0]);
        }
        catch (DisseminationException e6) {
            logger.error("Dissemination failed: " + this.requestURI + " (actionLabel=" + actionLabel + ")", (Throwable)e6);
            throw new NotFound404Exception("", e6, request, actionLabel, e6.getMessage(), new String[0]);
        }
        catch (ObjectNotInLowlevelStorageException e7) {
            logger.error("Object or datastream not found for request: " + this.requestURI + " (actionLabel=" + actionLabel + ")", (Throwable)e7);
            throw new NotFound404Exception("", e7, request, actionLabel, e7.getMessage(), new String[0]);
        }
        catch (AuthzException ae) {
            logger.error("Authorization failed for request: " + this.requestURI + " (actionLabel=" + actionLabel + ")", (Throwable)ae);
            throw RootException.getServletException(ae, request, actionLabel, new String[0]);
        }
        catch (Throwable th) {
            logger.error("Unexpected error servicing API-A request", th);
            throw new InternalError500Exception("", th, request, actionLabel, "", new String[0]);
        }
    }

    public void getObjectProfile(Context context, String PID2, Date asOfDateTime, boolean xml, HttpServletRequest request, HttpServletResponse response) throws ServerException {
        block16: {
            OutputStreamWriter out = null;
            Date versDateTime = asOfDateTime;
            ObjectProfile objProfile = null;
            PipedWriter pw = null;
            PipedReader pr = null;
            try {
                pw = new PipedWriter();
                pr = new PipedReader(pw);
                objProfile = this.m_access.getObjectProfile(context, PID2, asOfDateTime);
                if (objProfile != null) {
                    new ProfileSerializerThread(context, PID2, objProfile, versDateTime, pw).start();
                    if (xml) {
                        response.setContentType(CONTENT_TYPE_XML);
                        out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                        char[] buf = new char[4096];
                        int len = 0;
                        while ((len = pr.read(buf, 0, 4096)) != -1) {
                            out.write(buf, 0, len);
                        }
                        out.flush();
                    } else {
                        response.setContentType(CONTENT_TYPE_HTML);
                        out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                        File xslFile = new File(this.m_server.getHomeDir(), "access/viewObjectProfile.xslt");
                        TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
                        Templates template = factory.newTemplates(new StreamSource(xslFile));
                        Transformer transformer = template.newTransformer();
                        transformer.setParameter("fedora", context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
                        transformer.transform(new StreamSource(pr), new StreamResult(out));
                    }
                    out.flush();
                    break block16;
                }
                throw new GeneralException("No object profile returned");
            }
            catch (ServerException e) {
                throw e;
            }
            catch (Throwable th) {
                String message = "Error getting object profile";
                logger.error(message, th);
                throw new GeneralException(message, th);
            }
            finally {
                try {
                    if (pr != null) {
                        pr.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable th) {
                    String message = "Error closing output";
                    logger.error(message, th);
                    throw new StreamIOException(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDatastreamDissemination(Context context, String PID2, String dsID, Date asOfDateTime, HttpServletResponse response, HttpServletRequest request) throws IOException, ServerException {
        ServletOutputStream out = null;
        MIMETypedStream dissemination = null;
        dissemination = this.m_access.getDatastreamDissemination(context, PID2, dsID, asOfDateTime);
        try {
            if (logger.isDebugEnabled()) {
                Enumeration e = request.getHeaderNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Enumeration headerValues = request.getHeaders(name);
                    StringBuffer sb = new StringBuffer();
                    while (headerValues.hasMoreElements()) {
                        sb.append((String)headerValues.nextElement());
                    }
                    String value = sb.toString();
                    logger.debug("FEDORASERVLET REQUEST HEADER CONTAINED: " + name + " : " + value);
                }
            }
            if (dissemination.MIMEType.equalsIgnoreCase("application/fedora-redirect")) {
                BufferedReader br = new BufferedReader(new InputStreamReader(dissemination.getStream()));
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                response.sendRedirect(sb.toString());
            } else {
                response.setContentType(dissemination.MIMEType);
                Property[] headerArray = dissemination.header;
                if (headerArray != null) {
                    for (int i = 0; i < headerArray.length; ++i) {
                        if (headerArray[i].name == null || headerArray[i].name.equalsIgnoreCase("transfer-encoding") || headerArray[i].name.equalsIgnoreCase("content-type")) continue;
                        response.addHeader(headerArray[i].name, headerArray[i].value);
                        logger.debug("THIS WAS ADDED TO FEDORASERVLET RESPONSE HEADER FROM ORIGINATING PROVIDER " + headerArray[i].name + " : " + headerArray[i].value);
                    }
                }
                out = response.getOutputStream();
                int byteStream = 0;
                logger.debug("Started reading dissemination stream");
                InputStream dissemResult = dissemination.getStream();
                byte[] buffer = new byte[4096];
                while ((byteStream = dissemResult.read(buffer)) != -1) {
                    out.write(buffer, 0, byteStream);
                }
                buffer = null;
                dissemResult.close();
                dissemResult = null;
                out.flush();
                out.close();
                logger.debug("Finished reading dissemination stream");
            }
        }
        finally {
            dissemination.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDissemination(Context context, String PID2, String sDefPID, String methodName, Property[] userParms, Date asOfDateTime, HttpServletResponse response, HttpServletRequest request) throws IOException, ServerException {
        ServletOutputStream out = null;
        MIMETypedStream dissemination = null;
        dissemination = this.m_access.getDissemination(context, PID2, sDefPID, methodName, userParms, asOfDateTime);
        out = response.getOutputStream();
        try {
            if (logger.isDebugEnabled()) {
                Enumeration e = request.getHeaderNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Enumeration headerValues = request.getHeaders(name);
                    StringBuffer sb = new StringBuffer();
                    while (headerValues.hasMoreElements()) {
                        sb.append((String)headerValues.nextElement());
                    }
                    String value = sb.toString();
                    logger.debug("FEDORASERVLET REQUEST HEADER CONTAINED: " + name + " : " + value);
                }
            }
            if (dissemination.MIMEType.equalsIgnoreCase("application/fedora-redirect")) {
                BufferedReader br = new BufferedReader(new InputStreamReader(dissemination.getStream()));
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                response.sendRedirect(sb.toString());
            } else {
                response.setContentType(dissemination.MIMEType);
                Property[] headerArray = dissemination.header;
                if (headerArray != null) {
                    for (int i = 0; i < headerArray.length; ++i) {
                        if (headerArray[i].name == null || headerArray[i].name.equalsIgnoreCase("transfer-encoding") || headerArray[i].name.equalsIgnoreCase("content-type")) continue;
                        response.addHeader(headerArray[i].name, headerArray[i].value);
                        logger.debug("THIS WAS ADDED TO FEDORASERVLET RESPONSE HEADER FROM ORIGINATING PROVIDER " + headerArray[i].name + " : " + headerArray[i].value);
                    }
                }
                int byteStream = 0;
                logger.debug("Started reading dissemination stream");
                InputStream dissemResult = dissemination.getStream();
                byte[] buffer = new byte[4096];
                while ((byteStream = dissemResult.read(buffer)) != -1) {
                    out.write(buffer, 0, byteStream);
                }
                buffer = null;
                dissemResult.close();
                dissemResult = null;
                out.flush();
                out.close();
                logger.debug("Finished reading dissemination stream");
            }
        }
        finally {
            dissemination.close();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public class ProfileSerializerThread
    extends Thread {
        private PipedWriter pw = null;
        private String PID = null;
        private ObjectProfile objProfile = null;
        private Date versDateTime = null;

        public ProfileSerializerThread(Context context, String PID2, ObjectProfile objProfile, Date versDateTime, PipedWriter pw) {
            this.pw = pw;
            this.PID = PID2;
            this.objProfile = objProfile;
            this.versDateTime = versDateTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.pw != null) {
                try {
                    this.pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    this.pw.write("<objectProfile");
                    this.pw.write(" pid=\"" + StreamUtility.enc(this.PID) + "\"");
                    if (this.versDateTime != null) {
                        DateUtility.convertDateToString((Date)this.versDateTime);
                        this.pw.write(" dateTime=\"" + DateUtility.convertDateToString((Date)this.versDateTime) + "\"");
                    }
                    this.pw.write(" xmlns=\"" + Constants.OBJ_PROFILE1_0.namespace.uri + "\"");
                    this.pw.write(" xmlns:xsi=\"" + Constants.XSI.uri + "\"" + " xsi:schemaLocation=\"" + Constants.OBJ_PROFILE1_0.namespace.uri + " " + Constants.OBJ_PROFILE1_0.xsdLocation + "\">");
                    this.pw.write("<objLabel>" + StreamUtility.enc(this.objProfile.objectLabel) + "</objLabel>");
                    this.pw.write("<objOwnerId>" + StreamUtility.enc(this.objProfile.objectOwnerId) + "</objOwnerId>");
                    this.pw.write("<objModels>\n");
                    for (String model : this.objProfile.objectModels) {
                        this.pw.write("<model>" + model + "</model>\n");
                    }
                    this.pw.write("</objModels>");
                    String cDate = DateUtility.convertDateToString((Date)this.objProfile.objectCreateDate);
                    this.pw.write("<objCreateDate>" + cDate + "</objCreateDate>");
                    String mDate = DateUtility.convertDateToString((Date)this.objProfile.objectLastModDate);
                    this.pw.write("<objLastModDate>" + mDate + "</objLastModDate>");
                    this.pw.write("<objDissIndexViewURL>" + StreamUtility.enc(this.objProfile.dissIndexViewURL) + "</objDissIndexViewURL>");
                    this.pw.write("<objItemIndexViewURL>" + StreamUtility.enc(this.objProfile.itemIndexViewURL) + "</objItemIndexViewURL>");
                    this.pw.write("</objectProfile>");
                    this.pw.flush();
                    this.pw.close();
                }
                catch (IOException ioe) {
                    logger.error("WriteThread IOException", (Throwable)ioe);
                }
                finally {
                    try {
                        if (this.pw != null) {
                            this.pw.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.error("WriteThread IOException", (Throwable)ioe);
                    }
                }
            }
        }
    }
}

