/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.access.SpringAccessServlet;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.servletExceptionExtensions.BadRequest400Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.NotFound404Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetObjectHistoryServlet
extends SpringAccessServlet
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(GetObjectHistoryServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final String CONTENT_TYPE_XML = "text/xml; charset=UTF-8";
    public static final String ACTION_LABEL = "Get Object History";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String PID2 = null;
        boolean xml = false;
        String[] URIArray = request.getRequestURL().toString().split("/");
        if (URIArray.length != 6 || !URIArray[4].equals("getObjectHistory")) {
            throw new BadRequest400Exception(request, ACTION_LABEL, "", new String[0]);
        }
        PID2 = URIArray[5];
        logger.debug("Servicing getObjectHistory request (PID=" + PID2 + ")");
        Hashtable<String, String> h_userParms = new Hashtable<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = URLDecoder.decode((String)e.nextElement(), "UTF-8");
            String value = URLDecoder.decode(request.getParameter(name), "UTF-8");
            if (name.equalsIgnoreCase("xml")) {
                xml = new Boolean(request.getParameter(name));
            }
            h_userParms.put(name, value);
        }
        ReadOnlyContext context = ReadOnlyContext.getContext(GetObjectHistoryServlet.HTTP_REQUEST.REST.uri, request);
        try {
            this.getObjectHistory(context, PID2, xml, response);
        }
        catch (ObjectNotFoundException e2) {
            logger.error("Object not found for request: " + request.getRequestURI() + " (actionLabel=" + ACTION_LABEL + ")", (Throwable)e2);
            throw new NotFound404Exception(request, ACTION_LABEL, "", new String[0]);
        }
        catch (ObjectNotInLowlevelStorageException e3) {
            logger.error("Object not found for request: " + request.getRequestURI() + " (actionLabel=" + ACTION_LABEL + ")", (Throwable)e3);
            throw new NotFound404Exception(request, ACTION_LABEL, "", new String[0]);
        }
        catch (AuthzException ae) {
            throw RootException.getServletException(ae, request, ACTION_LABEL, new String[0]);
        }
        catch (Throwable th) {
            logger.error("Unexpected error servicing API-A request", th);
            throw new InternalError500Exception("", th, request, ACTION_LABEL, "", new String[0]);
        }
    }

    public void getObjectHistory(Context context, String PID2, boolean xml, HttpServletResponse response) throws ServerException {
        block16: {
            OutputStreamWriter out = null;
            String[] objectHistory = new String[]{};
            PipedWriter pw = null;
            PipedReader pr = null;
            try {
                pw = new PipedWriter();
                pr = new PipedReader(pw);
                objectHistory = this.m_access.getObjectHistory(context, PID2);
                if (objectHistory.length > 0) {
                    new ObjectHistorySerializerThread(context, objectHistory, PID2, pw).start();
                    if (xml) {
                        response.setContentType(CONTENT_TYPE_XML);
                        out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                        int bufSize = 4096;
                        char[] buf = new char[bufSize];
                        int len = 0;
                        while ((len = pr.read(buf, 0, bufSize)) != -1) {
                            out.write(buf, 0, len);
                        }
                        out.flush();
                    } else {
                        response.setContentType(CONTENT_TYPE_HTML);
                        out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                        File xslFile = new File(this.m_server.getHomeDir(), "access/viewObjectHistory.xslt");
                        TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
                        Templates template = factory.newTemplates(new StreamSource(xslFile));
                        Transformer transformer = template.newTransformer();
                        transformer.setParameter("fedora", context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
                        transformer.transform(new StreamSource(pr), new StreamResult(out));
                    }
                    out.flush();
                    break block16;
                }
                throw new GeneralException("No object history returned");
            }
            catch (ServerException e) {
                throw e;
            }
            catch (Throwable th) {
                String msg = "Error getting object history";
                throw new GeneralException(msg, th);
            }
            finally {
                try {
                    if (pr != null) {
                        pr.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable th) {
                    String message = "[GetObjectHistoryServlet] An error has occured.  The error was a \" " + th.getClass().getName() + " \". Reason: " + th.getMessage();
                    throw new StreamIOException(message);
                }
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public class ObjectHistorySerializerThread
    extends Thread {
        private PipedWriter pw = null;
        private String[] objectHistory = new String[0];
        private String PID = null;

        public ObjectHistorySerializerThread(Context context, String[] objectHistory, String PID2, PipedWriter pw) {
            this.pw = pw;
            this.objectHistory = objectHistory;
            this.PID = PID2;
            if (Constants.HTTP_REQUEST.SECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri)) || Constants.HTTP_REQUEST.INSECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri))) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.pw != null) {
                try {
                    this.pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    this.pw.write("<fedoraObjectHistory pid=\"" + this.PID + "\"" + " xmlns=\"" + Constants.OBJ_HISTORY1_0.namespace.uri + "\"" + " xmlns:xsd=\"" + Constants.XML_XSD.uri + "\"" + " xmlns:xsi=\"" + Constants.XSI.uri + "\"" + " xsi:schemaLocation=\"" + Constants.OBJ_HISTORY1_0.namespace.uri + " " + Constants.OBJ_HISTORY1_0.xsdLocation + "\">");
                    for (String element : this.objectHistory) {
                        this.pw.write("<objectChangeDate>" + element + "</objectChangeDate>");
                    }
                    this.pw.write("</fedoraObjectHistory>");
                    this.pw.flush();
                    this.pw.close();
                }
                catch (IOException ioe) {
                    logger.error("WriteThread error", (Throwable)ioe);
                }
                finally {
                    try {
                        if (this.pw != null) {
                            this.pw.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.error("WriteThread error", (Throwable)ioe);
                    }
                }
            }
        }
    }
}

