/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.SpringAccessServlet;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.servletExceptionExtensions.BadRequest400Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.NotFound404Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.server.storage.types.DatastreamDef;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.utilities.DateUtility;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDatastreamsServlet
extends SpringAccessServlet
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(ListDatastreamsServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final String CONTENT_TYPE_XML = "text/xml; charset=UTF-8";
    private String requestURI = null;
    private static String HTTP = "http";
    private static String HTTPS = "https";
    public static final String ACTION_LABEL = "List Datastreams";
    private String m_fedoraServerHost = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String PID2 = null;
        Date asOfDateTime = null;
        Date versDateTime = null;
        boolean xml = false;
        this.requestURI = request.getRequestURL().toString() + "?" + request.getQueryString();
        String[] URIArray = request.getRequestURL().toString().split("/");
        if (URIArray.length == 6 || URIArray.length == 7) {
            try {
                PID2 = Server.getPID(URIArray[5]).toString();
            }
            catch (Throwable th) {
                logger.error("Bad pid syntax in request", th);
                throw new BadRequest400Exception(request, ACTION_LABEL, "", new String[0]);
            }
            if (URIArray.length == 7) {
                try {
                    versDateTime = DateUtility.parseDateStrict((String)URIArray[6]);
                }
                catch (ParseException e) {
                    logger.error("Bad date format in request");
                    throw new BadRequest400Exception(request, ACTION_LABEL, "", new String[0]);
                }
                asOfDateTime = versDateTime;
            }
        } else {
            logger.error("Bad syntax (expected 6 or 7 parts) in request");
            throw new BadRequest400Exception(request, ACTION_LABEL, "", new String[0]);
        }
        logger.debug("Listing datastreams (PID=" + PID2 + ", asOfDate=" + versDateTime + ")");
        if (request.getParameter("xml") != null) {
            xml = new Boolean(request.getParameter("xml"));
        }
        try {
            ReadOnlyContext context = ReadOnlyContext.getContext(ListDatastreamsServlet.HTTP_REQUEST.REST.uri, request);
            this.listDatastreams(context, PID2, asOfDateTime, xml, request, response);
            logger.debug("Finished listing datastreams");
        }
        catch (ObjectNotFoundException e) {
            logger.error("Object not found for request: " + this.requestURI + " (actionLabel=" + ACTION_LABEL + ")", (Throwable)e);
            throw new NotFound404Exception(request, ACTION_LABEL, "", new String[0]);
        }
        catch (ObjectNotInLowlevelStorageException e) {
            logger.error("Object not found for request: " + this.requestURI + " (actionLabel=" + ACTION_LABEL + ")", (Throwable)e);
            throw new NotFound404Exception(request, ACTION_LABEL, "", new String[0]);
        }
        catch (AuthzException ae) {
            logger.error("Authorization failed while listing datastreams", (Throwable)ae);
            throw RootException.getServletException(ae, request, ACTION_LABEL, new String[0]);
        }
        catch (Throwable th) {
            logger.error("Error listing datastreams", th);
            throw new InternalError500Exception("Error listing datastreams", th, request, ACTION_LABEL, "", new String[0]);
        }
    }

    public void listDatastreams(Context context, String PID2, Date asOfDateTime, boolean xml, HttpServletRequest request, HttpServletResponse response) throws ServerException {
        OutputStreamWriter out = null;
        Date versDateTime = asOfDateTime;
        DatastreamDef[] dsDefs = null;
        PipedWriter pw = null;
        PipedReader pr = null;
        try {
            pw = new PipedWriter();
            pr = new PipedReader(pw);
            dsDefs = this.m_access.listDatastreams(context, PID2, asOfDateTime);
            new DatastreamDefSerializerThread(context, PID2, dsDefs, versDateTime, pw).start();
            if (xml) {
                response.setContentType(CONTENT_TYPE_XML);
                out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                int bufSize = 4096;
                char[] buf = new char[bufSize];
                int len = 0;
                while ((len = pr.read(buf, 0, bufSize)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
            } else {
                response.setContentType(CONTENT_TYPE_HTML);
                out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                File xslFile = new File(this.m_server.getHomeDir(), "access/listDatastreams.xslt");
                TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
                Templates template = factory.newTemplates(new StreamSource(xslFile));
                Transformer transformer = template.newTransformer();
                transformer.setParameter("fedora", context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
                transformer.transform(new StreamSource(pr), new StreamResult(out));
            }
            out.flush();
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Throwable th) {
            String message = "Error listing datastreams";
            logger.error(message, th);
            throw new GeneralException(message, th);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable th) {
                String message = "Error closing output";
                logger.error(message, th);
                throw new StreamIOException(message);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_fedoraServerHost = this.m_server.getParameter("fedoraServerHost");
    }

    public class DatastreamDefSerializerThread
    extends Thread {
        private PipedWriter pw = null;
        private String PID = null;
        private DatastreamDef[] dsDefs = null;
        private Date versDateTime = null;
        private String fedoraServerProtocol = null;
        private String fedoraServerPort = null;
        private String fedoraAppServerContext = null;

        public DatastreamDefSerializerThread(Context context, String PID2, DatastreamDef[] dsDefs, Date versDateTime, PipedWriter pw) {
            this.pw = pw;
            this.PID = PID2;
            this.dsDefs = dsDefs;
            this.versDateTime = versDateTime;
            this.fedoraServerPort = context.getEnvironmentValue(Constants.HTTP_REQUEST.SERVER_PORT.uri);
            this.fedoraAppServerContext = context.getEnvironmentValue("FEDORA_CONTEXT_NAME");
            if (Constants.HTTP_REQUEST.SECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri))) {
                this.fedoraServerProtocol = HTTPS;
            } else if (Constants.HTTP_REQUEST.INSECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri))) {
                this.fedoraServerProtocol = HTTP;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.pw != null) {
                try {
                    this.pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    this.pw.write("<objectDatastreams pid=\"" + this.PID + "\"");
                    if (this.versDateTime != null) {
                        this.pw.write(" asOfDateTime=\"");
                        this.pw.write(DateUtility.convertDateToString((Date)this.versDateTime));
                        this.pw.write("\"");
                    }
                    String baseURL = this.fedoraServerProtocol + "://" + ListDatastreamsServlet.this.m_fedoraServerHost + ":" + this.fedoraServerPort + "/" + this.fedoraAppServerContext + "/";
                    this.pw.write(" baseURL=\"" + baseURL + "\"");
                    this.pw.write(" xmlns=\"" + Constants.ACCESS.uri + "\"");
                    this.pw.write(" xmlns:xsi=\"" + Constants.XSI.uri + "\"");
                    this.pw.write(" xsi:schemaLocation=\"" + Constants.ACCESS.uri);
                    this.pw.write(" " + Constants.OBJ_DATASTREAMS1_0.xsdLocation + "\">");
                    for (DatastreamDef element : this.dsDefs) {
                        this.pw.write("    <datastream dsid=\"" + StreamUtility.enc(element.dsID) + "\" " + "label=\"" + StreamUtility.enc(element.dsLabel) + "\" " + "mimeType=\"" + StreamUtility.enc(element.dsMIME) + "\" />");
                    }
                    this.pw.write("</objectDatastreams>");
                    this.pw.flush();
                    this.pw.close();
                }
                catch (IOException ioe) {
                    logger.error("WriteThread error", (Throwable)ioe);
                }
                finally {
                    try {
                        if (this.pw != null) {
                            this.pw.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.error("WriteThread error", (Throwable)ioe);
                    }
                }
            }
        }
    }
}

