/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.common.Constants;
import org.fcrepo.server.utilities.RuntimeWSDL;

public class WSDLServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String _SERVLET_PATH = "/wsdl";
    private static final String _XSD_PATH = "xsd/fedora-types.xsd";
    private static final Map _WSDL_PATHS = new HashMap();
    private static final Map _SERVICE_PATHS = new HashMap();
    private File _serverDir;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String body;
        String api = request.getParameter("api");
        if (api == null || api.length() == 0) {
            body = this.getIndex();
            response.setContentType("text/html; charset=UTF-8");
        } else {
            body = this.getWSDL(api.toUpperCase(), request.getRequestURL().toString());
            response.setContentType("text/xml; charset=UTF-8");
        }
        PrintWriter writer = response.getWriter();
        writer.print(body);
        writer.flush();
        writer.close();
    }

    private String getIndex() {
        StringBuffer out = new StringBuffer();
        out.append("<html><body>WSDL Index<ul>\n");
        for (String name : _WSDL_PATHS.keySet()) {
            out.append("<li> <a href=\"?api=" + name + "\">" + name + "</a></li>\n");
        }
        out.append("</ul></body></html>");
        return out.toString();
    }

    private String getWSDL(String api, String requestURL) throws IOException, ServletException {
        String wsdlPath = (String)_WSDL_PATHS.get(api);
        if (wsdlPath != null) {
            File schemaFile = new File(this._serverDir, _XSD_PATH);
            File sourceWSDL = new File(this._serverDir, wsdlPath);
            String baseURL = this.getFedoraBaseURL(requestURL);
            String svcPath = (String)_SERVICE_PATHS.get(api);
            RuntimeWSDL wsdl = new RuntimeWSDL(schemaFile, sourceWSDL, baseURL + "/" + svcPath);
            StringWriter stringWriter = new StringWriter();
            PrintWriter out = new PrintWriter(stringWriter);
            wsdl.serialize(out);
            out.flush();
            out.close();
            return stringWriter.toString();
        }
        throw new ServletException("No such api: '" + api + "'");
    }

    private String getFedoraBaseURL(String requestURL) throws ServletException {
        int i = requestURL.lastIndexOf(_SERVLET_PATH);
        if (i != -1) {
            return requestURL.substring(0, i);
        }
        throw new ServletException("Unable to determine Fedora baseURL from request URL.  Request URL does not contain the string '/wsdl', as expected.");
    }

    public void init() throws ServletException {
        String fedoraHome = Constants.FEDORA_HOME;
        if (fedoraHome == null || fedoraHome.length() == 0) {
            throw new ServletException("FEDORA_HOME is not defined");
        }
        this._serverDir = new File(new File(fedoraHome), "server");
        if (!this._serverDir.isDirectory()) {
            throw new ServletException("No such directory: " + this._serverDir.getPath());
        }
    }

    static {
        _WSDL_PATHS.put("API-A", "access/Fedora-API-A.wsdl");
        _WSDL_PATHS.put("API-A-LITE", "access/Fedora-API-A-LITE.wsdl");
        _WSDL_PATHS.put("API-M", "management/Fedora-API-M.wsdl");
        _WSDL_PATHS.put("API-M-LITE", "management/Fedora-API-M-LITE.wsdl");
        _SERVICE_PATHS.put("API-A", "services/access");
        _SERVICE_PATHS.put("API-A-LITE", "");
        _SERVICE_PATHS.put("API-M", "services/management");
        _SERVICE_PATHS.put("API-M-LITE", "management");
    }
}

