/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access.defaultdisseminator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Models;
import org.fcrepo.server.Context;
import org.fcrepo.server.access.Access;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.access.defaultdisseminator.DefaultDisseminator;
import org.fcrepo.server.access.defaultdisseminator.InternalService;
import org.fcrepo.server.access.defaultdisseminator.ObjectInfoAsXML;
import org.fcrepo.server.errors.DisseminationException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.MethodDef;
import org.fcrepo.server.storage.types.MethodParmDef;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.utilities.XmlTransformUtility;
import org.jrdf.graph.ObjectNode;

public class DefaultDisseminatorImpl
extends InternalService
implements DefaultDisseminator {
    private final Context context;
    private final Date asOfDateTime;
    private final DOReader reader;
    private final String reposBaseURL;
    private final File reposHomeDir;
    private final Access m_access;

    public DefaultDisseminatorImpl(Context context, Date asOfDateTime, DOReader reader, Access access, String reposBaseURL, File reposHomeDir) throws ServerException {
        this.context = context;
        this.asOfDateTime = asOfDateTime;
        this.reader = reader;
        this.m_access = access;
        this.reposBaseURL = reposBaseURL;
        this.reposHomeDir = reposHomeDir;
    }

    @Override
    public MIMETypedStream viewObjectProfile() throws ServerException {
        try {
            ObjectProfile profile = this.m_access.getObjectProfile(this.context, this.reader.GetObjectPID(), this.asOfDateTime);
            ByteArrayInputStream in = null;
            try {
                in = new ByteArrayInputStream(new ObjectInfoAsXML(this.context).getObjectProfile(this.reposBaseURL, profile, this.asOfDateTime).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new GeneralException("[DefaultDisseminatorImpl] An error has occurred. The error was a \"" + uee.getClass().getName() + "\"  . The " + "Reason was \"" + uee.getMessage() + "\"  .");
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            File xslFile = new File(this.reposHomeDir, "access/viewObjectProfile.xslt");
            TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
            Templates template = factory.newTemplates(new StreamSource(xslFile));
            Transformer transformer = template.newTransformer();
            transformer.setParameter("fedora", this.context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
            transformer.transform(new StreamSource(in), new StreamResult(out));
            in = new ByteArrayInputStream(out.toByteArray());
            return new MIMETypedStream("text/html", in, null, out.toByteArray().length);
        }
        catch (TransformerException e) {
            throw new DisseminationException("[DefaultDisseminatorImpl] had an error in transforming xml for viewObjectProfile. Underlying exception was: " + e.getMessage());
        }
    }

    @Override
    public MIMETypedStream viewMethodIndex() throws ServerException {
        if (this.reader.hasContentModel((ObjectNode)Models.SERVICE_DEFINITION_3_0) || this.reader.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) {
            return this.noMethodIndexMsg();
        }
        ObjectMethodsDef[] methods = this.m_access.listMethods(this.context, this.reader.GetObjectPID(), this.asOfDateTime);
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(new ObjectInfoAsXML(this.context).getMethodIndex(this.reposBaseURL, this.reader.GetObjectPID(), methods, this.asOfDateTime).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new GeneralException("[DefaultDisseminatorImpl] An error has occurred. The error was a \"" + uee.getClass().getName() + "\"  . The " + "Reason was \"" + uee.getMessage() + "\"  .");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            File xslFile = new File(this.reposHomeDir, "access/listMethods.xslt");
            TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
            Templates template = factory.newTemplates(new StreamSource(xslFile));
            Transformer transformer = template.newTransformer();
            transformer.setParameter("fedora", this.context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
            transformer.transform(new StreamSource(in), new StreamResult(out));
            in = new ByteArrayInputStream(out.toByteArray());
            return new MIMETypedStream("text/html", in, null, out.toByteArray().length);
        }
        catch (TransformerException e) {
            throw new DisseminationException("[DefaultDisseminatorImpl] had an error in transforming xml for viewItemIndex. Underlying exception was: " + e.getMessage());
        }
    }

    @Override
    public MIMETypedStream viewItemIndex() throws ServerException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(new ObjectInfoAsXML(this.context).getItemIndex(this.reposBaseURL, this.context.getEnvironmentValue("FEDORA_CONTEXT_NAME"), this.reader, this.asOfDateTime).getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new GeneralException("[DefaultDisseminatorImpl] An error has occurred. The error was a \"" + e.getClass().getName() + "\"  . The " + "Reason was \"" + e.getMessage() + "\"  .");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            File xslFile = new File(this.reposHomeDir, "access/viewItemIndex.xslt");
            TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
            Templates template = factory.newTemplates(new StreamSource(xslFile));
            Transformer transformer = template.newTransformer();
            transformer.setParameter("fedora", this.context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
            transformer.transform(new StreamSource(in), new StreamResult(out));
            in = new ByteArrayInputStream(out.toByteArray());
            return new MIMETypedStream("text/html", in, null, out.toByteArray().length);
        }
        catch (TransformerException e) {
            throw new DisseminationException("[DefaultDisseminatorImpl] had an error in transforming xml for viewItemIndex. Underlying exception was: " + e.getMessage());
        }
    }

    @Override
    public MIMETypedStream viewDublinCore() throws ServerException {
        Datastream dcmd = null;
        ByteArrayInputStream in = null;
        try {
            dcmd = this.reader.GetDatastream("DC", this.asOfDateTime);
            in = new ByteArrayInputStream(new ObjectInfoAsXML(this.context).getOAIDublinCore(dcmd).getBytes("UTF-8"));
        }
        catch (ClassCastException cce) {
            throw new ObjectIntegrityException("Object " + this.reader.GetObjectPID() + " has a DC datastream, but it's not inline XML.");
        }
        catch (UnsupportedEncodingException uee) {
            throw new GeneralException("[DefaultDisseminatorImpl] An error has occurred. The error was a \"" + uee.getClass().getName() + "\"  . The " + "Reason was \"" + uee.getMessage() + "\"  .");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            File xslFile = new File(this.reposHomeDir, "access/viewDublinCore.xslt");
            TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
            Templates template = factory.newTemplates(new StreamSource(xslFile));
            Transformer transformer = template.newTransformer();
            transformer.setParameter("fedora", this.context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
            transformer.transform(new StreamSource(in), new StreamResult(out));
            in = new ByteArrayInputStream(out.toByteArray());
            return new MIMETypedStream("text/html", in, null, out.toByteArray().length);
        }
        catch (TransformerException e) {
            throw new DisseminationException("[DefaultDisseminatorImpl] had an error in transforming xml for viewDublinCore. Underlying exception was: " + e.getMessage());
        }
    }

    private MIMETypedStream noMethodIndexMsg() throws GeneralException {
        String msg = new String("The Dissemination Index is not available for Content Model objects, \n or Service Definition objects or Service Deployment objects.\n The addition of this feature is not currently scheduled.");
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><title>Dissemination Index Not Available</title></head>");
        sb.append("<body><center>");
        sb.append("<table width=\"784\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        sb.append("<tr><td width=\"141\" height=\"134\" valign=\"top\"><img src=\"/").append(this.context.getEnvironmentValue("FEDORA_CONTEXT_NAME")).append("/images/newlogo2.jpg\" width=\"141\" height=\"134\"/></td>");
        sb.append("<td width=\"643\" valign=\"top\">");
        sb.append("<center><h2>Fedora Repository</h2>");
        sb.append("<h3>Dissemination Index</h3>");
        sb.append("</center></td></tr></table>");
        sb.append("<p>" + msg + "</p>");
        sb.append("</body>");
        sb.append("</html>");
        String msgOut = sb.toString();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(msgOut.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new GeneralException("[DefaultDisseminatorImpl] An error has occurred. The error was a \"" + uee.getClass().getName() + "\"  . The " + "Reason was \"" + uee.getMessage() + "\"  .");
        }
        return new MIMETypedStream("text/html", in, null, in.available());
    }

    public static MethodDef[] reflectMethods() {
        ArrayList<MethodDef> methodList = new ArrayList<MethodDef>();
        MethodDef method = null;
        method = new MethodDef();
        method.methodName = "viewObjectProfile";
        method.methodLabel = "View description of the object";
        method.methodParms = new MethodParmDef[0];
        methodList.add(method);
        method = new MethodDef();
        method.methodName = "viewMethodIndex";
        method.methodLabel = "View a list of dissemination methods in the object";
        method.methodParms = new MethodParmDef[0];
        methodList.add(method);
        method = new MethodDef();
        method.methodName = "viewItemIndex";
        method.methodLabel = "View a list of items in the object";
        method.methodParms = new MethodParmDef[0];
        methodList.add(method);
        method = new MethodDef();
        method.methodName = "viewDublinCore";
        method.methodLabel = "View the Dublin Core record for the object";
        method.methodParms = new MethodParmDef[0];
        methodList.add(method);
        return methodList.toArray(new MethodDef[0]);
    }
}

