/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access.dissemination;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.common.Constants;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.SpringServlet;
import org.fcrepo.server.access.dissemination.DisseminationService;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.authorization.AuthzOperationalException;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamMediation;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.Property;
import org.fcrepo.server.utilities.ServerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastreamResolverServlet
extends SpringServlet {
    private static final Logger logger = LoggerFactory.getLogger(DatastreamResolverServlet.class);
    private static final long serialVersionUID = 1L;
    private DOManager m_manager;
    private static int datastreamMediationLimit;
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static String fedoraServerHost;
    private static String fedoraServerPort;
    private static String fedoraServerRedirectPort;
    public static final String ACTION_LABEL = "Resolve Datastream";

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            fedoraServerPort = this.m_server.getParameter("fedoraServerPort");
            fedoraServerRedirectPort = this.m_server.getParameter("fedoraRedirectPort");
            fedoraServerHost = this.m_server.getParameter("fedoraServerHost");
            this.m_manager = (DOManager)((Object)this.m_server.getModule("org.fcrepo.server.storage.DOManager"));
            String expireLimit = this.m_server.getParameter("datastreamMediationLimit");
            if (expireLimit == null || expireLimit.equalsIgnoreCase("")) {
                logger.info("datastreamMediationLimit unspecified, using default of 5 seconds");
                datastreamMediationLimit = 5000;
            } else {
                datastreamMediationLimit = new Integer(expireLimit);
                logger.info("datastreamMediationLimit: " + datastreamMediationLimit);
            }
        }
        catch (Throwable th) {
            logger.error("Error initializing servlet", th);
        }
    }

    private static final boolean contains(String[] array, String item) {
        boolean contains = false;
        for (String element : array) {
            if (!element.equals(item)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = null;
        String dsPhysicalLocation = null;
        String dsControlGroupType = null;
        String user = null;
        String pass = null;
        MIMETypedStream mimeTypedStream = null;
        DisseminationService ds = null;
        Timestamp keyTimestamp = null;
        Timestamp currentTimestamp = null;
        PrintWriter out = null;
        ServletOutputStream outStream = null;
        String requestURI = request.getRequestURL().toString() + "?" + request.getQueryString();
        id = request.getParameter("id").replaceAll("T", " ");
        logger.debug("Datastream tempID=" + id);
        logger.debug("DRS doGet()");
        try {
            if (id == null || id.equalsIgnoreCase("")) {
                String message = "[DatastreamResolverServlet] No datastream ID specified in servlet request: " + request.getRequestURI();
                logger.error(message);
                response.setStatus(500);
                response.sendError(500, message);
                return;
            }
            id = id.replaceAll("T", " ").replaceAll("/", "").trim();
            ds = new DisseminationService(this.m_server);
            DatastreamMediation dm = DisseminationService.dsRegistry.get(id);
            if (dm == null) {
                StringBuffer entries = new StringBuffer();
                Iterator<String> eIter = DisseminationService.dsRegistry.keySet().iterator();
                while (eIter.hasNext()) {
                    entries.append("'" + eIter.next() + "' ");
                }
                throw new IOException("Cannot find datastream in temp registry by key: " + id + "\n" + "Reg entries: " + entries.toString());
            }
            dsPhysicalLocation = dm.dsLocation;
            dsControlGroupType = dm.dsControlGroupType;
            user = dm.callUsername;
            pass = dm.callPassword;
            if (logger.isDebugEnabled()) {
                logger.debug("**************************** DatastreamResolverServlet dm.dsLocation: {}", (Object)dm.dsLocation);
                logger.debug("**************************** DatastreamResolverServlet dm.dsControlGroupType: {}", (Object)dm.dsControlGroupType);
                logger.debug("**************************** DatastreamResolverServlet dm.callUsername: {}", (Object)dm.callUsername);
                logger.debug("**************************** DatastreamResolverServlet dm.Password: {}", (Object)dm.callPassword);
                logger.debug("**************************** DatastreamResolverServlet dm.callbackRole: {}", (Object)dm.callbackRole);
                logger.debug("**************************** DatastreamResolverServlet dm.callbackBasicAuth: {}", (Object)dm.callbackBasicAuth);
                logger.debug("**************************** DatastreamResolverServlet dm.callBasicAuth: {}", (Object)dm.callBasicAuth);
                logger.debug("**************************** DatastreamResolverServlet dm.callbackSSl: {}", (Object)dm.callbackSSL);
                logger.debug("**************************** DatastreamResolverServlet dm.callSSl: {}", (Object)dm.callSSL);
                logger.debug("**************************** DatastreamResolverServlet non ssl port: {}", (Object)fedoraServerPort);
                logger.debug("**************************** DatastreamResolverServlet ssl port: {}", (Object)fedoraServerRedirectPort);
            }
            if (request.getRequestURI().endsWith("getDS") && (ServerUtility.isURLFedoraServer(dsPhysicalLocation) || dsControlGroupType.equals("M") || dsControlGroupType.equals("X"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("*********************** Changed role from: " + dm.callbackRole + "  to: " + "fedoraInternalCall-2");
                }
                dm.callbackRole = "fedoraInternalCall-2";
            }
            if (dm.callbackRole.equals("fedoraInternalCall-1") && dm.callbackSSL) {
                dsPhysicalLocation = dsPhysicalLocation.replaceFirst("http:", "https:");
                dsPhysicalLocation = dsPhysicalLocation.replaceFirst(fedoraServerPort, fedoraServerRedirectPort);
                if (logger.isDebugEnabled()) {
                    logger.debug("*********************** DatastreamResolverServlet -- Was Fedora-to-Fedora call -- modified dsPhysicalLocation: " + dsPhysicalLocation);
                }
            }
            keyTimestamp = Timestamp.valueOf(ds.extractTimestamp(id));
            currentTimestamp = new Timestamp(new Date().getTime());
            logger.debug("dsPhysicalLocation=" + dsPhysicalLocation + "dsControlGroupType=" + dsControlGroupType);
            long diff = currentTimestamp.getTime() - keyTimestamp.getTime();
            logger.debug("Timestamp diff for mechanism's reponse: " + diff + " ms.");
            if (diff > (long)datastreamMediationLimit) {
                out = response.getWriter();
                response.setContentType(HTML_CONTENT_TYPE);
                out.println("<br><b>[DatastreamResolverServlet] Error:</b><font color=\"red\"> Deployment has failed to respond to the DatastreamResolverServlet within the specified time limit of \"" + datastreamMediationLimit + "\"" + "milliseconds. Datastream access denied.");
                logger.error("Deployment failed to respond to DatastreamResolverServlet within time limit of " + datastreamMediationLimit);
                out.close();
                return;
            }
            if (dm.callbackRole == null) {
                throw new AuthzOperationalException("no callbackRole for this ticket");
            }
            String targetRole = dm.callbackRole;
            String[] targetRoles = new String[]{targetRole};
            ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, request);
            if (request.getRemoteUser() == null) {
                logger.debug("DatastreamResolverServlet: unAuthenticated request");
            } else {
                logger.debug("DatastreamResolverServlet: user==" + request.getRemoteUser());
            }
            if (logger.isDebugEnabled()) {
                String name;
                logger.debug("debugging backendService role");
                logger.debug("targetRole=" + targetRole);
                int targetRolesLength = targetRoles.length;
                logger.debug("targetRolesLength=" + targetRolesLength);
                if (targetRolesLength > 0) {
                    logger.debug("targetRoles[0]=" + targetRoles[0]);
                }
                int nSubjectValues = context.nSubjectValues(targetRole);
                logger.debug("nSubjectValues=" + nSubjectValues);
                if (nSubjectValues > 0) {
                    logger.debug("context.getSubjectValue(targetRole)=" + context.getSubjectValue(targetRole));
                }
                Iterator<String> it = context.subjectAttributes();
                block13: while (it.hasNext()) {
                    String[] values;
                    name = it.next();
                    int n = context.nSubjectValues(name);
                    switch (n) {
                        case 0: {
                            logger.debug("no subject attributes for " + name);
                            continue block13;
                        }
                        case 1: {
                            String value = context.getSubjectValue(name);
                            logger.debug("single subject attributes for " + name + "=" + value);
                            continue block13;
                        }
                    }
                    for (String element : values = context.getSubjectValues(name)) {
                        logger.debug("another subject attribute from context " + name + "=" + element);
                    }
                }
                it = context.environmentAttributes();
                while (it.hasNext()) {
                    name = it.next();
                    String value = context.getEnvironmentValue(name);
                    logger.debug("another environment attribute from context " + name + "=" + value);
                }
            }
            if (dsControlGroupType.equalsIgnoreCase("E")) {
                if (logger.isDebugEnabled()) {
                    Enumeration e = request.getHeaderNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        Enumeration headerValues = request.getHeaders(name);
                        StringBuffer sb = new StringBuffer();
                        while (headerValues.hasMoreElements()) {
                            sb.append((String)headerValues.nextElement());
                        }
                        String value = sb.toString();
                        logger.debug("DATASTREAMRESOLVERSERVLET REQUEST HEADER CONTAINED: " + name + " : " + value);
                    }
                }
                ExternalContentManager externalContentManager = (ExternalContentManager)((Object)this.m_server.getModule("org.fcrepo.server.storage.ExternalContentManager"));
                ContentManagerParams params = new ContentManagerParams(dsPhysicalLocation);
                params.setContext(context);
                mimeTypedStream = externalContentManager.getExternalContent(params);
                outStream = response.getOutputStream();
                response.setContentType(mimeTypedStream.MIMEType);
                Property[] headerArray = mimeTypedStream.header;
                if (headerArray != null) {
                    for (int i = 0; i < headerArray.length; ++i) {
                        if (headerArray[i].name == null || headerArray[i].name.equalsIgnoreCase("content-type")) continue;
                        response.addHeader(headerArray[i].name, headerArray[i].value);
                        logger.debug("THIS WAS ADDED TO DATASTREAMRESOLVERSERVLET RESPONSE HEADER FROM ORIGINATING PROVIDER " + headerArray[i].name + " : " + headerArray[i].value);
                    }
                }
                int byteStream = 0;
                byte[] buffer = new byte[255];
                while ((byteStream = mimeTypedStream.getStream().read(buffer)) != -1) {
                    outStream.write(buffer, 0, byteStream);
                }
                buffer = null;
                outStream.flush();
                mimeTypedStream.close();
            } else if (dsControlGroupType.equalsIgnoreCase("M") || dsControlGroupType.equalsIgnoreCase("X")) {
                String PID2 = null;
                String dsVersionID = null;
                String dsID = null;
                String[] s = dsPhysicalLocation.split("\\+");
                if (s.length != 3) {
                    String message = "[DatastreamResolverServlet]  The internal Fedora datastream id:  \"" + dsPhysicalLocation + "\"  is invalid.";
                    logger.error(message);
                    throw new ServletException(message);
                }
                PID2 = s[0];
                dsID = s[1];
                dsVersionID = s[2];
                logger.debug("PID=" + PID2 + ", dsID=" + dsID + ", dsVersionID=" + dsVersionID);
                DOReader doReader = this.m_manager.getReader(false, context, PID2);
                Datastream d = doReader.getDatastream(dsID, dsVersionID);
                logger.debug("Got datastream: " + d.DatastreamID);
                InputStream is = d.getContentStream(context);
                int bytestream = 0;
                response.setContentType(d.DSMIME);
                outStream = response.getOutputStream();
                byte[] buffer = new byte[255];
                while ((bytestream = is.read(buffer)) != -1) {
                    outStream.write(buffer, 0, bytestream);
                }
                buffer = null;
                is.close();
            } else {
                out = response.getWriter();
                response.setContentType(HTML_CONTENT_TYPE);
                out.println("<br>[DatastreamResolverServlet] Unknown dsControlGroupType: " + dsControlGroupType + "</br>");
                logger.error("Unknown dsControlGroupType: " + dsControlGroupType);
            }
        }
        catch (AuthzException ae) {
            logger.error("Authorization failure resolving datastream (actionLabel=Resolve Datastream)", (Throwable)ae);
            throw RootException.getServletException(ae, request, ACTION_LABEL, new String[0]);
        }
        catch (Throwable th) {
            logger.error("Error resolving datastream", th);
            String message = "[DatastreamResolverServlet] returned an error. The underlying error was a  \"" + th.getClass().getName() + "  The message was  \"" + th.getMessage() + "\".  ";
            throw new ServletException(message);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            DisseminationService.dsRegistry.remove(id);
        }
    }

    @Override
    public void destroy() {
    }
}

