/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.fcrepo.common.Constants;

public class Parameter
implements Constants {
    private final String m_name;
    private String m_value;
    private boolean m_isFilePath;
    private String m_comment;
    private final Map<String, String> m_profileValues;

    public Parameter(String name, String value, boolean isFilePath, String comment, Map<String, String> profileValues) {
        this.m_name = name;
        this.m_value = value;
        this.m_isFilePath = isFilePath;
        this.m_comment = comment;
        this.m_profileValues = profileValues;
    }

    public Parameter(String name) {
        this(name, null, false, null, new HashMap<String, String>());
    }

    private Parameter(String name, String value) {
        this(name, value, false, null, new HashMap<String, String>());
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getValue(boolean asAbsolutePath) {
        File f;
        String path = this.m_value;
        if (asAbsolutePath && path != null && this.m_isFilePath && !(f = new File(path)).isAbsolute()) {
            path = FEDORA_HOME + File.separator + path;
        }
        return path;
    }

    public void setValue(String newValue) {
        this.m_value = newValue;
    }

    public Map<String, String> getProfileValues() {
        return this.m_profileValues;
    }

    public void setIsFilePath(boolean newValue) {
        this.m_isFilePath = newValue;
    }

    public boolean getIsFilePath() {
        return this.m_isFilePath;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public String toString() {
        return this.m_name;
    }
}

