/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.errors;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.fcrepo.server.Server;

public abstract class ServerException
extends Exception {
    private final String m_bundleName;
    private final String m_code;
    private String m_defaultMessage;
    private final String[] m_values;
    private final String[] m_details;
    private boolean m_wasServer;
    private static String[] s_emptyStringArray = new String[0];

    public ServerException(String bundleName, String code, String[] values, String[] details, Throwable cause) {
        super(code, cause);
        this.m_bundleName = bundleName;
        this.m_code = code;
        this.m_values = values;
        this.m_details = details;
        this.m_wasServer = false;
    }

    public String getCode() {
        return this.m_code;
    }

    public boolean wasServer() {
        return this.m_wasServer;
    }

    public void setWasServer() {
        this.m_wasServer = true;
    }

    @Override
    public String getMessage() {
        if (this.m_defaultMessage == null) {
            this.m_defaultMessage = ServerException.getLocalizedOrCode(this.m_bundleName, Server.getLocale(), this.m_code, this.m_values);
        }
        return this.m_defaultMessage;
    }

    public String getMessage(Locale locale) {
        return ServerException.getLocalizedOrCode(this.m_bundleName, locale, this.m_code, this.m_values);
    }

    public String[] getDetails() {
        return this.getDetails(Server.getLocale());
    }

    public String[] getDetails(Locale locale) {
        if (this.m_details == null || this.m_details.length == 0) {
            return s_emptyStringArray;
        }
        String[] ret = new String[this.m_details.length];
        for (int i = 0; i < this.m_details.length; ++i) {
            ret[i] = ServerException.getLocalizedOrCode(this.m_bundleName, locale, this.m_code, null);
        }
        return ret;
    }

    private static String getLocalizedOrCode(String bundleName, Locale locale, String code, String[] values) {
        ResourceBundle bundle = null;
        if (bundleName != null) {
            bundle = ResourceBundle.getBundle(bundleName, locale);
        }
        if (bundle == null) {
            return code;
        }
        String locMessage = bundle.getString(code);
        if (locMessage == null) {
            return code;
        }
        if (values == null) {
            return locMessage;
        }
        return MessageFormat.format(locMessage, values);
    }
}

