/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.helpers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.fcrepo.utilities.Base64;

public class DecodingBase64OutputStream {
    private final Pattern pattern = Pattern.compile("[^A-Za-z0-9+/=]*");
    private final OutputStream stream;
    private String residual = "";
    private boolean open = true;

    public DecodingBase64OutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public void write(String data) throws IOException {
        if (!this.open) {
            throw new IllegalStateException("Stream has already been closed.");
        }
        String buffer = this.pattern.matcher(this.residual + data).replaceAll("");
        int usableLength = buffer.length() - buffer.length() % 4;
        this.stream.write(Base64.decode((String)buffer.substring(0, usableLength)));
        this.residual = buffer.substring(usableLength);
    }

    public void close() throws IOException {
        if (this.open) {
            if (this.residual.length() > 0) {
                throw new IOException("Base64 error - data is not properlypadded to 4-character groups.");
            }
            this.stream.close();
            this.open = false;
        }
    }
}

