/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.helpers;

import java.io.IOException;
import java.io.InputStream;
import org.fcrepo.utilities.Base64;

public class EncodingBase64InputStream {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final InputStream stream;
    private final byte[] buffer;
    private boolean open = true;
    private int bytesInBuffer = 0;
    private boolean innerStreamHasMoreData = true;

    public EncodingBase64InputStream(InputStream stream) {
        this(stream, 1024);
    }

    public EncodingBase64InputStream(InputStream stream, int bufferSize) {
        if (bufferSize < 10 || bufferSize > 1000000) {
            throw new IllegalArgumentException("Buffer size must be between 10 and 1,000,000. Cannot be " + bufferSize);
        }
        this.buffer = new byte[bufferSize];
        this.stream = stream;
    }

    public String read(int maxStringLength) throws IOException {
        if (maxStringLength < 4) {
            throw new IllegalArgumentException("maxStringLength must be 4 or more, not " + maxStringLength);
        }
        if (!this.open) {
            throw new IllegalStateException("Stream has already been closed.");
        }
        int bytesRequestedForEncoding = maxStringLength / 4 * 3;
        if (bytesRequestedForEncoding > this.bytesInBuffer) {
            this.readMoreBytesFromStream();
        }
        if (this.bytesInBuffer == 0 && !this.innerStreamHasMoreData) {
            return null;
        }
        int bytesToEncode = Math.min(bytesRequestedForEncoding, this.bytesInBuffer);
        String result = this.encodeBytesFromBuffer(bytesToEncode);
        return result;
    }

    public void close() throws IOException {
        this.open = false;
        this.stream.close();
    }

    private void readMoreBytesFromStream() throws IOException {
        if (!this.innerStreamHasMoreData) {
            return;
        }
        int bufferSpaceAvailable = this.buffer.length - this.bytesInBuffer;
        if (bufferSpaceAvailable <= 0) {
            return;
        }
        int bytesRead = this.stream.read(this.buffer, this.bytesInBuffer, bufferSpaceAvailable);
        if (bytesRead == -1) {
            this.innerStreamHasMoreData = false;
        } else {
            this.bytesInBuffer += bytesRead;
        }
    }

    private String encodeBytesFromBuffer(int howMany) {
        if (this.innerStreamHasMoreData) {
            howMany -= howMany % 3;
        }
        if (howMany == 0) {
            return "";
        }
        byte[] encodeBuffer = new byte[howMany];
        System.arraycopy(this.buffer, 0, encodeBuffer, 0, howMany);
        String result = Base64.encodeToString((byte[])encodeBuffer);
        this.bytesInBuffer -= howMany;
        if (this.bytesInBuffer != 0) {
            System.arraycopy(this.buffer, howMany, this.buffer, 0, this.bytesInBuffer);
        }
        return result;
    }
}

