/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.helpers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileMovingUtil {
    private FileMovingUtil() {
    }

    public static final void move(File fromFile, File toFile) throws IOException {
        if (fromFile.renameTo(toFile)) {
            return;
        }
        FileMovingUtil.checkThatFileDoesntExist(toFile);
        File tempFile = FileMovingUtil.createTempFile(toFile);
        FileMovingUtil.checkThatFileDoesntExist(tempFile);
        FileMovingUtil.copy(fromFile, tempFile);
        tempFile.renameTo(toFile);
        if (!fromFile.delete()) {
            throw new IOException("Failed to delete '" + fromFile.getParent() + "'");
        }
    }

    private static void checkThatFileDoesntExist(File file) throws IOException {
        if (file.exists()) {
            throw new IOException("File '" + file.getPath() + "' already exists.");
        }
    }

    private static File createTempFile(File baseFile) {
        File parentDirectory = baseFile.getParentFile();
        String filename = baseFile.getName();
        return new File(parentDirectory, '_' + filename);
    }

    private static final void copy(File fromFile, File toFile) throws IOException {
        FileInputStream in = new FileInputStream(fromFile);
        FileOutputStream out = new FileOutputStream(toFile);
        BufferedInputStream inBuffer = new BufferedInputStream(in);
        BufferedOutputStream outBuffer = new BufferedOutputStream(out);
        int theByte = 0;
        while ((theByte = inBuffer.read()) > -1) {
            outBuffer.write(theByte);
        }
        outBuffer.close();
        inBuffer.close();
        out.close();
        in.close();
        if (fromFile.length() != toFile.length()) {
            toFile.delete();
            throw new IOException("Copy failed: source file length=" + fromFile.length() + ", target file length=" + toFile.length());
        }
    }
}

