/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.helpers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.helpers.JournalTempFile;
import org.fcrepo.server.utilities.StreamUtility;

public class JournalHelper
implements JournalConstants {
    private JournalHelper() {
    }

    public static File copyToTempFile(InputStream serialization) throws IOException, FileNotFoundException {
        File tempFile = JournalHelper.createTempFile();
        StreamUtility.pipeStream(serialization, new FileOutputStream(tempFile), 4096);
        return tempFile;
    }

    public static File createTempFile() throws IOException {
        File rawTempFile = File.createTempFile("fedora-journal-temp", ".xml");
        return new JournalTempFile(rawTempFile);
    }

    public static boolean isTempFile(File file) {
        return file instanceof JournalTempFile;
    }

    public static String captureStackTrace(Throwable e) {
        StringWriter buffer = new StringWriter();
        e.printStackTrace(new PrintWriter(buffer));
        return buffer.toString();
    }

    public static Object createInstanceAccordingToParameter(String parameterName, Class<?>[] argClasses, Object[] args, Map<String, String> parameters) throws JournalException {
        String className = parameters.get(parameterName);
        if (className == null) {
            throw new JournalException("No parameter '" + parameterName + "'");
        }
        return JournalHelper.createInstanceFromClassname(className, argClasses, args);
    }

    public static Object createInstanceFromClassname(String className, Class<?>[] argClasses, Object[] args) throws JournalException {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(argClasses);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new JournalException(e);
        }
    }

    public static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return formatter.format(date);
    }

    public static Date parseDate(String date) throws JournalException {
        try {
            SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return parser.parse(date);
        }
        catch (ParseException e) {
            throw new JournalException(e);
        }
    }

    public static String createTimestampedFilename(String filenamePrefix, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return filenamePrefix + formatter.format(date) + "Z";
    }
}

