/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.helpers;

import org.fcrepo.utilities.Base64;

public class PasswordCipher {
    public static String encipher(String key, String clearText) {
        if (key == null) {
            throw new NullPointerException("key may not be null");
        }
        if (key == "") {
            return clearText;
        }
        if (clearText == null) {
            return null;
        }
        byte[] keyBytes = PasswordCipher.convertKeyToByteArray(key);
        byte[] clearTextBytes = PasswordCipher.convertClearTextToByteArray(clearText);
        byte[] cipherBytes = PasswordCipher.applyCipher(keyBytes, clearTextBytes);
        return Base64.encodeToString((byte[])cipherBytes);
    }

    public static String decipher(String key, String cipherText, String cipherType) {
        if (key == null || key == "") {
            return cipherText;
        }
        if (cipherText == null) {
            return null;
        }
        if (cipherType == null || cipherType == "") {
            return cipherText;
        }
        if ("1".equalsIgnoreCase(cipherType)) {
            byte[] keyBytes = PasswordCipher.convertKeyToByteArray(key);
            byte[] cipherBytes = Base64.decode((String)cipherText);
            PasswordCipher.sanityCheckOnCipherBytes(cipherText, cipherBytes);
            byte[] clearTextBytes = PasswordCipher.applyCipher(keyBytes, cipherBytes);
            return PasswordCipher.convertByteArrayToClearText(clearTextBytes);
        }
        throw new IllegalArgumentException("Unrecognized cipher type: '" + cipherType + "'");
    }

    private static byte[] convertKeyToByteArray(String key) {
        byte[] result = new byte[key.length()];
        for (int i = 0; i < result.length; ++i) {
            char thisChar = key.charAt(i);
            result[i] = (byte)(thisChar >>> 8 & 0xFF ^ thisChar & 0xFF);
        }
        return result;
    }

    private static byte[] convertClearTextToByteArray(String clearText) {
        byte[] result = new byte[clearText.length() * 2];
        for (int i = 0; i < clearText.length(); ++i) {
            char thisChar = clearText.charAt(i);
            int pos = i * 2;
            result[pos] = (byte)(thisChar >>> 8 & 0xFF);
            result[pos + 1] = (byte)(thisChar & 0xFF);
        }
        return result;
    }

    private static void sanityCheckOnCipherBytes(String cipherText, byte[] cipherBytes) {
        if (cipherBytes.length % 2 != 0) {
            throw new IllegalStateException("Ciphered text decodes to an odd number of bytes! Text='" + cipherText + "', decodes to " + cipherBytes.length + " bytes.");
        }
    }

    private static String convertByteArrayToClearText(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; i += 2) {
            char thisChar = (char)(bytes[i] << 8 | bytes[i + 1]);
            result.append(thisChar);
        }
        return result.toString();
    }

    private static byte[] applyCipher(byte[] keyBytes, byte[] textBytes) {
        byte[] result = new byte[textBytes.length];
        for (int i = 0; i < result.length; ++i) {
            int keyPos = i % keyBytes.length;
            result[i] = (byte)(textBytes[i] ^ keyBytes[keyPos]);
        }
        return result;
    }
}

