/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.io.File;
import java.io.StringWriter;
import java.util.Map;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.Context;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.entry.CreatorJournalEntry;
import org.fcrepo.server.journal.entry.JournalEntry;
import org.fcrepo.server.journal.readerwriter.multicast.MulticastJournalWriter;

public class JournalEntrySizeEstimator {
    private final MulticastJournalWriter journalWriter;

    public JournalEntrySizeEstimator(MulticastJournalWriter journalWriter) {
        this.journalWriter = journalWriter;
    }

    public long estimateSize(JournalEntry journalEntry) throws JournalException {
        try {
            long totalFileSizes = 0L;
            CreatorJournalEntry copyEntry = new CreatorJournalEntry(journalEntry.getMethodName(), (Context)journalEntry.getContext());
            Map<String, Object> argumentsMap = journalEntry.getArgumentsMap();
            for (String name : argumentsMap.keySet()) {
                Object value = argumentsMap.get(name);
                if (value instanceof File) {
                    totalFileSizes += this.estimateFileSize((File)value);
                    copyEntry.addArgument(name, (Object)null);
                    continue;
                }
                copyEntry.addArgument(name, value);
            }
            StringWriter stringWriter = new StringWriter();
            XMLEventWriter xmlEventWriter = this.createXmlEventWriter(stringWriter);
            this.journalWriter.writeJournalEntry(copyEntry, xmlEventWriter);
            return totalFileSizes + (long)stringWriter.getBuffer().length();
        }
        catch (FactoryConfigurationError e) {
            throw new JournalException("can't estimate the size of a JournalEntry", e);
        }
        catch (XMLStreamException e) {
            throw new JournalException("can't estimate the size of a JournalEntry", e);
        }
    }

    private long estimateFileSize(File file) {
        if (file == null) {
            return 0L;
        }
        return file.length() * 4L / 3L + file.length() / 57L;
    }

    private XMLEventWriter createXmlEventWriter(StringWriter stringWriter) throws FactoryConfigurationError, XMLStreamException {
        return new IndentingXMLEventWriter(XMLOutputFactory.newInstance().createXMLEventWriter(stringWriter));
    }
}

