/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast.rmi;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Map;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multicast.Transport;
import org.fcrepo.server.journal.readerwriter.multicast.TransportParent;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverInterface;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiTransportWriter;

public class RmiTransport
extends Transport {
    public static final String PARAMETER_HOST_NAME = "hostName";
    public static final String PARAMETER_PORT_NUMBER = "port";
    public static final String PARAMETER_SERVICE_NAME = "service";
    public static final String PARAMETER_BUFFER_SIZE = "bufferSize";
    public static final int DEFAULT_PORT_NUMBER = 1099;
    public static final int DEFAULT_BUFFER_SIZE = 100000;
    private final int bufferSize;
    private final RmiJournalReceiverInterface receiver;
    private RmiTransportWriter writer;
    private XMLEventWriter xmlWriter;

    public RmiTransport(Map<String, String> parameters, boolean crucial, TransportParent parent) throws JournalException {
        super(parameters, crucial, parent);
        String host = this.parseHost(parameters);
        String port = this.parsePort(parameters);
        String serviceName = this.parseServiceName(parameters);
        this.bufferSize = this.parseBufferSize(parameters);
        String serverName = "//" + host + ":" + port;
        String nameString = serverName + "/" + serviceName;
        try {
            this.receiver = (RmiJournalReceiverInterface)Naming.lookup(nameString);
        }
        catch (MalformedURLException e) {
            throw new JournalException("Problem finding RMI registry", e);
        }
        catch (RemoteException e) {
            throw new JournalException("Problem contacting RMI registry", e);
        }
        catch (NotBoundException e) {
            throw new JournalException("'" + serviceName + "' not registered at '" + serverName + "'", e);
        }
    }

    protected RmiTransport(Map<String, String> parameters, boolean crucial, TransportParent parent, RmiJournalReceiverInterface rx) throws JournalException {
        super(parameters, crucial, parent);
        this.bufferSize = this.parseBufferSize(parameters);
        this.receiver = rx;
    }

    private String parseHost(Map<String, String> parameters) throws JournalException {
        String host = this.getRequiredParameter(parameters, PARAMETER_HOST_NAME);
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new JournalException("Invalid 'hostName' parameter: " + host, e);
        }
        return host;
    }

    private String parsePort(Map<String, String> parameters) throws JournalException {
        if (parameters.containsKey(PARAMETER_PORT_NUMBER)) {
            String port = parameters.get(PARAMETER_PORT_NUMBER);
            try {
                Integer.parseInt(port);
                return port;
            }
            catch (NumberFormatException e) {
                throw new JournalException("Invalid 'port' parameter: " + port, e);
            }
        }
        return String.valueOf(1099);
    }

    private String parseServiceName(Map<String, String> parameters) throws JournalException {
        return this.getRequiredParameter(parameters, PARAMETER_SERVICE_NAME);
    }

    private int parseBufferSize(Map<String, String> parameters) throws JournalException {
        if (parameters.containsKey(PARAMETER_BUFFER_SIZE)) {
            String size = parameters.get(PARAMETER_BUFFER_SIZE);
            try {
                return Integer.parseInt(size);
            }
            catch (NumberFormatException e) {
                throw new JournalException("Invalid 'bufferSize' parameter: " + size, e);
            }
        }
        return 100000;
    }

    private String getRequiredParameter(Map<String, String> parameters, String parameter) throws JournalException {
        if (!parameters.containsKey(parameter)) {
            throw new JournalException("RmiTransport requires '" + parameter + "' parameter.");
        }
        return parameters.get(parameter);
    }

    @Override
    public void openFile(String repositoryHash, String filename, Date currentDate) throws JournalException {
        try {
            super.testStateChange(Transport.State.FILE_OPEN);
            this.writer = new RmiTransportWriter(this.receiver, repositoryHash, filename);
            this.xmlWriter = new IndentingXMLEventWriter(XMLOutputFactory.newInstance().createXMLEventWriter(new BufferedWriter(this.writer, this.bufferSize)));
            this.parent.writeDocumentHeader(this.xmlWriter, repositoryHash, currentDate);
            super.setState(Transport.State.FILE_OPEN);
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new JournalException(e);
        }
    }

    @Override
    public XMLEventWriter getWriter() throws JournalException {
        super.testWriterState();
        return this.xmlWriter;
    }

    @Override
    public void closeFile() throws JournalException {
        try {
            super.testStateChange(Transport.State.FILE_CLOSED);
            this.parent.writeDocumentTrailer(this.xmlWriter);
            this.xmlWriter.close();
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new JournalException(e);
            }
            super.setState(Transport.State.FILE_CLOSED);
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    @Override
    public void shutdown() throws JournalException {
        super.testStateChange(Transport.State.SHUTDOWN);
        if (super.getState() != Transport.State.SHUTDOWN) {
            super.setState(Transport.State.SHUTDOWN);
        }
    }
}

