/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast.rmi;

import java.io.IOException;
import java.io.Writer;
import java.rmi.RemoteException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverHelper;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverInterface;

public class RmiTransportWriter
extends Writer {
    private final RmiJournalReceiverInterface receiver;
    private final String repositoryHash;
    private long itemIndex;
    private boolean m_closed = false;

    public RmiTransportWriter(RmiJournalReceiverInterface receiver, String repositoryHash, String filename) throws JournalException {
        this.receiver = receiver;
        this.repositoryHash = repositoryHash;
        try {
            receiver.openFile(repositoryHash, filename);
        }
        catch (RemoteException e) {
            throw new JournalException(e);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            String indexedHash = RmiJournalReceiverHelper.figureIndexedHash(this.repositoryHash, this.itemIndex);
            this.receiver.writeText(indexedHash, new String(cbuf, off, len));
            ++this.itemIndex;
        }
        catch (JournalException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.m_closed) {
                this.receiver.closeFile();
                this.m_closed = true;
            }
        }
        catch (JournalException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
    }
}

